/**
 * Copyright bkzen ( http://wonderfl.net/user/bkzen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jhAg
 */

package  
{
    import com.bit101.components.ColorChooser;
    import com.bit101.components.HBox;
    import com.bit101.components.InputText;
    import com.bit101.components.Label;
    import com.bit101.components.Panel;
    import com.bit101.components.PushButton;
    import com.bit101.components.Style;
    import com.bit101.components.VBox;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.utils.Dictionary;
    
    /**
     * search approximate color 
     * カラーパレット内から最近似色を探す。
     * @author jc at bk-zen.com
     */
    [SWF (backgroundColor = "0xFFFFFF", frameRate = "30", width = "465", height = "465")]
    public class ApproximateColorTest extends Sprite 
    {
        private var pallets: Vector.<Pallet>;
        private var palletDict: Dictionary;
        private var colorCh: ColorChooser;
        private var htmlColorRes: InputText;
        private var japaneseColorRes: InputText;
        private var worldColorRes: InputText;
        private var metroColorRes: InputText;
        private var xkcdColorRes: InputText;
        private var allColorRes: InputText;
        private var htmlColorResView: Panel;
        private var japaneseColorResView: Panel;
        private var worldColorResView: Panel;
        private var metroColorResView: Panel;
        private var xkcdColorResView: Panel;
        private var allColorResView: Panel;
        
        public function ApproximateColorTest() 
        {
            // パレットの初期化
            var i: int, n: int = ALL_COLORS.length;
            pallets = new Vector.<Pallet>(n, true);
            palletDict = new Dictionary();
            for (i = 0; i < n; i ++) { palletDict[ALL_COLORS[i]] = pallets[i] = Pallet.makeByObjects(ALL_COLORS[i]); }
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e: Event = null): void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // UI の作成
            var vbox: VBox = new VBox(this);
            var hbox: HBox = new HBox(vbox);
            var label: Label;
            colorCh = new ColorChooser(hbox, 0, 0, Math.random() * 0xFFFFFF);
            colorCh.usePopup = true;
            new PushButton(hbox, 0, 0, "Search", onChooseColor);
            hbox.draw();
            Style.embedFonts = false;
            Style.fontName = "_sans";
            Style.fontSize = 10;
            hbox = new HBox(vbox);
            new Label (hbox, 0, 0, "検索結果");
            hbox.draw();
            
            hbox = new HBox(vbox);
            label = new Label(hbox, 0, 0, "HTML COLOR\t: ");
            htmlColorResView = new Panel(hbox);
            htmlColorResView.setSize(15, 15);
            htmlColorResView.draw();
            htmlColorRes = new InputText(hbox, 0, 0, "");
            htmlColorRes.width = 300;
            hbox.draw();
            
            hbox = new HBox(vbox);
            label = new Label(hbox, 0, 0, "和色\t\t\t\t: ");
            japaneseColorResView = new Panel(hbox);
            japaneseColorResView.setSize(15, 15);
            japaneseColorResView.draw();
            japaneseColorRes = new InputText(hbox, 0,0,"");
            japaneseColorRes.width = 300;
            hbox.draw();
            
            hbox = new HBox(vbox);
            label = new Label(hbox, 0, 0, "洋色\t\t\t\t: ");
            worldColorResView = new Panel(hbox);
            worldColorResView.setSize(15, 15);
            worldColorResView.draw();
            worldColorRes = new InputText(hbox, 0, 0, "");
            worldColorRes.width = 300;
            hbox.draw();
            
            hbox = new HBox(vbox);
            label = new Label(hbox, 0, 0, "メトロカラー\t\t: ");
            metroColorResView = new Panel(hbox);
            metroColorResView.setSize(15, 15);
            metroColorResView.draw();
            metroColorRes = new InputText(hbox, 0, 0, "");
            metroColorRes.width = 300;
            hbox.draw();
            
            hbox = new HBox(vbox);
            label = new Label(hbox, 0, 0, "XKCD COLOR\t: ");
            xkcdColorResView = new Panel(hbox);
            xkcdColorResView.setSize(15, 15);
            xkcdColorResView.draw();
            xkcdColorRes = new InputText(hbox, 0, 0, "");
            xkcdColorRes.width = 300;
            hbox.draw();
            
            hbox = new HBox(vbox);
            label = new Label(hbox, 0, 0, "総合\t\t\t\t: ");
            allColorResView = new Panel(hbox);
            allColorResView.setSize(15, 15);
            allColorResView.draw();
            allColorRes = new InputText(hbox, 0, 0, "");
            allColorRes.width = 300;
            hbox.draw();
            
        }
        
        /**
         * 近似色を探す
         */
        private function onChooseColor(e: Event): void 
        {
            var c: PalletColor, p: Pallet, color: uint = colorCh.value, all: Array = [];
            p = palletDict[HTML_COLORS];
            c = p.getApproximateColor(color);
            all.push(c)
            htmlColorRes.text = c.name + " : " + c.color16;
            htmlColorResView.color = c.color;
            
            p = palletDict[JAPAN_COLORS];
            c = p.getApproximateColor(color);
            all.push(c)
            japaneseColorRes.text = c.name + " : " + c.color16;
            japaneseColorResView.color = c.color;
            
            p = palletDict[WORLD_COLORS];
            c = p.getApproximateColor(color);
            all.push(c)
            worldColorRes.text = c.name + " : " + c.color16;
            worldColorResView.color = c.color;
            
            p = palletDict[METRO_COLORS];
            c = p.getApproximateColor(color);
            all.push(c)
            metroColorRes.text = c.name + " : " + c.color16;
            metroColorResView.color = c.color;
            
            p = palletDict[XKCD_COLORS];
            c = p.getApproximateColor(color);
            all.push(c)
            xkcdColorRes.text = c.name + " : " + c.color16;
            xkcdColorResView.color = c.color;
            
            
            var r: uint = color >> 0x10 & 0xFF, g: uint = color >> 0x08 & 0xFF, b: uint = color >> 0x00 & 0xFF;
            var dr: int, dg: int, db: int, diff: Number, minDiff: Number = Number.MAX_VALUE;
            var i: int, near: PalletColor, length: int  = all.length;
            for (i = 0; i < length; i ++)
            {
                c = all[i];
                dr = r - c.r, dg = g - c.g, db = b - c.b;
                diff = Math.sqrt(dr * dr + dg * dg + db * db);
                if (minDiff > diff) minDiff = diff, near = c;
            }
            
            allColorRes.text = near.name + " : " + near.color16;
            allColorResView.color = near.color;
            
        }
    }
}

class Pallet
{
    private var _colors: Vector.<PalletColor>;
    public var length: int;
    function Pallet(colors: Vector.<PalletColor>)
    {
        _colors = colors;
        length = _colors.length;
    }
    
    public function getApproximateColor(color: uint): PalletColor
    {
        var r: uint = color >> 0x10 & 0xFF, g: uint = color >> 0x08 & 0xFF, b: uint = color >> 0x00 & 0xFF;
        var dr: int, dg: int, db: int, diff: Number, minDiff: Number = Number.MAX_VALUE;
        var i: int, c: PalletColor, near: PalletColor;
        for (i = 0; i < length; i ++)
        {
            c = _colors[i];
            dr = r - c.r, dg = g - c.g, db = b - c.b;
            diff = Math.sqrt(dr * dr + dg * dg + db * db);
            if (minDiff > diff) minDiff = diff, near = c;
        }
        return near;
    }
    
    public static function makeByObjects(arr: Array): Pallet
    {
        var n: int = arr.length, i: int, a: Array;
        var colors: Vector.<PalletColor> = new Vector.<PalletColor>(n, true);
        for (i = 0; i < n; i ++)
        {
            a = arr[i];
            colors[i] = new PalletColor(a[0], a[1]);
        }
        return new Pallet(colors);
    }
}

class PalletColor
{
    public var name: String;
    public var color: uint;
    public var color16: String;
    public var r: uint, g: uint, b: uint;
    function PalletColor(name: String, color: uint)
    {
        this.color = color, this.name = name, color16 = "0x" + align(color.toString(16).toUpperCase());
        r = color >> 0x10 & 0xFF, g = color >> 0x08 & 0xFF, b = color >> 0x00 & 0xFF;
    }
    
    private function align(val:String): String 
    {
        var i: int = val.length;
        for (; i < 6; i ++)
        {
            val = "0" + val;
        }
        return val;
    }
}
// html である色
const HTML_COLORS: Array = [
    ["black", 0x000000],            ["dimgray", 0x696969],              ["gray", 0x808080],              ["darkgray", 0xa9a9a9], 
    ["silver", 0xc0c0c0],           ["lightgrey", 0xd3d3d3],            ["gainsboro", 0xdcdcdc],         ["whitesmoke", 0xf5f5f5], 
    ["white", 0xffffff],            ["snow", 0xfffafa],                 ["ghostwhite", 0xf8f8ff],        ["floralwhite", 0xfffaf0], 
    ["linen", 0xfaf0e6],            ["antiquewhite", 0xfaebd7],         ["papayawhip", 0xffefd5],        ["blanchedalmond", 0xffebcd], 
    ["bisque", 0xffe4c4],           ["moccasin", 0xffe4b5],             ["navajowhite", 0xffdead],       ["peachpuff", 0xffdab9], 
    ["mistyrose", 0xffe4e1],        ["lavenderblush", 0xfff0f5],        ["seashell", 0xfff5ee],          ["oldlace", 0xfdf5e6], 
    ["ivory", 0xfffff0],            ["honeydew", 0xf0fff0],             ["mintcream", 0xf5fffa],         ["azure", 0xf0ffff], 
    ["aliceblue", 0xf0f8ff],        ["lavender", 0xe6e6fa],             ["lightsteelblue", 0xb0c4de],    ["lightslategray", 0x778899], 
    ["slategray", 0x708090],        ["steelblue", 0x4682b4],            ["royalblue", 0x4169e1],         ["midnightblue", 0x191970], 
    ["navy", 0x000080],             ["darkblue", 0x00008b],             ["mediumblue", 0x0000cd],        ["blue", 0x0000ff], 
    ["dodgerblue", 0x1e90ff],       ["cornflowerblue", 0x6495ed],       ["deepskyblue", 0x00bfff],       ["lightskyblue", 0x87cefa], 
    ["skyblue", 0x87ceeb],          ["lightblue", 0xadd8e6],            ["powderblue", 0xb0e0e6],        ["paleturquoise", 0xafeeee], 
    ["lightcyan", 0xe0ffff],        ["cyan", 0x00ffff],                 ["aqua", 0x00ffff],              ["turquoise", 0x40e0d0], 
    ["mediumturquoise", 0x48d1cc],  ["darkturquoise", 0x00ced1],        ["lightseagreen", 0x20b2aa],     ["cadetblue", 0x5f9ea0], 
    ["darkcyan", 0x008b8b],         ["teal", 0x008080],                 ["darkslategray", 0x2f4f4f],     ["darkgreen", 0x006400], 
    ["green", 0x008000],            ["forestgreen", 0x228b22],          ["seagreen", 0x2e8b57],          ["mediumseagreen", 0x3cb371], 
    ["mediumaquamarine", 0x66cdaa], ["darkseagreen", 0x8fbc8f],         ["aquamarine", 0x7fffd4],        ["palegreen", 0x98fb98], 
    ["lightgreen", 0x90ee90],       ["springgreen", 0x00ff7f],          ["mediumspringgreen", 0x00fa9a], ["lawngreen", 0x7cfc00], 
    ["chartreuse", 0x7fff00],       ["greenyellow", 0xadff2f],          ["lime", 0x00ff00],              ["limegreen", 0x32cd32], 
    ["yellowgreen", 0x9acd32],      ["darkolivegreen", 0x556b2f],       ["olivedrab", 0x6b8e23],         ["olive", 0x808000], 
    ["darkkhaki", 0xbdb76b],        ["palegoldenrod", 0xeee8aa],        ["cornsilk", 0xfff8dc],          ["beige", 0xf5f5dc], 
    ["lightyellow", 0xffffe0],      ["lightgoldenrodyellow", 0xfafad2], ["lemonchiffon", 0xfffacd],      ["wheat", 0xf5deb3], 
    ["burlywood", 0xdeb887],        ["tan", 0xd2b48c],                  ["khaki", 0xf0e68c],             ["yellow", 0xffff00], 
    ["gold", 0xffd700],             ["orange", 0xffa500],               ["sandybrown", 0xf4a460],        ["darkorange", 0xff8c00], 
    ["goldenrod", 0xdaa520],        ["peru", 0xcd853f],                 ["darkgoldenrod", 0xb8860b],     ["chocolate", 0xd2691e], 
    ["sienna", 0xa0522d],           ["saddlebrown", 0x8b4513],          ["maroon", 0x800000],            ["darkred", 0x8b0000], 
    ["brown", 0xa52a2a],            ["firebrick", 0xb22222],            ["indianred", 0xcd5c5c],         ["rosybrown", 0xbc8f8f], 
    ["darksalmon", 0xe9967a],       ["lightcoral", 0xf08080],           ["salmon", 0xfa8072],            ["lightsalmon", 0xffa07a], 
    ["coral", 0xff7f50],            ["tomato", 0xff6347],               ["orangered", 0xff4500],         ["red", 0xff0000], 
    ["crimson", 0xdc143c],          ["mediumvioletred", 0xc71585],      ["deeppink", 0xff1493],          ["hotpink", 0xff69b4], 
    ["palevioletred", 0xdb7093],    ["pink", 0xffc0cb],                 ["lightpink", 0xffb6c1],         ["thistle", 0xd8bfd8], 
    ["magenta", 0xff00ff],          ["fuchsia", 0xff00ff],              ["violet", 0xee82ee],            ["plum", 0xdda0dd], 
    ["orchid", 0xda70d6],           ["mediumorchid", 0xba55d3],         ["darkorchid", 0x9932cc],        ["darkviolet", 0x9400d3], 
    ["darkmagenta", 0x8b008b],      ["purple", 0x800080],               ["indigo", 0x4b0082],            ["darkslateblue", 0x483d8b], 
    ["blueviolet", 0x8a2be2],       ["mediumpurple", 0x9370db],         ["slateblue", 0x6a5acd],         ["mediumslateblue", 0x7b68ee]
];
// 和色
const JAPAN_COLORS: Array = [
    ["桜色さくらいろ", 0xfef4f4],             ["薄桜うすざくら", 0xfdeff2],           ["桜鼠さくらねず", 0xe9dfe5], 
    ["鴇鼠ときねず", 0xe4d2d8],               ["虹色にじいろ", 0xf6bfbc],             ["珊瑚色さんごいろ", 0xf5b1aa], 
    ["一斤染いっこんぞめ", 0xf5b199],         ["宍色ししいろ", 0xefab93],             ["紅梅色こうばいいろ", 0xf2a0a1], 
    ["薄紅うすべに", 0xf0908d],               ["甚三紅じんざもみ", 0xee827c],         ["桃色ももいろ", 0xf09199], 
    ["鴇色ときいろ", 0xf4b3c2],               ["撫子色なでしこいろ", 0xeebbcb],       ["灰梅はいうめ", 0xe8d3c7], 
    ["灰桜はいざくら", 0xe8d3d1],             ["淡紅藤あわべにふじ", 0xe6cde3],       ["石竹色せきちくいろ", 0xe5abbe], 
    ["薄紅梅うすこうばい", 0xe597b2],         ["桃花色ももはないろ", 0xe198b4],       ["水柿みずがき", 0xe4ab9b], 
    ["ときがら茶ときがらちゃ", 0xe09e87],     ["退紅あらぞめ", 0xd69090],             ["薄柿うすがき", 0xd4acad], 
    ["長春色ちょうしゅんいろ", 0xc97586],     ["梅鼠うめねず", 0xc099a0],             ["鴇浅葱ときあさぎ", 0xb88884], 
    ["梅染うめぞめ", 0xb48a76],               ["蘇芳香すおうこう", 0xa86965],         ["浅蘇芳あさすおう", 0xa25768], 
    ["真朱まそお", 0xec6d71],                 ["赤紫あかむらさき", 0xeb6ea5],         ["躑躅色つつじいろ", 0xe95295], 
    ["牡丹色ぼたんいろ", 0xe7609e],           ["今様色いまよういろ", 0xd0576b],       ["中紅なかべに", 0xc85179], 
    ["薔薇色ばらいろ", 0xe9546b],             ["韓紅からくれない", 0xe95464],         ["銀朱ぎんしゅ", 0xc85554], 
    ["赤紅あかべに", 0xc53d43],               ["紅緋べにひ", 0xe83929],               ["赤あか", 0xe60033], 
    ["猩々緋しょうじょうひ", 0xe2041b],       ["紅くれない", 0xd7003a],               ["深緋こきひ", 0xc9171e], 
    ["緋色ひいろ", 0xd3381c],                 ["赤丹あかに", 0xce5242],               ["紅赤べにあか", 0xd9333f], 
    ["臙脂えんじ", 0xb94047],                 ["朱・緋あけ", 0xba2636],               ["茜色あかねいろ", 0xb7282e], 
    ["紅海老茶べにえびちゃ", 0xa73836],       ["蘇芳すおう", 0x9e3d3f],               ["真紅しんく", 0xa22041], 
    ["濃紅こいくれない", 0xa22041],           ["象牙色ぞうげいろ", 0xf8f4e6],         ["練色ねりいろ", 0xede4cd], 
    ["灰白色かいはくしょく", 0xe9e4d4],       ["蒸栗色むしぐりいろ", 0xebe1a9],       ["女郎花おみなえし", 0xf2f2b0], 
    ["枯草色かれくさいろ", 0xe4dc8a],         ["淡黄たんこう", 0xf8e58c],             ["白茶しらちゃ", 0xddbb99], 
    ["赤白橡あかしろつるばみ", 0xd7a98c],     ["洗柿あらいがき", 0xf2c9ac],           ["鳥の子色とりのこいろ", 0xfff1cf], 
    ["蜂蜜色はちみついろ", 0xfddea5],         ["肌色はだいろ", 0xfce2c4],             ["薄卵色うすたまごいろ", 0xfde8d0], 
    ["雄黄ゆうおう", 0xf9c89b],               ["洒落柿しゃれがき", 0xf7bd8f],         ["赤香あかこう", 0xf6b894], 
    ["砥粉色とのこいろ", 0xf4dda5],           ["肉色にくいろ", 0xf1bf99],             ["人色ひといろ", 0xf1bf99], 
    ["丁子色ちょうじいろ", 0xefcd9a],         ["香色こういろ", 0xefcd9a],             ["薄香うすこう", 0xf0cfa0], 
    ["浅黄うすき", 0xedd3a1],                 ["枯色かれいろ", 0xe0c38c],             ["淡香うすこう", 0xf3bf88], 
    ["杏色あんずいろ", 0xf7b977],             ["東雲色しののめいろ", 0xf19072],       ["曙色あけぼのいろ", 0xf19072], 
    ["珊瑚朱色さんごしゅいろ", 0xee836f],     ["深支子こきくちなし", 0xeb9b6f],       ["纁そひ", 0xe0815e], 
    ["浅緋うすきひ", 0xdf7163],               ["真赭まそほ", 0xd57c6b],               ["洗朱あらいしゅ", 0xd0826c], 
    ["遠州茶えんしゅうちゃ", 0xca8269],       ["紅樺色べにかばいろ", 0xbb5548],       ["赭そほ", 0xab6953], 
    ["小豆色あずきいろ", 0x96514d],           ["枯茶からちゃ", 0x8d6449],             ["飴色あめいろ", 0xdeb068], 
    ["駱駝色らくだいろ", 0xbf794e],           ["土色つちいろ", 0xbc763c],             ["黄唐茶きがらちゃ", 0xb98c46], 
    ["桑染くわぞめ", 0xb79b5b],               ["櫨色はじいろ", 0xb77b57],             ["黄橡きつるばみ", 0xb68d4c], 
    ["丁字染ちょうじぞめ", 0xad7d4c],         ["香染こうぞめ", 0xad7d4c],             ["枇杷茶びわちゃ", 0xae7c4f], 
    ["芝翫茶しかんちゃ", 0xad7e4e],           ["焦香こがれこう", 0xae7c58],           ["胡桃色くるみいろ", 0xa86f4c], 
    ["渋紙色しぶかみいろ", 0x946243],         ["朽葉色くちばいろ", 0x917347],         ["桑茶くわちゃ", 0x956f29], 
    ["路考茶ろこうちゃ", 0x8c7042],           ["国防色こくぼうしょく", 0x7b6c3e],     ["伽羅色きゃらいろ", 0xd8a373], 
    ["江戸茶えどちゃ", 0xcd8c5c],             ["樺色かばいろ", 0xcd5e3c],             ["紅鬱金べにうこん", 0xcb8347], 
    ["土器色かわらけいろ", 0xc37854],         ["狐色きつねいろ", 0xc38743],           ["黄土色おうどいろ", 0xc39143], 
    ["琥珀色こはくいろ", 0xbf783a],           ["赤茶あかちゃ", 0xbb5535],             ["代赭たいしゃ", 0xbb5520], 
    ["煉瓦色れんがいろ", 0xb55233],           ["雀茶すずめちゃ", 0xaa4f37],           ["団十郎茶だんじゅうろうちゃ", 0x9f563a], 
    ["柿渋色かきしぶいろ", 0x9f563a],         ["紅鳶べにとび", 0x9a493f],             ["灰茶はいちゃ", 0x98623c], 
    ["茶色ちゃいろ", 0x965042],               ["檜皮色ひわだいろ", 0x965036],         ["鳶色とびいろ", 0x95483f], 
    ["柿茶かきちゃ", 0x954e2a],               ["弁柄色べんがらいろ", 0x8f2e14],       ["赤錆色あかさびいろ", 0x8a3319], 
    ["褐色かっしょく", 0x8a3b00],             ["栗梅くりうめ", 0x852e19],             ["紅檜皮べにひはだ", 0x7b4741], 
    ["海老茶えびちゃ", 0x773c30],             ["唐茶からちゃ", 0x783c1d],             ["栗色くりいろ", 0x762f07], 
    ["赤銅色しゃくどういろ", 0x752100],       ["錆色さびいろ", 0x6c3524],             ["赤褐色せっかっしょく", 0x683f36], 
    ["茶褐色ちゃかっしょく", 0x664032],       ["栗皮茶くりかわちゃ", 0x6d3c32],       ["黒茶くろちゃ", 0x583822], 
    ["葡萄茶えびちゃ", 0x6c2c2f],             ["葡萄色えびいろ", 0x640125],           ["萱草色かんぞういろ", 0xf8b862], 
    ["柑子色こうじいろ", 0xf6ad49],           ["金茶きんちゃ", 0xf39800],             ["蜜柑色みかんいろ", 0xf08300], 
    ["鉛丹色えんたんいろ", 0xec6d51],         ["黄丹おうに", 0xee7948],               ["柿色かきいろ", 0xed6d3d], 
    ["黄赤きあか", 0xec6800],                 ["人参色にんじんいろ", 0xec6800],       ["橙色だいだいいろ", 0xee7800], 
    ["照柿てりがき", 0xeb6238],               ["赤橙あかだいだい", 0xea5506],         ["金赤きんあか", 0xea5506], 
    ["朱色しゅいろ", 0xeb6101],               ["小麦色こむぎいろ", 0xe49e61],         ["丹色にいろ", 0xe45e32], 
    ["黄茶きちゃ", 0xe17b34],                 ["肉桂色にっけいいろ", 0xdd7a56],       ["赤朽葉色あかくちばいろ", 0xdb8449], 
    ["黄櫨染こうろぜん", 0xd66a35],           ["蒲公英色たんぽぽいろ", 0xffd900],     ["黄色きいろ", 0xffd900], 
    ["中黄ちゅうき", 0xffea00],               ["菜の花色なのはないろ", 0xffec47],     ["黄檗色きはだいろ", 0xfef263], 
    ["卵色たまごいろ", 0xfcd575],             ["花葉色はなばいろ", 0xfbd26b],         ["刈安色かりやすいろ", 0xf5e56b], 
    ["玉蜀黍色とうもろこしいろ", 0xeec362],   ["金糸雀色かなりあいろ", 0xebd842],     ["黄支子色きくちなしいろ", 0xffdb4f], 
    ["支子色くちなしいろ", 0xfbca4d],         ["向日葵色ひまわりいろ", 0xfcc800],     ["山吹色やまぶきいろ", 0xf8b500], 
    ["鬱金色うこんいろ", 0xfabf14],           ["藤黄とうおう", 0xf7c114],             ["金色こんじき", 0xe6b422], 
    ["黄金こがね", 0xe6b422],                 ["櫨染はじぞめ", 0xd9a62e],             ["黄朽葉色きくちばいろ", 0xd3a243], 
    ["山吹茶やまぶきちゃ", 0xc89932],         ["芥子色からしいろ", 0xd0af4c],         ["豆がら茶まめがらちゃ", 0x8b968d], 
    ["麹塵きくじん", 0x6e7955],               ["山鳩色やまばといろ", 0x767c6b],       ["利休鼠りきゅうねずみ", 0x888e7e], 
    ["海松茶みるちゃ", 0x5a544b],             ["藍海松茶あいみるちゃ", 0x56564b],     ["藍媚茶あいこびちゃ", 0x555647], 
    ["千歳茶せんさいちゃ", 0x494a41],         ["岩井茶いわいちゃ", 0x6b6f59],         ["仙斎茶せんさいちゃ", 0x474b42], 
    ["黒緑くろみどり", 0x333631],             ["柳煤竹やなぎすすたけ", 0x5b6356],     ["樺茶色かばちゃいろ", 0x726250], 
    ["空五倍子色うつぶしいろ", 0x9d896c],     ["生壁色なまかべいろ", 0x94846a],       ["肥後煤竹ひごすすたけ", 0x897858], 
    ["媚茶こびちゃ", 0x716246],               ["白橡しろつるばみ", 0xcbb994],         ["亜麻色あまいろ", 0xd6c6af], 
    ["榛色はしばみいろ", 0xbfa46f],           ["灰汁色あくいろ", 0x9e9478],           ["利休茶りきゅうちゃ", 0xa59564], 
    ["鶯茶うぐいすちゃ", 0x715c1f],           ["木蘭色もくらんじき", 0xc7b370],       ["砂色すないろ", 0xdcd3b2], 
    ["油色あぶらいろ", 0xa19361],             ["利休色りきゅういろ", 0x8f8667],       ["梅幸茶ばいこうちゃ", 0x887938], 
    ["璃寛茶りかんちゃ", 0x6a5d21],           ["黄海松茶きみるちゃ", 0x918754],       ["菜種油色なたねゆいろ", 0xa69425], 
    ["青朽葉あおくちば", 0xada250],           ["根岸色ねぎしいろ", 0x938b4b],         ["鶸茶ひわちゃ", 0x8c8861], 
    ["柳茶やなぎちゃ", 0xa1a46d],             ["海松色みるいろ", 0x726d40],           ["鶯色うぐいすいろ", 0x928c36], 
    ["緑黄色りょくおうしょく", 0xdccb18],     ["鶸色ひわいろ", 0xd7cf3a],             ["抹茶色まっちゃいろ", 0xc5c56a], 
    ["若草色わかくさいろ", 0xc3d825],         ["黄緑きみどり", 0xb8d200],             ["若芽色わかめいろ", 0xe0ebaf], 
    ["若菜色わかないろ", 0xd8e698],           ["若苗色わかなえいろ", 0xc7dc68],       ["青丹あおに", 0x99ab4e], 
    ["草色くさいろ", 0x7b8d42],               ["苔色こけいろ", 0x69821b],             ["萌黄もえぎ", 0xaacf53], 
    ["苗色なえいろ", 0xb0ca71],               ["若葉色わかばいろ", 0xb9d08b],         ["松葉色まつばいろ", 0x839b5c], 
    ["夏虫色なつむしいろ", 0xcee4ae],         ["鶸萌黄ひわもえぎ", 0x82ae46],         ["柳色やなぎいろ", 0xa8c97f], 
    ["青白橡あおしろつるばみ", 0x9ba88d],     ["柳鼠やなぎねず", 0xc8d5bb],           ["裏葉柳うらはやなぎ", 0xc1d8ac], 
    ["山葵色わさびいろ", 0xa8bf93],           ["老竹色おいたけいろ", 0x769164],       ["白緑びゃくろく", 0xd6e9ca], 
    ["淡萌黄うすもえぎ", 0x93ca76],           ["柳染やなぎぞめ", 0x93b881],           ["薄萌葱うすもえぎ", 0xbadcad], 
    ["深川鼠ふかがわねずみ", 0x97a791],       ["若緑わかみどり", 0x98d98e],           ["浅緑あさみどり", 0x88cb7f], 
    ["薄緑うすみどり", 0x69b076],             ["青鈍あおにび", 0x6b7b6e],             ["青磁鼠せいじねず", 0xbed2c3], 
    ["薄青うすあお", 0x93b69c],               ["錆青磁さびせいじ", 0xa6c8b2],         ["緑青色ろくしょういろ", 0x47885e], 
    ["千歳緑ちとせみどり", 0x316745],         ["若竹色わかたけいろ", 0x68be8d],       ["緑みどり", 0x3eb370], 
    ["常磐色ときわいろ", 0x007b43],           ["千草鼠ちぐさねず", 0xbed3ca],         ["千草色ちぐさいろ", 0x92b5a9], 
    ["青磁色せいじいろ", 0x7ebea5],           ["青竹色あおたけいろ", 0x7ebeab],       ["常磐緑ときわみどり", 0x028760], 
    ["木賊色とくさいろ", 0x3b7960],           ["天鵞絨びろうど", 0x2f5d50],           ["虫襖むしあお", 0x3a5b52], 
    ["革色かわいろ", 0x475950],               ["深緑ふかみどり", 0x00552e],           ["鉄色てついろ", 0x005243], 
    ["萌葱色もえぎいろ", 0x006e54],           ["花緑青はなろくしょう", 0x00a381],     ["翡翠色ひすいいろ", 0x38b48b], 
    ["青緑あおみどり", 0x00a497],             ["水浅葱みずあさぎ", 0x80aba9],         ["錆浅葱さびあさぎ", 0x5c9291], 
    ["青碧せいへき", 0x478384],               ["御召茶おめしちゃ", 0x43676b],         ["湊鼠みなとねずみ", 0x80989b], 
    ["高麗納戸こうらいなんど", 0x2c4f54],     ["百入茶ももしおちゃ", 0x1f3134],       ["錆鼠さびねず", 0x47585c], 
    ["錆鉄御納戸さびてつおなんど", 0x485859], ["藍鼠あいねず", 0x6c848d],             ["錆御納戸さびおなんど", 0x53727d], 
    ["舛花色ますはないろ", 0x5b7e91],         ["熨斗目花色のしめはないろ", 0x426579], ["御召御納戸おめしおなんど", 0x4c6473], 
    ["鉄御納戸てつおなんど", 0x455765],       ["紺鼠こんねず", 0x44617b],             ["藍鉄あいてつ", 0x393f4c], 
    ["青褐あおかち", 0x393e4f],               ["褐返かちかえし", 0x203744],           ["褐色かちいろ", 0x4d4c61], 
    ["月白げっぱく", 0xeaf4fc],               ["白菫色しろすみれいろ", 0xeaedf7],     ["白花色しらはないろ", 0xe8ecef], 
    ["藍白あいじろ", 0xebf6f7],               ["白藍しらあい", 0xc1e4e9],             ["水色みずいろ", 0xbce2e8], 
    ["瓶覗かめのぞき", 0xa2d7dd],             ["秘色色ひそくいろ", 0xabced8],         ["空色そらいろ", 0xa0d8ef], 
    ["勿忘草色わすれなぐさいろ", 0x89c3eb],   ["青藤色あおふじいろ", 0x84a2d4],       ["白群びゃくぐん", 0x83ccd2], 
    ["浅縹あさはなだ", 0x84b9cb],             ["薄花色うすはないろ", 0x698aab],       ["納戸色なんどいろ", 0x008899], 
    ["浅葱色あさぎいろ", 0x00a3af],           ["花浅葱はなあさぎ", 0x2a83a2],         ["新橋色しんばしいろ", 0x59b9c6], 
    ["天色あまいろ", 0x2ca9e1],               ["露草色つゆくさいろ", 0x38a1db],       ["青あお", 0x0095d9], 
    ["薄藍うすあい", 0x0094c8],               ["縹色はなだいろ", 0x2792c3],           ["紺碧こんぺき", 0x007bbb], 
    ["薄群青うすぐんじょう", 0x5383c3],       ["薄花桜うすはなざくら", 0x5a79ba],     ["群青色ぐんじょういろ", 0x4c6cb3], 
    ["杜若色かきつばたいろ", 0x3e62ad],       ["瑠璃色るりいろ", 0x1e50a2],           ["薄縹うすはなだ", 0x507ea4], 
    ["瑠璃紺るりこん", 0x19448e],             ["紺瑠璃こんるり", 0x164a84],           ["藍色あいいろ", 0x165e83], 
    ["青藍せいらん", 0x274a78],               ["深縹こきはなだ", 0x2a4073],           ["紺色こんいろ", 0x223a70], 
    ["紺青こんじょう", 0x192f60],             ["留紺とめこん", 0x1c305c],             ["濃藍こいあい", 0x0f2350], 
    ["鉄紺てつこん", 0x17184b],               ["漆黒しっこく", 0x0d0015],             ["淡藤色あわふじいろ", 0xbbc8e6], 
    ["藤色ふじいろ", 0xbbbcde],               ["紅掛空色べにかけそらいろ", 0x8491c3], ["紅碧べにみどり", 0x8491c3], 
    ["紺桔梗こんききょう", 0x4d5aaf],         ["花色はないろ", 0x4d5aaf],             ["紺藍こんあい", 0x4a488e], 
    ["紅桔梗べにききょう", 0x4d4398],         ["桔梗色ききょういろ", 0x5654a2],       ["藤納戸ふじなんど", 0x706caa], 
    ["紅掛花色べにかけはないろ", 0x68699b],   ["紫苑色しおんいろ", 0x867ba9],         ["白藤色しらふじいろ", 0xdbd0e6], 
    ["藤紫ふじむらさき", 0xa59aca],           ["菫色すみれいろ", 0x7058a3],           ["青紫あおむらさき", 0x674598], 
    ["菖蒲色しょうぶいろ", 0x674196],         ["竜胆色りんどういろ", 0x9079ad],       ["江戸紫えどむらさき", 0x745399], 
    ["本紫ほんむらさき", 0x65318e],           ["葡萄色ぶどういろ", 0x522f60],         ["深紫ふかむらさき", 0x493759], 
    ["紫黒しこく", 0x2e2930],                 ["紫むらさき", 0x884898],               ["薄葡萄うすぶどう", 0xc0a2c7], 
    ["紫紺しこん", 0x460e44],                 ["暗紅色あんこうしょく", 0x74325c],     ["桑の実色くわのみいろ", 0x55295b], 
    ["古代紫こだいむらさき", 0x895b8a],       ["茄子紺なすこん", 0x824880],           ["二藍ふたあい", 0x915c8b], 
    ["京紫きょうむらさき", 0x9d5b8b],         ["蒲葡えびぞめ", 0x7a4171],             ["若紫わかむらさき", 0xbc64a4], 
    ["紅紫べにむらさき", 0xb44c97],           ["梅紫うめむらさき", 0xaa4c8f],         ["菖蒲色あやめいろ", 0xcc7eb1], 
    ["紅藤色べにふじいろ", 0xcca6bf],         ["浅紫あさむらさき", 0xc4a3bf],         ["紫水晶むらさきすいしょう", 0xe7e7eb], 
    ["薄梅鼠うすうめねず", 0xdcd6d9],         ["暁鼠あかつきねず", 0xd3cfd9],         ["牡丹鼠ぼたんねず", 0xd3ccd6], 
    ["霞色かすみいろ", 0xc8c2c6],             ["藤鼠ふじねず", 0xa6a5c4],             ["半色はしたいろ", 0xa69abd], 
    ["薄色うすいろ", 0xa89dac],               ["薄鼠うすねず", 0x9790a4],             ["鳩羽鼠はとばねずみ", 0x9e8b8e], 
    ["鳩羽色はとばいろ", 0x95859c],           ["桔梗鼠ききょうねず", 0x95949a],       ["紫鼠むらさきねず", 0x71686c], 
    ["葡萄鼠ぶどうねずみ", 0x705b67],         ["濃色こきいろ", 0x634950],             ["紫鳶むらさきとび", 0x5f414b], 
    ["濃鼠こいねず", 0x4f455c],               ["藤煤竹ふじすすたけ", 0x5a5359],       ["滅紫けしむらさき", 0x594255], 
    ["紅消鼠べにけしねずみ", 0x524748],       ["似せ紫にせむらさき", 0x513743],       ["灰黄緑はいきみどり", 0xe6eae3], 
    ["蕎麦切色そばきりいろ", 0xd4dcd6],       ["薄雲鼠うすくもねず", 0xd4dcda],       ["枯野色かれのいろ", 0xd3cbc6], 
    ["潤色うるみいろ", 0xc8c2be],             ["利休白茶りきゅうしろちゃ", 0xb3ada0], ["茶鼠ちゃねずみ", 0xa99e93], 
    ["胡桃染くるみぞめ", 0xa58f86],           ["江戸鼠えどねず", 0x928178],           ["煤色すすいろ", 0x887f7a], 
    ["丁子茶ちょうじちゃ", 0xb4866b],         ["柴染ふしぞめ", 0xb28c6e],             ["宗伝唐茶そうでんからちゃ", 0xa16d5d], 
    ["砺茶とのちゃ", 0x9f6f55],               ["煎茶色せんちゃいろ", 0x8c6450],       ["銀煤竹ぎんすすだけ", 0x856859], 
    ["黄枯茶きがらちゃ", 0x765c47],           ["煤竹色すすたけいろ", 0x6f514c],       ["焦茶こげちゃ", 0x6f4b3e], 
    ["黒橡くろつるばみ", 0x544a47],           ["憲法色けんぽういろ", 0x543f32],       ["涅色くりいろ", 0x554738], 
    ["檳榔子染びんろうじぞめ", 0x433d3c],     ["黒鳶くろとび", 0x432f2f],             ["赤墨あかすみ", 0x3f312b], 
    ["黒紅くろべに", 0x302833],               ["白しろ", 0xffffff],                   ["胡粉色ごふんいろ", 0xfffffc], 
    ["卯の花色うのはないろ", 0xf7fcfe],       ["白磁はくじ", 0xf8fbf8],               ["生成り色きなりいろ", 0xfbfaf5], 
    ["乳白色にゅうはくしょく", 0xf3f3f3],     ["白練しろねり", 0xf3f3f2],             ["素色そしょく", 0xeae5e3], 
    ["白梅鼠しらうめねず", 0xe5e4e6],         ["白鼠しろねず", 0xdcdddd],             ["絹鼠きぬねず", 0xdddcd6], 
    ["灰青はいあお", 0xc0c6c9],               ["銀鼠ぎんねず", 0xafafb0],             ["薄鈍うすにび", 0xadadad], 
    ["薄墨色うすずみいろ", 0xa3a3a2],         ["錫色すずいろ", 0x9ea1a3],             ["素鼠すねずみ", 0x9fa0a0], 
    ["鼠色ねずみいろ", 0x949495],             ["源氏鼠げんじねず", 0x888084],         ["灰色はいいろ", 0x7d7d7d], 
    ["鉛色なまりいろ", 0x7b7c7d],             ["鈍色にびいろ", 0x727171],             ["墨すみ", 0x595857], 
    ["丼鼠どぶねずみ", 0x595455],             ["消炭色けしずみいろ", 0x524e4d],       ["藍墨茶あいすみちゃ", 0x474a4d], 
    ["羊羹色ようかんいろ", 0x383c3c],         ["蝋色ろういろ", 0x2b2b2b],             ["黒くろ", 0x2b2b2b], 
    ["烏羽色からすばいろ", 0x180614],         ["鉄黒てつぐろ", 0x281a14],             ["濡羽色ぬればいろ", 0x000b00], 
    ["黒檀こくたん", 0x250d00],               ["憲法黒茶けんぽうくろちゃ", 0x241a08], ["暗黒色あんこくしょく", 0x16160e]
];
// 洋色
const WORLD_COLORS: Array = [
    ["コーラルレッドcoral red", 0xef857d],                   ["ポピーレッドpoppy red", 0xea5550], 
    ["レッドred", 0xea5550],                                 ["トマトレッドtomato red", 0xea5549], 
    ["バーミリオンvermilion", 0xea553a],                     ["スカーレットscarlet", 0xea5532], 
    ["キャロットオレンジcarrot orange", 0xed6d35],           ["チャイニーズレッドchinese red", 0xed6d46], 
    ["テラコッタterracotta", 0xbd6856],                      ["ココアブラウンcocoa brown", 0x98605e], 
    ["マホガニーmahogany", 0x6b3f31],                        ["チョコレートchocolate", 0x6c3524], 
    ["マルーンmarron", 0x6a1917],                            ["セピアsepia", 0x622d18], 
    ["コーヒー色coffee", 0x7b5544],                          ["ブラウンbrown", 0x8f6552], 
    ["バーントシェンナburnt sienna", 0xbb5535],              ["アンバーローズamber rose", 0xe6bfb2], 
    ["ベージュローゼbeige rose", 0xe8d3ca],                  ["サーモンピンクsalmon pink", 0xf3a68c], 
    ["サハラsahara", 0xe29676],                              ["アッシュローズash rose", 0xe6bfab], 
    ["シェルピンクshell pink", 0xfbdac8],                    ["ベビーピンクbaby pink", 0xfdede4], 
    ["ネールピンクnail pink", 0xfce4d6],                     ["ローシェンナraw sienna", 0xe17b34], 
    ["キャラメルcaramel", 0xbc611e],                         ["サンセットsunset", 0xf6b483], 
    ["シナモンcinnamon", 0xbe8f68],                          ["タンtan", 0xbf783e], 
    ["シャンパンchampagne", 0xe9dacb],                       ["ピーチpeach", 0xfbd8b5], 
    ["カフェオレcafe au lait", 0x946c45],                    ["オレンジorange", 0xee7800], 
    ["アプリコットapricot", 0xf7b977],                       ["アンバーamber", 0xc2894b], 
    ["ブロンズbronze", 0xac6b25],                            ["ヴァニラvanilla", 0xe8c59c], 
    ["コルクcork", 0xc49a6a],                                ["バーントアンバーburnt umber", 0x6f5436], 
    ["ローアンバーraw umber", 0x866629],                     ["フレッシュflesh", 0xfad09e], 
    ["ゴールデンイエローgolden yellow", 0xf6ae54],           ["マンダリンオレンジmandarin orange", 0xf3981d], 
    ["マリーゴールドmarigold", 0xf39800],                    ["エクルベージュecru beige", 0xf6e5cc], 
    ["オイスターoyster", 0xeae1cf],                          ["オーカーochre", 0xba8b40], 
    ["カーキーkhaki", 0xc5a05a],                             ["バフbuff", 0xcaac71], 
    ["サフランイエローsaffron yellow", 0xfac559],            ["パンプキンpumpkin", 0xe5a323], 
    ["イエローオーカーyellow ocher", 0xc4972f],              ["ブロンドblond", 0xf2d58a], 
    ["ベージュbeige", 0xeedcb3],                             ["ビスケットbiscuit", 0xead7a4], 
    ["レグホーンleghorn", 0xffe9a9],                         ["サンシャインイエローsunshine yellow", 0xffedab], 
    ["クリームイエローcream yellow", 0xfff3b8],              ["ネープルスイエローnaples yellow", 0xfdd35c], 
    ["トパーズtopaz", 0xe9bc00],                             ["クロムイエローchrome yellow", 0xfcc800], 
    ["クリームcream", 0xe3d7a3],                             ["ストローstraw", 0xece093], 
    ["ジャスミンイエローjasmine yellow", 0xedde7b],          ["アンティックゴールドantique gold", 0xc1ab05], 
    ["オリーブolive", 0x72640c],                             ["オリーブドラブolive drab", 0x665a1a], 
    ["ジョンブリアンjaune brillant", 0xffdc00],              ["イエローyellow", 0xffdc00], 
    ["シトラスcitrus", 0xeddc44],                            ["ライムライトlimelight", 0xfff799], 
    ["カナリヤcanary yellow", 0xfff462],                     ["ミモザmimosa", 0xfff462], 
    ["レモンイエローlemon yellow", 0xfff352],                ["メロンイエローmelon yellow", 0xe0de94], 
    ["シャルトルーズイエローchartreuse yellow", 0xe3e548],   ["ライムイエローlime yellow", 0xeaeea2], 
    ["ライムグリーンlime green", 0xe6eb94],                  ["シャトルーズグリーンchartreuse green", 0xd9e367], 
    ["レタスグリーンlettuce green", 0xd1de4c],               ["オリーブグリーンolive green", 0x5f6527], 
    ["モスグリーンmoss green", 0x777e41],                    ["グラスグリーンgrass green", 0x7b8d42], 
    ["スプリンググリーンspring green", 0x9cbb1c],            ["リーフグリーンleaf green", 0x9fc24d], 
    ["ホワイトリリーwhite lily", 0xf0f6da],                  ["アスパラガスグリーンasparagus green", 0xdbebc4], 
    ["シトロングリーンcitron green", 0x618e34],              ["メドウグリーンmeadow green", 0x65ab31], 
    ["アップルグリーンapple green", 0xa7d28d],               ["アイビーグリーンivy green", 0x578a3d], 
    ["スピナッチグリーンspinach green", 0x417038],           ["カクタスcactus", 0x387d39], 
    ["スカイグリーンsky green", 0xbee0c2],                   ["スペアミントspearmint", 0x79c06e], 
    ["ミントグリーンmint green", 0x89c997],                  ["パロットグリーンparrot green", 0x37a34a], 
    ["サマーグリーンsummer green", 0x009944],                ["オパールグリーンopal green", 0xbee0ce], 
    ["スプレイグリーンspray green", 0xa4d5bd],               ["ボトルグリーンbottle green", 0x004d25], 
    ["コバルトグリーンcobalt green", 0x3cb37a],              ["エバーグリーンevergreen", 0x00984f], 
    ["マラカイトグリーンmalachite green", 0x009854],         ["グリーンgreen", 0x00a960], 
    ["エメラルドグリーンemerald green", 0x00a968],           ["フォレストグリーンforest green", 0x288c66], 
    ["ビリジアンviridian", 0x00885a],                        ["ホーリーグリーンholly green", 0x006948], 
    ["ビリヤードグリーンbilliard green", 0x005c42],          ["クロムグリーンchrome green", 0x00533f], 
    ["アンティークグリーンantique green", 0x54917f],         ["ウォーターグリーンwater green", 0xa5c9c1], 
    ["アイスグリーンice green", 0xa3d6cc],                   ["ターコイズグリーンturquoise green", 0x00947a], 
    ["シーグリーンsea green", 0x00ac97],                     ["ペパーミントグリーンpeppermint green", 0x00ac9a], 
    ["ピーコックグリーンpeacock green", 0x00a497],           ["ナイルブルーnile blue", 0x2cb4ad], 
    ["サックスブルーsaxe blue", 0x418b89],                   ["スレートグリーンslate green", 0x3c7170], 
    ["テールグリーンteal green", 0x006a6c],                  ["アクアグリーンaqua green", 0x88bfbf], 
    ["アクアマリンaquamarine", 0x67b5b7],                    ["ピーコックブルーpeacock blue", 0x009e9f], 
    ["ターコイズturquoise", 0x009b9f],                       ["カプリブルーcapri blue", 0x00a3a7], 
    ["ケンブリッジブルーcambridge blue", 0x25b7c0],          ["ターコイズブルーturquoise blue", 0x00afcc], 
    ["ホライズンブルーhorizon blue", 0x82cddd],              ["サマーシャワーsummer shower", 0xa1d8e2], 
    ["ホリゾンブルーhorizon blue", 0xa1d8e6],                ["セルリアンブルーcerulean blue", 0x008db7], 
    ["ダックブルーduck blue", 0x007199],                     ["マリンブルーmarine blue", 0x006888], 
    ["マドンナブルーmadonna blue", 0x00608d],                ["エジプシャンブルーegyptian blue", 0x0073a8], 
    ["ベビーブルーbaby bule", 0xbbe2f1],                     ["スカイブルーsky blue", 0xa0d8ef], 
    ["シャドウブルーshadow blue", 0x719bad],                 ["シアンcyan", 0x00a1e9], 
    ["ヨットブルーyacht blue", 0x409ecc],                    ["チョークブルーchalk blue", 0x68a9cf], 
    ["ピジョンブルーpigeon blue", 0x88b5d3],                 ["スモークブルーsmoke blue", 0xa4c1d7], 
    ["フロスティブルーfrosty blue", 0xbbdbf3],               ["ブルーアシードbleu acide", 0x006eb0], 
    ["コバルトブルーcobalt blue", 0x0068b7],                 ["サファイアブルーsapphire blue", 0x0068b7], 
    ["スペクトラムブルーspectrum blue", 0x0075c2],           ["ブルーblue", 0x0075c2], 
    ["ゼニスブルーzenith blue", 0x4496d3],                   ["ヘブンリーブルーheavenly blue", 0x68a4d9], 
    ["オーキッドグレイorchid gray", 0xbcc7d7],               ["パウダーブルーpowder blue", 0xbccddb], 
    ["ライトブルーlight blue", 0xb2cbe4],                    ["ベイビーブルーbaby blue", 0xa2c2e6], 
    ["デイドリームday dream", 0xa3b9e0],                     ["サルビアブルーsalvia blue", 0x94adda], 
    ["ヒヤシンスブルーhyacinth blue", 0x7a99cf],             ["ヒヤシンスhyacinth", 0x6c9bd2], 
    ["ミッドナイトブルーmidnight blue", 0x001e43],           ["ネービーブルーnavy blue", 0x202f55], 
    ["プルシャンブルーprussian blue", 0x192f60],             ["アイアンブルーiron blue", 0x192f60], 
    ["インディゴindigo", 0x043c78],                          ["インクブルーink blue", 0x003f8e], 
    ["オリエンタルブルーoriental blue", 0x26499d],           ["ウルトラマリンブルーultramarine blue", 0x4753a2], 
    ["ウルトラマリンultramarine", 0x434da2],                 ["ウイスタリアwistaria", 0x8d93c8], 
    ["ブルーラベンダーblue lavender", 0xa4a8d4],             ["パンジーpannsy", 0x4d4398], 
    ["バイオレットviolet", 0x5a4498],                        ["ヘリオトロープheliotrope", 0x9079b6], 
    ["ディープロイヤルパープルdeep royal purple", 0x47266e], ["グレープgrape", 0x56256e], 
    ["モーブmauve", 0x915da3],                               ["アイリスiris", 0xc7a5cc], 
    ["ライラックlilac", 0xd1bada],                           ["ラベンダーlavender", 0xcab8d9], 
    ["クロッカスcrocus", 0xb79fcb],                          ["ラベンダーモーブlavender mauve", 0xa688bd], 
    ["パープルpurple", 0x9b72b0],                            ["ロイヤルパープルroyal purple", 0x7f1184], 
    ["レーズンraisin", 0x6b395f],                            ["プラムplum", 0x6c2463], 
    ["ラズベリーraspberry", 0x841a75],                       ["フランボワーズframboise", 0x9a0d7c], 
    ["ダリアパープルdahlia purple", 0xa50082],               ["オーキッドパープルorchid purple", 0xaf0082], 
    ["ラズベリーレッドraspberry red", 0x9f166a],             ["オーキッドorchid", 0xd9aacd], 
    ["リラlilla", 0xe0b5d3],                                 ["ローズタンドルrose tendre", 0xe6afcf], 
    ["オーキッドピンクorchid pink", 0xda81b2],               ["シクラメンピンクcyclamen pink", 0xd04f97], 
    ["マゼンタmagenta", 0xe4007f],                           ["ブーゲンビリアbougainvillaea", 0xe62f8b], 
    ["ルビーruby", 0xc70067],                                ["クラレットclaret", 0x941f57], 
    ["アザレazalee", 0xd83473],                              ["コスモスcosmos", 0xdc6b9a], 
    ["ロータスピンクlotus pink", 0xde82a7],                  ["オールドオーキッドold orchid", 0xe3adc1], 
    ["ローズミストrose mist", 0xdebecc],                     ["ローズドラジェrose dragee", 0xe5c1cd], 
    ["チェリーピンクcherry pink", 0xeb6ea0],                 ["オペラopera", 0xe95388], 
    ["ローズレッドrose red", 0xea618e],                      ["オールドライラックold lilac", 0xb0778c], 
    ["ココア色cocoa", 0x6e4a55],                             ["ワインレッドwine red", 0xb33e5c], 
    ["ガーネットgarnet", 0x942343],                          ["コチニールレッドcochineal red", 0xc82c55], 
    ["ストロベリーstrawberry", 0xe73562],                    ["ルビーレッドruby red", 0xe73562], 
    ["カーマインcarmine", 0xd70035],                         ["シグナルレッドsignal red", 0xe8383d], 
    ["バーガンディーburgundy", 0x6c2735],                    ["ボルドーbordeaux", 0x6c272d], 
    ["カメリアcamellia", 0xda536e],                          ["ローズrose", 0xe95464], 
    ["ローズピンクrose pink", 0xf19ca7],                     ["ピンクpink", 0xf5b2b2], 
    ["フラミンゴピンクflamingo pink", 0xf5b2ac],             ["オールドローズold rose", 0xe29399], 
    ["ピンクアーモンドpink almond", 0xe3acae],               ["ローズダストrose dust", 0xe6c0c0], 
    ["ホワイトwhite", 0xffffff],                             ["スノーホワイトsnow white", 0xfafdff], 
    ["ピンクホワイトpink white", 0xfef9fb],                  ["ミルキーホワイトmilky white", 0xfffff9], 
    ["アンバーホワイトamber white", 0xfff9f5],               ["ラベンダーアイスlavender ice", 0xf7f6fb], 
    ["パールホワイトpearl white", 0xf7f6f5],                 ["アイボリーivory", 0xf8f4e6], 
    ["パウダーピンクpowder pink", 0xf5ecf4],                 ["シルバーホワイトsilver white", 0xefefef], 
    ["フロスティグレイfrosty gray", 0xe8ece9],               ["シルバーピンクsilver pink", 0xeeeaec], 
    ["ベージュカメオbeige cameo", 0xeee9e6],                 ["エクリュecru", 0xeee7e0], 
    ["ピンクベージュpink beige", 0xede4e1],                  ["フロスティホワイトfrosty white", 0xe6eae6], 
    ["オイスターホワイトoyster white", 0xeae8e1],            ["ウィステリアミストwisteria mist", 0xd3d6dd], 
    ["クラウドcloud", 0xd4d9df],                             ["ムーングレイmoon gray", 0xd4d9dc], 
    ["チャイナクレイchina clay", 0xd4dcd3],                  ["サンドベージュsand beige", 0xdcd6d2], 
    ["オーキッドミストorchid mist", 0xd3d3d8],               ["リードグレイreed gray", 0xd4d9d6], 
    ["スカイグレイsky gray", 0xcbd0d3],                      ["ラベンダーグレイlavender gray", 0xbcbace], 
    ["シルバーsilver", 0xc9caca],                            ["パールグレイpearl gray", 0xc9c9c4], 
    ["サンドグレイsand gray", 0xc9c9c2],                     ["マーブルグレイmarble gray", 0xc0c5c2], 
    ["オパールグレイopal gray", 0xbfbec5],                   ["フレンチグレイfrench gray", 0x8da0b6], 
    ["ミストmist", 0xb4aeb1],                                ["アッシュブロンドash blond", 0xb5b5ae], 
    ["フォッグfog", 0xabb1b5],                               ["ベージュグレイbeige gray", 0xb4ada9], 
    ["シルバーグレイsilver gray", 0xafafb0],                 ["ストームグレイstorm gray", 0xaaaab0], 
    ["グリーンフォッグgreen fog", 0xabb1ad],                 ["アッシュグレイash gray", 0x9fa09e], 
    ["ローズグレイrose gray", 0x9d8e87],                     ["エレファントスキンelephant skin", 0x9f9f98], 
    ["バトルシップグレイbattleship gray", 0x898989],         ["ストーングレイstone gray", 0x898880], 
    ["モスグレイmoss gray", 0x7e837f],                       ["ダブグレイdove gray", 0x7d7b83], 
    ["グレイgray", 0x7d7d7d],                                ["スチールグレイsteel gray", 0x736d71], 
    ["アイビーグレイivy gray", 0x666c67],                    ["スレートグレイslate gray", 0x626063], 
    ["グラファイトgraphite", 0x594e52],                      ["チャコールグレイcharcoal gray", 0x4e454a], 
    ["トープtaupe", 0x504946],                               ["ランプブラックlamp black", 0x24140e], 
    ["ブラックblack", 0x000000]
];
// 地下鉄カラー
const METRO_COLORS: Array = [
    ["銀座線オレンジGinza Line Orange", 0xf39700],       ["丸の内線レッドMarunouchi Line Red", 0xe60012], 
    ["日比谷線シルバーHibiya Line Silver", 0x9caeb7],    ["東西線スカイTozai Line Sky", 0x00a7db], 
    ["千代田線グリーンChiyoda Line Green", 0x009944],    ["有楽町線ゴールドYurakucho Line Gold", 0xd7c447], 
    ["半蔵門線パープルHanzomon Line Purple", 0x9b7cb6],  ["南北線エメラルドNamboku Line Emerald", 0x00ada9], 
    ["副都心線ブラウンFukutoshin Line Brown", 0xbb641d], ["浅草線ローズAsakusa Line Rose", 0xe85298], 
    ["三田線ブルーMita Line Blue", 0x0079c2],            ["新宿線リーフShinjuku Line Leaf", 0x6cbb5a], 
    ["大江戸線ルビーOedo Line Ruby", 0xb6007a],          ["御堂筋線 臙脂Midosuji Line Red", 0xe5171f], 
    ["谷町線 京紫Tanimachi Line Purple", 0x522886],      ["四つ橋線 縹Yotsubashi Line Blue", 0x0078ba], 
    ["中央線 緑Chuo Line Green", 0x019a66],              ["千日前線 紅梅Sennichimae Line Pink", 0xe44d93], 
    ["堺筋線 マルーンSakaisuji Line Marron", 0x814721],  ["長堀鶴見緑地線 萌黄Nagahoritsurumiryokuchi Line Yellow Green", 0xa9cc51], 
    ["今里筋線 柑子Imazatosuji Line Orange", 0xee7b1a],  ["南港ポートタウン線 セルリアンブルーNanko port town Line Cerulean Blue", 0x00a0de]
];
// XKCD COLORS : @see http://xkcd.com/color/rgb/
const XKCD_COLORS: Array = [
    ["cloudy blue", 0xacc2d9],           ["dark pastel green", 0x56ae57],   ["dust", 0xb2996e],                       ["electric lime", 0xa8ff04], 
    ["fresh green", 0x69d84f],           ["light eggplant", 0x894585],      ["nasty green", 0x70b23f],                ["really light blue", 0xd4ffff], 
    ["tea", 0x65ab7c],                   ["warm purple", 0x952e8f],         ["yellowish tan", 0xfcfc81],              ["cement", 0xa5a391], 
    ["dark grass green", 0x388004],      ["dusty teal", 0x4c9085],          ["grey teal", 0x5e9b8a],                  ["macaroni and cheese", 0xefb435], 
    ["pinkish tan", 0xd99b82],           ["spruce", 0x0a5f38],              ["strong blue", 0x0c06f7],                ["toxic green", 0x61de2a], 
    ["windows blue", 0x3778bf],          ["blue blue", 0x2242c7],           ["blue with a hint of purple", 0x533cc6], ["booger", 0x9bb53c], 
    ["bright sea green", 0x05ffa6],      ["dark green blue", 0x1f6357],     ["deep turquoise", 0x017374],             ["green teal", 0x0cb577], 
    ["strong pink", 0xff0789],           ["bland", 0xafa88b],               ["deep aqua", 0x08787f],                  ["lavender pink", 0xdd85d7], 
    ["light moss green", 0xa6c875],      ["light seafoam green", 0xa7ffb5], ["olive yellow", 0xc2b709],               ["pig pink", 0xe78ea5], 
    ["deep lilac", 0x966ebd],            ["desert", 0xccad60],              ["dusty lavender", 0xac86a8],             ["purpley grey", 0x947e94], 
    ["purply", 0x983fb2],                ["candy pink", 0xff63e9],          ["light pastel green", 0xb2fba5],         ["boring green", 0x63b365], 
    ["kiwi green", 0x8ee53f],            ["light grey green", 0xb7e1a1],    ["orange pink", 0xff6f52],                ["tea green", 0xbdf8a3], 
    ["very light brown", 0xd3b683],      ["egg shell", 0xfffcc4],           ["eggplant purple", 0x430541],            ["powder pink", 0xffb2d0], 
    ["reddish grey", 0x997570],          ["baby shit brown", 0xad900d],     ["liliac", 0xc48efd],                     ["stormy blue", 0x507b9c], 
    ["ugly brown", 0x7d7103],            ["custard", 0xfffd78],             ["darkish pink", 0xda467d],               ["deep brown", 0x410200], 
    ["greenish beige", 0xc9d179],        ["manilla", 0xfffa86],             ["off blue", 0x5684ae],                   ["battleship grey", 0x6b7c85], 
    ["browny green", 0x6f6c0a],          ["bruise", 0x7e4071],              ["kelley green", 0x009337],               ["sickly yellow", 0xd0e429], 
    ["sunny yellow", 0xfff917],          ["azul", 0x1d5dec],                ["darkgreen", 0x054907],                  ["green/yellow", 0xb5ce08], 
    ["lichen", 0x8fb67b],                ["light light green", 0xc8ffb0],   ["pale gold", 0xfdde6c],                  ["sun yellow", 0xffdf22], 
    ["tan green", 0xa9be70],             ["burple", 0x6832e3],              ["butterscotch", 0xfdb147],               ["toupe", 0xc7ac7d], 
    ["dark cream", 0xfff39a],            ["indian red", 0x850e04],          ["light lavendar", 0xefc0fe],             ["poison green", 0x40fd14], 
    ["baby puke green", 0xb6c406],       ["bright yellow green", 0x9dff00], ["charcoal grey", 0x3c4142],              ["squash", 0xf2ab15], 
    ["cinnamon", 0xac4f06],              ["light pea green", 0xc4fe82],     ["radioactive green", 0x2cfa1f],          ["raw sienna", 0x9a6200], 
    ["baby purple", 0xca9bf7],           ["cocoa", 0x875f42],               ["light royal blue", 0x3a2efe],           ["orangeish", 0xfd8d49], 
    ["rust brown", 0x8b3103],            ["sand brown", 0xcba560],          ["swamp", 0x698339],                      ["tealish green", 0x0cdc73], 
    ["burnt siena", 0xb75203],           ["camo", 0x7f8f4e],                ["dusk blue", 0x26538d],                  ["fern", 0x63a950], 
    ["old rose", 0xc87f89],              ["pale light green", 0xb1fc99],    ["peachy pink", 0xff9a8a],                ["rosy pink", 0xf6688e], 
    ["light bluish green", 0x76fda8],    ["light bright green", 0x53fe5c],  ["light neon green", 0x4efd54],           ["light seafoam", 0xa0febf], 
    ["tiffany blue", 0x7bf2da],          ["washed out green", 0xbcf5a6],    ["browny orange", 0xca6b02],              ["nice blue", 0x107ab0], 
    ["sapphire", 0x2138ab],              ["greyish teal", 0x719f91],        ["orangey yellow", 0xfdb915],             ["parchment", 0xfefcaf], 
    ["straw", 0xfcf679],                 ["very dark brown", 0x1d0200],     ["terracota", 0xcb6843],                  ["ugly blue", 0x31668a], 
    ["clear blue", 0x247afd],            ["creme", 0xffffb6],               ["foam green", 0x90fda9],                 ["grey/green", 0x86a17d], 
    ["light gold", 0xfddc5c],            ["seafoam blue", 0x78d1b6],        ["topaz", 0x13bbaf],                      ["violet pink", 0xfb5ffc], 
    ["wintergreen", 0x20f986],           ["yellow tan", 0xffe36e],          ["dark fuchsia", 0x9d0759],               ["indigo blue", 0x3a18b1], 
    ["light yellowish green", 0xc2ff89], ["pale magenta", 0xd767ad],        ["rich purple", 0x720058],                ["sunflower yellow", 0xffda03], 
    ["green/blue", 0x01c08d],            ["leather", 0xac7434],             ["racing green", 0x014600],               ["vivid purple", 0x9900fa], 
    ["dark royal blue", 0x02066f],       ["hazel", 0x8e7618],               ["muted pink", 0xd1768f],                 ["booger green", 0x96b403], 
    ["canary", 0xfdff63],                ["cool grey", 0x95a3a6],           ["dark taupe", 0x7f684e],                 ["darkish purple", 0x751973], 
    ["true green", 0x089404],            ["coral pink", 0xff6163],          ["dark sage", 0x598556],                  ["dark slate blue", 0x214761], 
    ["flat blue", 0x3c73a8],             ["mushroom", 0xba9e88],            ["rich blue", 0x021bf9],                  ["dirty purple", 0x734a65], 
    ["greenblue", 0x23c48b],             ["icky green", 0x8fae22],          ["light khaki", 0xe6f2a2],                ["warm blue", 0x4b57db], 
    ["dark hot pink", 0xd90166],         ["deep sea blue", 0x015482],       ["carmine", 0x9d0216],                    ["dark yellow green", 0x728f02], 
    ["pale peach", 0xffe5ad],            ["plum purple", 0x4e0550],         ["golden rod", 0xf9bc08],                 ["neon red", 0xff073a], 
    ["old pink", 0xc77986],              ["very pale blue", 0xd6fffe],      ["blood orange", 0xfe4b03],               ["grapefruit", 0xfd5956], 
    ["sand yellow", 0xfce166],           ["clay brown", 0xb2713d],          ["dark blue grey", 0x1f3b4d],             ["flat green", 0x699d4c], 
    ["light green blue", 0x56fca2],      ["warm pink", 0xfb5581],           ["dodger blue", 0x3e82fc],                ["gross green", 0xa0bf16], 
    ["ice", 0xd6fffa],                   ["metallic blue", 0x4f738e],       ["pale salmon", 0xffb19a],                ["sap green", 0x5c8b15], 
    ["algae", 0x54ac68],                 ["bluey grey", 0x89a0b0],          ["greeny grey", 0x7ea07a],                ["highlighter green", 0x1bfc06], 
    ["light light blue", 0xcafffb],      ["light mint", 0xb6ffbb],          ["raw umber", 0xa75e09],                  ["vivid blue", 0x152eff], 
    ["deep lavender", 0x8d5eb7],         ["dull teal", 0x5f9e8f],           ["light greenish blue", 0x63f7b4],        ["mud green", 0x606602], 
    ["pinky", 0xfc86aa],                 ["red wine", 0x8c0034],            ["shit green", 0x758000],                 ["tan brown", 0xab7e4c], 
    ["darkblue", 0x030764],              ["rosa", 0xfe86a4],                ["lipstick", 0xd5174e],                   ["pale mauve", 0xfed0fc], 
    ["claret", 0x680018],                ["dandelion", 0xfedf08],           ["orangered", 0xfe420f],                  ["poop green", 0x6f7c00], 
    ["ruby", 0xca0147],                  ["dark", 0x1b2431],                ["greenish turquoise", 0x00fbb0],         ["pastel red", 0xdb5856], 
    ["piss yellow", 0xddd618],           ["bright cyan", 0x41fdfe],         ["dark coral", 0xcf524e],                 ["algae green", 0x21c36f], 
    ["darkish red", 0xa90308],           ["reddy brown", 0x6e1005],         ["blush pink", 0xfe828c],                 ["camouflage green", 0x4b6113], 
    ["lawn green", 0x4da409],            ["putty", 0xbeae8a],               ["vibrant blue", 0x0339f8],               ["dark sand", 0xa88f59], 
    ["purple/blue", 0x5d21d0],           ["saffron", 0xfeb209],             ["twilight", 0x4e518b],                   ["warm brown", 0x964e02], 
    ["bluegrey", 0x85a3b2],              ["bubble gum pink", 0xff69af],     ["duck egg blue", 0xc3fbf4],              ["greenish cyan", 0x2afeb7], 
    ["petrol", 0x005f6a],                ["royal", 0x0c1793],               ["butter", 0xffff81],                     ["dusty orange", 0xf0833a], 
    ["off yellow", 0xf1f33f],            ["pale olive green", 0xb1d27b],    ["orangish", 0xfc824a],                   ["leaf", 0x71aa34], 
    ["light blue grey", 0xb7c9e2],       ["dried blood", 0x4b0101],         ["lightish purple", 0xa552e6],            ["rusty red", 0xaf2f0d], 
    ["lavender blue", 0x8b88f8],         ["light grass green", 0x9af764],   ["light mint green", 0xa6fbb2],           ["sunflower", 0xffc512], 
    ["velvet", 0x750851],                ["brick orange", 0xc14a09],        ["lightish red", 0xfe2f4a],               ["pure blue", 0x0203e2], 
    ["twilight blue", 0x0a437a],         ["violet red", 0xa50055],          ["yellowy brown", 0xae8b0c],              ["carnation", 0xfd798f], 
    ["muddy yellow", 0xbfac05],          ["dark seafoam green", 0x3eaf76],  ["deep rose", 0xc74767],                  ["dusty red", 0xb9484e], 
    ["grey/blue", 0x647d8e],             ["lemon lime", 0xbffe28],          ["purple/pink", 0xd725de],                ["brown yellow", 0xb29705], 
    ["purple brown", 0x673a3f],          ["wisteria", 0xa87dc2],            ["banana yellow", 0xfafe4b],              ["lipstick red", 0xc0022f], 
    ["water blue", 0x0e87cc],            ["brown grey", 0x8d8468],          ["vibrant purple", 0xad03de],             ["baby green", 0x8cff9e], 
    ["barf green", 0x94ac02],            ["eggshell blue", 0xc4fff7],       ["sandy yellow", 0xfdee73],               ["cool green", 0x33b864], 
    ["pale", 0xfff9d0],                  ["blue/grey", 0x758da3],           ["hot magenta", 0xf504c9],                ["greyblue", 0x77a1b5], 
    ["purpley", 0x8756e4],               ["baby shit green", 0x889717],     ["brownish pink", 0xc27e79],              ["dark aquamarine", 0x017371], 
    ["diarrhea", 0x9f8303],              ["light mustard", 0xf7d560],       ["pale sky blue", 0xbdf6fe],              ["turtle green", 0x75b84f], 
    ["bright olive", 0x9cbb04],          ["dark grey blue", 0x29465b],      ["greeny brown", 0x696006],               ["lemon green", 0xadf802], 
    ["light periwinkle", 0xc1c6fc],      ["seaweed green", 0x35ad6b],       ["sunshine yellow", 0xfffd37],            ["ugly purple", 0xa442a0], 
    ["medium pink", 0xf36196],           ["puke brown", 0x947706],          ["very light pink", 0xfff4f2],            ["viridian", 0x1e9167], 
    ["bile", 0xb5c306],                  ["faded yellow", 0xfeff7f],        ["very pale green", 0xcffdbc],            ["vibrant green", 0x0add08], 
    ["bright lime", 0x87fd05],           ["spearmint", 0x1ef876],           ["light aquamarine", 0x7bfdc7],           ["light sage", 0xbcecac], 
    ["yellowgreen", 0xbbf90f],           ["baby poo", 0xab9004],            ["dark seafoam", 0x1fb57a],               ["deep teal", 0x00555a], 
    ["heather", 0xa484ac],               ["rust orange", 0xc45508],         ["dirty blue", 0x3f829d],                 ["fern green", 0x548d44], 
    ["bright lilac", 0xc95efb],          ["weird green", 0x3ae57f],         ["peacock blue", 0x016795],               ["avocado green", 0x87a922], 
    ["faded orange", 0xf0944d],          ["grape purple", 0x5d1451],        ["hot green", 0x25ff29],                  ["lime yellow", 0xd0fe1d], 
    ["mango", 0xffa62b],                 ["shamrock", 0x01b44c],            ["bubblegum", 0xff6cb5],                  ["purplish brown", 0x6b4247], 
    ["vomit yellow", 0xc7c10c],          ["pale cyan", 0xb7fffa],           ["key lime", 0xaeff6e],                   ["tomato red", 0xec2d01], 
    ["lightgreen", 0x76ff7b],            ["merlot", 0x730039],              ["night blue", 0x040348],                 ["purpleish pink", 0xdf4ec8], 
    ["apple", 0x6ecb3c],                 ["baby poop green", 0x8f9805],     ["green apple", 0x5edc1f],                ["heliotrope", 0xd94ff5], 
    ["yellow/green", 0xc8fd3d],          ["almost black", 0x070d0d],        ["cool blue", 0x4984b8],                  ["leafy green", 0x51b73b], 
    ["mustard brown", 0xac7e04],         ["dusk", 0x4e5481],                ["dull brown", 0x876e4b],                 ["frog green", 0x58bc08], 
    ["vivid green", 0x2fef10],           ["bright light green", 0x2dfe54],  ["fluro green", 0x0aff02],                ["kiwi", 0x9cef43], 
    ["seaweed", 0x18d17b],               ["navy green", 0x35530a],          ["ultramarine blue", 0x1805db],           ["iris", 0x6258c4], 
    ["pastel orange", 0xff964f],         ["yellowish orange", 0xffab0f],    ["perrywinkle", 0x8f8ce7],                ["tealish", 0x24bca8], 
    ["dark plum", 0x3f012c],             ["pear", 0xcbf85f],                ["pinkish orange", 0xff724c],             ["midnight purple", 0x280137], 
    ["light urple", 0xb36ff6],           ["dark mint", 0x48c072],           ["greenish tan", 0xbccb7a],               ["light burgundy", 0xa8415b], 
    ["turquoise blue", 0x06b1c4],        ["ugly pink", 0xcd7584],           ["sandy", 0xf1da7a],                      ["electric pink", 0xff0490], 
    ["muted purple", 0x805b87],          ["mid green", 0x50a747],           ["greyish", 0xa8a495],                    ["neon yellow", 0xcfff04], 
    ["banana", 0xffff7e],                ["carnation pink", 0xff7fa7],      ["tomato", 0xef4026],                     ["sea", 0x3c9992], 
    ["muddy brown", 0x886806],           ["turquoise green", 0x04f489],     ["buff", 0xfef69e],                       ["fawn", 0xcfaf7b], 
    ["muted blue", 0x3b719f],            ["pale rose", 0xfdc1c5],           ["dark mint green", 0x20c073],            ["amethyst", 0x9b5fc0], 
    ["blue/green", 0x0f9b8e],            ["chestnut", 0x742802],            ["sick green", 0x9db92c],                 ["pea", 0xa4bf20], 
    ["rusty orange", 0xcd5909],          ["stone", 0xada587],               ["rose red", 0xbe013c],                   ["pale aqua", 0xb8ffeb], 
    ["deep orange", 0xdc4d01],           ["earth", 0xa2653e],               ["mossy green", 0x638b27],                ["grassy green", 0x419c03], 
    ["pale lime green", 0xb1ff65],       ["light grey blue", 0x9dbcd4],     ["pale grey", 0xfdfdfe],                  ["asparagus", 0x77ab56], 
    ["blueberry", 0x464196],             ["purple red", 0x990147],          ["pale lime", 0xbefd73],                  ["greenish teal", 0x32bf84], 
    ["caramel", 0xaf6f09],               ["deep magenta", 0xa0025c],        ["light peach", 0xffd8b1],                ["milk chocolate", 0x7f4e1e], 
    ["ocher", 0xbf9b0c],                 ["off green", 0x6ba353],           ["purply pink", 0xf075e6],                ["lightblue", 0x7bc8f6], 
    ["dusky blue", 0x475f94],            ["golden", 0xf5bf03],              ["light beige", 0xfffeb6],                ["butter yellow", 0xfffd74], 
    ["dusky purple", 0x895b7b],          ["french blue", 0x436bad],         ["ugly yellow", 0xd0c101],                ["greeny yellow", 0xc6f808], 
    ["orangish red", 0xf43605],          ["shamrock green", 0x02c14d],      ["orangish brown", 0xb25f03],             ["tree green", 0x2a7e19], 
    ["deep violet", 0x490648],           ["gunmetal", 0x536267],            ["blue/purple", 0x5a06ef],                ["cherry", 0xcf0234], 
    ["sandy brown", 0xc4a661],           ["warm grey", 0x978a84],           ["dark indigo", 0x1f0954],                ["midnight", 0x03012d], 
    ["bluey green", 0x2bb179],           ["grey pink", 0xc3909b],           ["soft purple", 0xa66fb5],                ["blood", 0x770001], 
    ["brown red", 0x922b05],             ["medium grey", 0x7d7f7c],         ["berry", 0x990f4b],                      ["poo", 0x8f7303], 
    ["purpley pink", 0xc83cb9],          ["light salmon", 0xfea993],        ["snot", 0xacbb0d],                       ["easter purple", 0xc071fe], 
    ["light yellow green", 0xccfd7f],    ["dark navy blue", 0x00022e],      ["drab", 0x828344],                       ["light rose", 0xffc5cb], 
    ["rouge", 0xab1239],                 ["purplish red", 0xb0054b],        ["slime green", 0x99cc04],                ["baby poop", 0x937c00], 
    ["irish green", 0x019529],           ["pink/purple", 0xef1de7],         ["dark navy", 0x000435],                  ["greeny blue", 0x42b395], 
    ["light plum", 0x9d5783],            ["pinkish grey", 0xc8aca9],        ["dirty orange", 0xc87606],               ["rust red", 0xaa2704], 
    ["pale lilac", 0xe4cbff],            ["orangey red", 0xfa4224],         ["primary blue", 0x0804f9],               ["kermit green", 0x5cb200], 
    ["brownish purple", 0x76424e],       ["murky green", 0x6c7a0e],         ["wheat", 0xfbdd7e],                      ["very dark purple", 0x2a0134], 
    ["bottle green", 0x044a05],          ["watermelon", 0xfd4659],          ["deep sky blue", 0x0d75f8],              ["fire engine red", 0xfe0002], 
    ["yellow ochre", 0xcb9d06],          ["pumpkin orange", 0xfb7d07],      ["pale olive", 0xb9cc81],                 ["light lilac", 0xedc8ff], 
    ["lightish green", 0x61e160],        ["carolina blue", 0x8ab8fe],       ["mulberry", 0x920a4e],                   ["shocking pink", 0xfe02a2], 
    ["auburn", 0x9a3001],                ["bright lime green", 0x65fe08],   ["celadon", 0xbefdb7],                    ["pinkish brown", 0xb17261], 
    ["poo brown", 0x885f01],             ["bright sky blue", 0x02ccfe],     ["celery", 0xc1fd95],                     ["dirt brown", 0x836539], 
    ["strawberry", 0xfb2943],            ["dark lime", 0x84b701],           ["copper", 0xb66325],                     ["medium brown", 0x7f5112], 
    ["muted green", 0x5fa052],           ["robin's egg", 0x6dedfd],         ["bright aqua", 0x0bf9ea],                ["bright lavender", 0xc760ff], 
    ["ivory", 0xffffcb],                 ["very light purple", 0xf6cefc],   ["light navy", 0x155084],                 ["pink red", 0xf5054f], 
    ["olive brown", 0x645403],           ["poop brown", 0x7a5901],          ["mustard green", 0xa8b504],              ["ocean green", 0x3d9973], 
    ["very dark blue", 0x000133],        ["dusty green", 0x76a973],         ["light navy blue", 0x2e5a88],            ["minty green", 0x0bf77d], 
    ["adobe", 0xbd6c48],                 ["barney", 0xac1db8],              ["jade green", 0x2baf6a],                 ["bright light blue", 0x26f7fd], 
    ["light lime", 0xaefd6c],            ["dark khaki", 0x9b8f55],          ["orange yellow", 0xffad01],              ["ocre", 0xc69c04], 
    ["maize", 0xf4d054],                 ["faded pink", 0xde9dac],          ["british racing green", 0x05480d],       ["sandstone", 0xc9ae74], 
    ["mud brown", 0x60460f],             ["light sea green", 0x98f6b0],     ["robin egg blue", 0x8af1fe],             ["aqua marine", 0x2ee8bb], 
    ["dark sea green", 0x11875d],        ["soft pink", 0xfdb0c0],           ["orangey brown", 0xb16002],              ["cherry red", 0xf7022a], 
    ["burnt yellow", 0xd5ab09],          ["brownish grey", 0x86775f],       ["camel", 0xc69f59],                      ["purplish grey", 0x7a687f], 
    ["marine", 0x042e60],                ["greyish pink", 0xc88d94],        ["pale turquoise", 0xa5fbd5],             ["pastel yellow", 0xfffe71], 
    ["bluey purple", 0x6241c7],          ["canary yellow", 0xfffe40],       ["faded red", 0xd3494e],                  ["sepia", 0x985e2b], 
    ["coffee", 0xa6814c],                ["bright magenta", 0xff08e8],      ["mocha", 0x9d7651],                      ["ecru", 0xfeffca], 
    ["purpleish", 0x98568d],             ["cranberry", 0x9e003a],           ["darkish green", 0x287c37],              ["brown orange", 0xb96902], 
    ["dusky rose", 0xba6873],            ["melon", 0xff7855],               ["sickly green", 0x94b21c],               ["silver", 0xc5c9c7], 
    ["purply blue", 0x661aee],           ["purpleish blue", 0x6140ef],      ["hospital green", 0x9be5aa],             ["shit brown", 0x7b5804], 
    ["mid blue", 0x276ab3],              ["amber", 0xfeb308],               ["easter green", 0x8cfd7e],               ["soft blue", 0x6488ea], 
    ["cerulean blue", 0x056eee],         ["golden brown", 0xb27a01],        ["bright turquoise", 0x0ffef9],           ["red pink", 0xfa2a55], 
    ["red purple", 0x820747],            ["greyish brown", 0x7a6a4f],       ["vermillion", 0xf4320c],                 ["russet", 0xa13905], 
    ["steel grey", 0x6f828a],            ["lighter purple", 0xa55af4],      ["bright violet", 0xad0afd],              ["prussian blue", 0x004577], 
    ["slate green", 0x658d6d],           ["dirty pink", 0xca7b80],          ["dark blue green", 0x005249],            ["pine", 0x2b5d34], 
    ["yellowy green", 0xbff128],         ["dark gold", 0xb59410],           ["bluish", 0x2976bb],                     ["darkish blue", 0x014182], 
    ["dull red", 0xbb3f3f],              ["pinky red", 0xfc2647],           ["bronze", 0xa87900],                     ["pale teal", 0x82cbb2], 
    ["military green", 0x667c3e],        ["barbie pink", 0xfe46a5],         ["bubblegum pink", 0xfe83cc],             ["pea soup green", 0x94a617], 
    ["dark mustard", 0xa88905],          ["shit", 0x7f5f00],                ["medium purple", 0x9e43a2],              ["very dark green", 0x062e03], 
    ["dirt", 0x8a6e45],                  ["dusky pink", 0xcc7a8b],          ["red violet", 0x9e0168],                 ["lemon yellow", 0xfdff38], 
    ["pistachio", 0xc0fa8b],             ["dull yellow", 0xeedc5b],         ["dark lime green", 0x7ebd01],            ["denim blue", 0x3b5b92], 
    ["teal blue", 0x01889f],             ["lightish blue", 0x3d7afd],       ["purpley blue", 0x5f34e7],               ["light indigo", 0x6d5acf], 
    ["swamp green", 0x748500],           ["brown green", 0x706c11],         ["dark maroon", 0x3c0008],                ["hot purple", 0xcb00f5], 
    ["dark forest green", 0x002d04],     ["faded blue", 0x658cbb],          ["drab green", 0x749551],                 ["light lime green", 0xb9ff66], 
    ["snot green", 0x9dc100],            ["yellowish", 0xfaee66],           ["light blue green", 0x7efbb3],           ["bordeaux", 0x7b002c], 
    ["light mauve", 0xc292a1],           ["ocean", 0x017b92],               ["marigold", 0xfcc006],                   ["muddy green", 0x657432], 
    ["dull orange", 0xd8863b],           ["steel", 0x738595],               ["electric purple", 0xaa23ff],            ["fluorescent green", 0x08ff08], 
    ["yellowish brown", 0x9b7a01],       ["blush", 0xf29e8e],               ["soft green", 0x6fc276],                 ["bright orange", 0xff5b00], 
    ["lemon", 0xfdff52],                 ["purple grey", 0x866f85],         ["acid green", 0x8ffe09],                 ["pale lavender", 0xeecffe], 
    ["violet blue", 0x510ac9],           ["light forest green", 0x4f9153],  ["burnt red", 0x9f2305],                  ["khaki green", 0x728639], 
    ["cerise", 0xde0c62],                ["faded purple", 0x916e99],        ["apricot", 0xffb16d],                    ["dark olive green", 0x3c4d03], 
    ["grey brown", 0x7f7053],            ["green grey", 0x77926f],          ["true blue", 0x010fcc],                  ["pale violet", 0xceaefa], 
    ["periwinkle blue", 0x8f99fb],       ["light sky blue", 0xc6fcff],      ["blurple", 0x5539cc],                    ["green brown", 0x544e03], 
    ["bluegreen", 0x017a79],             ["bright teal", 0x01f9c6],         ["brownish yellow", 0xc9b003],            ["pea soup", 0x929901], 
    ["forest", 0x0b5509],                ["barney purple", 0xa00498],       ["ultramarine", 0x2000b1],                ["purplish", 0x94568c], 
    ["puke yellow", 0xc2be0e],           ["bluish grey", 0x748b97],         ["dark periwinkle", 0x665fd1],            ["dark lilac", 0x9c6da5], 
    ["reddish", 0xc44240],               ["light maroon", 0xa24857],        ["dusty purple", 0x825f87],               ["terra cotta", 0xc9643b], 
    ["avocado", 0x90b134],               ["marine blue", 0x01386a],         ["teal green", 0x25a36f],                 ["slate grey", 0x59656d], 
    ["lighter green", 0x75fd63],         ["electric green", 0x21fc0d],      ["dusty blue", 0x5a86ad],                 ["golden yellow", 0xfec615], 
    ["bright yellow", 0xfffd01],         ["light lavender", 0xdfc5fe],      ["umber", 0xb26400],                      ["poop", 0x7f5e00], 
    ["dark peach", 0xde7e5d],            ["jungle green", 0x048243],        ["eggshell", 0xffffd4],                   ["denim", 0x3b638c], 
    ["yellow brown", 0xb79400],          ["dull purple", 0x84597e],         ["chocolate brown", 0x411900],            ["wine red", 0x7b0323], 
    ["neon blue", 0x04d9ff],             ["dirty green", 0x667e2c],         ["light tan", 0xfbeeac],                  ["ice blue", 0xd7fffe], 
    ["cadet blue", 0x4e7496],            ["dark mauve", 0x874c62],          ["very light blue", 0xd5ffff],            ["grey purple", 0x826d8c], 
    ["pastel pink", 0xffbacd],           ["very light green", 0xd1ffbd],    ["dark sky blue", 0x448ee4],              ["evergreen", 0x05472a], 
    ["dull pink", 0xd5869d],             ["aubergine", 0x3d0734],           ["mahogany", 0x4a0100],                   ["reddish orange", 0xf8481c], 
    ["deep green", 0x02590f],            ["vomit green", 0x89a203],         ["purple pink", 0xe03fd8],                ["dusty pink", 0xd58a94], 
    ["faded green", 0x7bb274],           ["camo green", 0x526525],          ["pinky purple", 0xc94cbe],               ["pink purple", 0xdb4bda], 
    ["brownish red", 0x9e3623],          ["dark rose", 0xb5485d],           ["mud", 0x735c12],                        ["brownish", 0x9c6d57], 
    ["emerald green", 0x028f1e],         ["pale brown", 0xb1916e],          ["dull blue", 0x49759c],                  ["burnt umber", 0xa0450e], 
    ["medium green", 0x39ad48],          ["clay", 0xb66a50],                ["light aqua", 0x8cffdb],                 ["light olive green", 0xa4be5c], 
    ["brownish orange", 0xcb7723],       ["dark aqua", 0x05696b],           ["purplish pink", 0xce5dae],              ["dark salmon", 0xc85a53], 
    ["greenish grey", 0x96ae8d],         ["jade", 0x1fa774],                ["ugly green", 0x7a9703],                 ["dark beige", 0xac9362], 
    ["emerald", 0x01a049],               ["pale red", 0xd9544d],            ["light magenta", 0xfa5ff7],              ["sky", 0x82cafc], 
    ["light cyan", 0xacfffc],            ["yellow orange", 0xfcb001],       ["reddish purple", 0x910951],             ["reddish pink", 0xfe2c54], 
    ["orchid", 0xc875c4],                ["dirty yellow", 0xcdc50a],        ["orange red", 0xfd411e],                 ["deep red", 0x9a0200], 
    ["orange brown", 0xbe6400],          ["cobalt blue", 0x030aa7],         ["neon pink", 0xfe019a],                  ["rose pink", 0xf7879a], 
    ["greyish purple", 0x887191],        ["raspberry", 0xb00149],           ["aqua green", 0x12e193],                 ["salmon pink", 0xfe7b7c], 
    ["tangerine", 0xff9408],             ["brownish green", 0x6a6e09],      ["red brown", 0x8b2e16],                  ["greenish brown", 0x696112], 
    ["pumpkin", 0xe17701],               ["pine green", 0x0a481e],          ["charcoal", 0x343837],                   ["baby pink", 0xffb7ce], 
    ["cornflower", 0x6a79f7],            ["blue violet", 0x5d06e9],         ["chocolate", 0x3d1c02],                  ["greyish green", 0x82a67d], 
    ["scarlet", 0xbe0119],               ["green yellow", 0xc9ff27],        ["dark olive", 0x373e02],                 ["sienna", 0xa9561e], 
    ["pastel purple", 0xcaa0ff],         ["terracotta", 0xca6641],          ["aqua blue", 0x02d8e9],                  ["sage green", 0x88b378], 
    ["blood red", 0x980002],             ["deep pink", 0xcb0162],           ["grass", 0x5cac2d],                      ["moss", 0x769958], 
    ["pastel blue", 0xa2bffe],           ["bluish green", 0x10a674],        ["green blue", 0x06b48b],                 ["dark tan", 0xaf884a], 
    ["greenish blue", 0x0b8b87],         ["pale orange", 0xffa756],         ["vomit", 0xa2a415],                      ["forrest green", 0x154406], 
    ["dark lavender", 0x856798],         ["dark violet", 0x34013f],         ["purple blue", 0x632de9],                ["dark cyan", 0x0a888a], 
    ["olive drab", 0x6f7632],            ["pinkish", 0xd46a7e],             ["cobalt", 0x1e488f],                     ["neon purple", 0xbc13fe], 
    ["light turquoise", 0x7ef4cc],       ["apple green", 0x76cd26],         ["dull green", 0x74a662],                 ["wine", 0x80013f], 
    ["powder blue", 0xb1d1fc],           ["off white", 0xffffe4],           ["electric blue", 0x0652ff],              ["dark turquoise", 0x045c5a], 
    ["blue purple", 0x5729ce],           ["azure", 0x069af3],               ["bright red", 0xff000d],                 ["pinkish red", 0xf10c45], 
    ["cornflower blue", 0x5170d7],       ["light olive", 0xacbf69],         ["grape", 0x6c3461],                      ["greyish blue", 0x5e819d], 
    ["purplish blue", 0x601ef9],         ["yellowish green", 0xb0dd16],     ["greenish yellow", 0xcdfd02],            ["medium blue", 0x2c6fbb], 
    ["dusty rose", 0xc0737a],            ["light violet", 0xd6b4fc],        ["midnight blue", 0x020035],              ["bluish purple", 0x703be7], 
    ["red orange", 0xfd3c06],            ["dark magenta", 0x960056],        ["greenish", 0x40a368],                   ["ocean blue", 0x03719c], 
    ["coral", 0xfc5a50],                 ["cream", 0xffffc2],               ["reddish brown", 0x7f2b0a],              ["burnt sienna", 0xb04e0f], 
    ["brick", 0xa03623],                 ["sage", 0x87ae73],                ["grey green", 0x789b73],                 ["white", 0xffffff], 
    ["robin's egg blue", 0x98eff9],      ["moss green", 0x658b38],          ["steel blue", 0x5a7d9a],                 ["eggplant", 0x380835], 
    ["light yellow", 0xfffe7a],          ["leaf green", 0x5ca904],          ["light grey", 0xd8dcd6],                 ["puke", 0xa5a502], 
    ["pinkish purple", 0xd648d7],        ["sea blue", 0x047495],            ["pale purple", 0xb790d4],                ["slate blue", 0x5b7c99], 
    ["blue grey", 0x607c8e],             ["hunter green", 0x0b4008],        ["fuchsia", 0xed0dd9],                    ["crimson", 0x8c000f], 
    ["pale yellow", 0xffff84],           ["ochre", 0xbf9005],               ["mustard yellow", 0xd2bd0a],             ["light red", 0xff474c], 
    ["cerulean", 0x0485d1],              ["pale pink", 0xffcfdc],           ["deep blue", 0x040273],                  ["rust", 0xa83c09], 
    ["light teal", 0x90e4c1],            ["slate", 0x516572],               ["goldenrod", 0xfac205],                  ["dark yellow", 0xd5b60a], 
    ["dark grey", 0x363737],             ["army green", 0x4b5d16],          ["grey blue", 0x6b8ba4],                  ["seafoam", 0x80f9ad], 
    ["puce", 0xa57e52],                  ["spring green", 0xa9f971],        ["dark orange", 0xc65102],                ["sand", 0xe2ca76], 
    ["pastel green", 0xb0ff9d],          ["mint", 0x9ffeb0],                ["light orange", 0xfdaa48],               ["bright pink", 0xfe01b1], 
    ["chartreuse", 0xc1f80a],            ["deep purple", 0x36013f],         ["dark brown", 0x341c02],                 ["taupe", 0xb9a281], 
    ["pea green", 0x8eab12],             ["puke green", 0x9aae07],          ["kelly green", 0x02ab2e],                ["seafoam green", 0x7af9ab], 
    ["blue green", 0x137e6d],            ["khaki", 0xaaa662],               ["burgundy", 0x610023],                   ["dark teal", 0x014d4e], 
    ["brick red", 0x8f1402],             ["royal purple", 0x4b006e],        ["plum", 0x580f41],                       ["mint green", 0x8fff9f], 
    ["gold", 0xdbb40c],                  ["baby blue", 0xa2cffe],           ["yellow green", 0xc0fb2d],               ["bright purple", 0xbe03fd], 
    ["dark red", 0x840000],              ["pale blue", 0xd0fefe],           ["grass green", 0x3f9b0b],                ["navy", 0x01153e], 
    ["aquamarine", 0x04d8b2],            ["burnt orange", 0xc04e01],        ["neon green", 0x0cff0c],                 ["bright blue", 0x0165fc], 
    ["rose", 0xcf6275],                  ["light pink", 0xffd1df],          ["mustard", 0xceb301],                    ["indigo", 0x380282], 
    ["lime", 0xaaff32],                  ["sea green", 0x53fca1],           ["periwinkle", 0x8e82fe],                 ["dark pink", 0xcb416b], 
    ["olive green", 0x677a04],           ["peach", 0xffb07c],               ["pale green", 0xc7fdb5],                 ["light brown", 0xad8150], 
    ["hot pink", 0xff028d],              ["black", 0x000000],               ["lilac", 0xcea2fd],                      ["navy blue", 0x001146], 
    ["royal blue", 0x0504aa],            ["beige", 0xe6daa6],               ["salmon", 0xff796c],                     ["olive", 0x6e750e], 
    ["maroon", 0x650021],                ["bright green", 0x01ff07],        ["dark purple", 0x35063e],                ["mauve", 0xae7181], 
    ["forest green", 0x06470c],          ["aqua", 0x13eac9],                ["cyan", 0x00ffff],                       ["tan", 0xd1b26f], 
    ["dark blue", 0x00035b],             ["lavender", 0xc79fef],            ["turquoise", 0x06c2ac],                  ["dark green", 0x033500], 
    ["violet", 0x9a0eea],                ["light purple", 0xbf77f6],        ["lime green", 0x89fe05],                 ["grey", 0x929591], 
    ["sky blue", 0x75bbfd],              ["yellow", 0xffff14],              ["magenta", 0xc20078],                    ["light green", 0x96f97b], 
    ["orange", 0xf97306],                ["teal", 0x029386],                ["light blue", 0x95d0fc],                 ["red", 0xe50000], 
    ["brown", 0x653700],                 ["pink", 0xff81c0],                ["blue", 0x0343df],                       ["green", 0x15b01a], 
    ["purple", 0x7e1e9c]
];

// 全部まとめ
const ALL_COLORS: Array = [ HTML_COLORS, JAPAN_COLORS, WORLD_COLORS, METRO_COLORS, XKCD_COLORS ];


