/**
 * Copyright ali_baba ( http://wonderfl.net/user/ali_baba )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jgOF
 */

//------------------------------------------------------------
// my first voronoi experiment
//------------------------------------------------------------

package
{
import flash.display.*;
import flash.events.*;
import net.hires.debug.Stats; 

[SWF(backgroundColor="#000000", frameRate=50)]

public class Voronoi extends Sprite
{
	public var maxSpeed:Number = 2;
	public var numDots:int = 100;
	
	private var dots:Vector.<Dot> = new Vector.<Dot>;
	private var PI2:Number = 2 * Math.PI;
	private var distance:Array = [];
	private var sx:Array = [];
	private var sy:Array = [];
	private var ex:Array = [];
	private var ey:Array = [];
	private var dotNum:int = 0;
	private var width_:Number;
	private var height_:Number;
	private var storage:int;

	
	public function Voronoi()
	{
		addEventListener("addedToStage", init);
	}

	
	public function init(e:Event):void{
		removeEventListener("addedToStage", init);
		var stats:Stats = new Stats();
		stats.alpha = 0.5;
		addChild(stats);

		width_ = stage.stageWidth;
		height_ = stage.stageHeight;
		
		for (var i:int=0; i<numDots; i++) {
			addDot();
		}

		calcDots();		
		addEventListener("enterFrame", onEnterFrame);
	}

	
	private function addDot():void
	{
		var dot:Dot = new Dot();
		dot.vx = (Math.random()-0.5) * maxSpeed;
		dot.vy = (Math.random()-0.5) * maxSpeed;
		dots.push(dot);
		
		dotNum ++;
		storage = dotNum + 4;
	}


	private function onEnterFrame(e:Event):void
	{
		moveDots();
		update();
	}


	public function calcDots():void{
		for each (var dot:Dot in dots){
			dot.x = Math.random() * width_;
			dot.y = Math.random() * height_;
		}
	}

	public function moveDots():void{
		for each (var dot:Dot in dots){
			dot.x += dot.vx;
			if (dot.x > width_) dot.x -= width_
			else if (dot.x < 0) dot.x += width_;

			dot.y += dot.vy;
			if (dot.y > height_) dot.y -= height_
			else if (dot.y < 0) dot.y += height_;
		}
	}

	
	public function update():void{
		setVoronoi();
		drawVoronoi();
	}


	private function setVoronoi():void
	{
		var i:int, j:int, k:int, m:int, n:int;
		var a:Number, b:Number, a0:Number, b0:Number, a1:Number, b1:Number, x:Number, y:Number,
			x0:Number, y0:Number, x1:Number, y1:Number;
		
		for (i=0; i<dotNum; i++) {
			x0 = dots[i].x;
			y0 = dots[i].y;
			n = i * storage + i + 1;
			
			for (j=i+1; j<dotNum; j++) {
				x1 = dots[j].x;
				y1 = dots[j].y;
				
				if (x1 == x0) {
					a = 0;
				} else if (y1 == y0) {
					a = 10000;
				} else {
					a = -1/((y1-y0)/(x1-x0));
				}
				b = (y0+y1)/2-a*(x0+x1)/2;
				
				if (a>-1 && a<=1) {
					sx[n] = 0;
					sy[n] = a * sx[n] + b;
					ex[n] = width_ - 1;
					ey[n] = a * ex[n] + b;
				} else {
					sy[n] = 0;
					sx[n] = (sy[n]-b)/a;
					ey[n] = height_ - 1;
					ex[n] = (ey[n]-b)/a;
				}
				n++;
			}
			
			sx[n] = 0;
			sy[n] = 0;
			ex[n] = width_;
			ey[n] = 0;
			n++;
			sx[n] = .1;
			sy[n] = 0;
			ex[n] = 0;
			ey[n] = height_;
			n++;
			sx[n] = width_;
			sy[n] = 0;
			ex[n] = width_ - 0.1;
			ey[n] = height_;
			n++;
			sx[n] = 0;
			sy[n] = height_;
			ex[n] = width_;
			ey[n] = height_;
		}

		for (i=0; i<dotNum; i++) {
			x0 = dots[i].x;
			y0 = dots[i].y;
			for (j=0; j<dotNum+4; j++) {
				if (j != i) {
					if (j>i) {
						n = i * storage + j;
					} else {
						n = j * storage + i;
					}
					if (sx[n] >- Number.MAX_VALUE) {
						a0 = (ey[n] - sy[n]) / (ex[n] - sx[n]);
						b0 = sy[n] - a0 * sx[n];
						for (k=i+1; k<dotNum+4; k++) {
							if (k != j) {
								m = i * storage + k;
								if (sx[m]>-Number.MAX_VALUE) {
									a1 = (ey[m]-sy[m])/(ex[m]-sx[m]);
									b1 = sy[m]-a1*sx[m];
									x = -(b1-b0)/(a1-a0);
									y = a0*x+b0;
									if ((a0*x0+b0-y0)*(a0*sx[m]+b0-sy[m])<0) {
										sx[m] = x;
										sy[m] = y;
									}
									if ((a0*x0+b0-y0)*(a0*ex[m]+b0-ey[m])<0) {
										if (sx[m] == x) {
											sx[m] = -Number.MAX_VALUE;
										} else {
											ex[m] = x;
											ey[m] = y;
										}
									}
								}
							}
						}
					}
				}
			}
		}
	}

	
	private function drawVoronoi():void{
		var i:int, j:int, n:int;

		graphics.clear();
		graphics.lineStyle(0, 0xffcc00, 1);
				
		for (i=0; i<dotNum; i++) {
			n = i * storage + i + 1;
			for (j=i+1; j<dotNum+4; j++) {
				if (sx[n]>-Number.MAX_VALUE) {
					graphics.moveTo(sx[n], sy[n]);
					graphics.lineTo(ex[n], ey[n]);
				}
				n++;
			}
		}
	}

}
}


class Dot{
	public var x:Number;
	public var y:Number;
	public var vx:Number;
	public var vy:Number;
}

