/**
 * Copyright enecre ( http://wonderfl.net/user/enecre )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jg4I
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import org.libspark.thread.Thread;
    import org.libspark.thread.EnterFrameThreadExecutor;
    public class FlashTest extends Sprite {
        
        public function FlashTest() {
            if(!Thread.isReady){
                Thread.initialize(new EnterFrameThreadExecutor());
            }
            addEventListener(Event.ADDED_TO_STAGE,init);
        }
        
        private function init(e:Event = null):void{
            new MainThread(this).start();
        }
    }
}

import flash.events.*;
import flash.filters.*;
import flash.text.*;
import flash.display.*;
import org.libspark.thread.Thread;
import caurina.transitions.Tweener;

class COMThread extends Thread {
    public var which:int=1;
    public var what:int=1;
    public var debug:*;
    
    private var _tks:Array;
    
    private var _myHand:Array;
    private var _comHand:Array;
    private var _canStay:Boolean;
    
    public function COMThread(myHand:Array, comHand:Array, canStay:Boolean){
        _myHand = myHand;
        _comHand = comHand;
        _canStay = canStay;   
    }

    
    override protected function run():void{
        next(think);    
    }
    
    private function think():void{
        _tks = new Array(_myHand.length);
        next(initializeWithOne);
        /*debug = _tks.concat();
        detectByComHand();
        detectByMyHand();
        
        var sel:int = select();
        */    
        }
    
    private function initializeWithOne():void{
        
        for(var i:int = 0; i < _tks.length; i++){
            _tks[i] = [1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1];
        }
        next(detectByComHand); 
    }
    
    private function detectByComHand():void{
        for(var i:int = 0; i < _tks.length; i++){
            for(var j:int = 0; j < _comHand.length; j++){
                _tks[i][_comHand[j]] = 0;
            }
        }
        next(detectByMyHand);
    }
    
    private function detectByMyHand():void{
        for(var j:int = 0; j < _myHand.length; j++){
            if(_myHand[j] == -2){//black
                for(var k0:int = 0; k0 < 24; k0 += 2){
                    _tks[j][k0] = 0;
                }
            }
            else if(_myHand[j] == -1){//white
                for(var k1:int = 1; k1 < 24; k1 += 2){
                    _tks[j][k1] = 0;
                }
            }
            else{
                for(var l:int = 0; l < _tks.length; l++){
                    if(l < j){
                        for(var k2:int = 0; k2 < 24; k2++){
                            if(k2 > _myHand[j])_tks[l][k2] = 0;
                        }
                    }
                    else if(l > j){
                        for(var k3:int = 0; k3 < 24; k3++){
                            if(k3 < _myHand[j])_tks[l][k3] = 0;
                        }
                    }
                    else {
                        _tks[l] = [0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0];
                    }
                }
            }
        }
        debug = _tks.join("\n");
        next(select);
    }
    
    private function select():void{
        var sel:int;
        var min:int = 25;
        for(var i:int = 0; i < _tks.length; i++){
            var sum:int = SUM(_tks[i]);
            if(sum != 0 && sum < min)sel = i; 
        }
        if(_canStay && SUM(_tks[sel]) >= 4){
            which = -1;
            return;
        }
        var ans:int;
        var l:int = int(SUM(_tks[sel]) * Math.random())
        for(var j:int = 0; j < 24; j++){
            if(_tks[sel][j] == 1 && l-- == 0){
                ans = j;
                break;
            }
        }
        which = sel;
        what = ans;
        //debug = "hoge";
    }    
    
    private function SUM(ary:Array):int{
        var sum:int = 0;
        for(var i:int = 0; i < 24; i++){
            sum += ary[i];
        }
        return sum;
    }

    
    
    private static function isBlack(id:int):Boolean{
        return !Boolean(id % 2);
    }


}

class MainThread extends Thread{
    
    private var _tf:TextField = new TextField();
    private var _root:Sprite;
    private var _stage:Stage;
        
    private var _cards:Vector.<AlgoCard> = new Vector.<AlgoCard>(24);
    private var _myHand:Hand = new Hand(true);
    private var _comHand:Hand = new Hand(false);
    private var _numSelector:NumSelector = new NumSelector();
    private var _stayButton:StayButton = new StayButton();
    
    private var _numMyHand:int;
    private var _numComHand:int;
    
    private var _cardTsumoJustNow:AlgoCard;
    private var _selectedCard:AlgoCard;
    private var _selectedNum:int;
    private var _canStay:Boolean;
    
    private var comThread:COMThread;

    function MainThread(root:Sprite){
        _root = root;
        _stage = root.stage;
    }
    
    override protected function run():void{
        next(init);
    }
    
    private function init():void{
        //初期化
        tr("initializing...");
        addChild(new BackGround());
            
        addChild(_myHand, _stage.stageWidth/2 - _myHand.width/2, 320);
        _comHand.rotation = 180;
        addChild(_comHand, _stage.stageWidth/2 + _comHand.width/2, 180);
        addChild(_stayButton, 300, 400);
        _stayButton.active = false;
        _tf.width = 465; _tf.height = 120;
        addChild(_tf,0,200);
            
        for(var i:int = 0; i < 24; i++){
            _cards[i] = new AlgoCard(i);
        }
        tr("finished.");
        
        next(startGame);
    }
    
    private function startGame():void{
        _numMyHand = 0;
        _numComHand = 0;
        shuffle();
        tsumo(true);
        tsumo(false);
        tsumo(true);
        tsumo(false);
        sleep(1000);
        if(int(Math.random() * 2) == 0)next(myTurn);
        else next(comTurn);
    }
    
    private function tsumo(me:Boolean):void{
        var c:AlgoCard = _cards.pop();
        if(c == null)return;
        var target:Hand = (me) ? _myHand : _comHand;
        _cardTsumoJustNow = c;
        target.add(c);
        if(target == _myHand)_numMyHand++;
        else _numComHand++;
    }
    
    private function myTurn():void{
        tr("YOUR TURN-----------");
        tsumo(true);
        activateClick();
    }
    
    private function comTurn():void{
        tr("COM's TURN-----------");
        tsumo(false);
        _canStay = false;
        next(handIn);//[何番目のカードが, 何(id)]
    }
    
    private function handIn():void{
        var hand:Array = [];
        var l:int = _myHand.numChildren;
        for(var i:int = 0; i < l; i++){
            var c:AlgoCard = _myHand.getChildAt(i) as AlgoCard;
            if(c.isOpen)hand[i] = c.id;
            else {
                if(!c.isBlack)hand[i] = -1;
                else hand[i] = -2;
            }
        }
        var hand1:Array = [];
        var l1:int = _comHand.numChildren;
        for(var i1:int = 0; i1 < l1; i1++){
            var c1:AlgoCard = _comHand.getChildAt(i1) as AlgoCard;
            hand1[i1] = c1.id;
        }
        tr(hand)
        tr(hand1);
        comThread = new COMThread(hand, hand1, _canStay);//[何番目のカードが, 何(id)]
        comThread.start();
        comThread.join();
        next(beforeAttack);
    }
    
    private function beforeAttack():void{
        tr(comThread.debug);////////////////////////////////////////////////////////////////////////////
        if(comThread.which == -1){
            next(myTurn);
            return;
        }
        _selectedCard = _myHand.getChildAt(comThread.which) as AlgoCard;
        _selectedNum = int(comThread.what / 2);
        sleep(1000 * (0.5 + Math.random()));
        next(attack);
    }
    
    private function attack():void{
        var myTurnNow:Boolean = !_selectedCard.my;
        var correct:Boolean = (_selectedNum == _selectedCard.number);
        if(myTurnNow){
            tr(_comHand.getChildIndex(_selectedCard) + "番目を" + _selectedNum + "と予想");
            if(correct){
                tr("正解です");
                _selectedCard.uragaesi();
                _numComHand--;
                if(_numComHand == 0){
                tr("あなたの勝ち！");
                }
                else{
                    activateClick();
                    activateStay();
                }
            
            }
            else{
                tr("はずれ");
                _cardTsumoJustNow.uragaesi();
                _numMyHand--;
                next(comTurn);
            }
        }
        else {
            tr(_myHand.getChildIndex(_selectedCard) + "番目を" + _selectedNum + "と予想");
            if(correct){
                tr("COMが正解しました");
                _selectedCard.uragaesi();
                _numMyHand--;
                if(_numComHand == 0){
                    tr("あなたの負け（◞‸◟）");
                }
                else {
                    sleep(1000 * (1 + Math.random()));
                    _canStay = true;
                    next(handIn);
                }
            }
            else{
                tr("COMが外しました");
                _cardTsumoJustNow.uragaesi();
                _numComHand--;
                next(myTurn);
            }
        }
    }
    
    private function activateStay():void{
        _stayButton.active = true;
        event(_stayButton, MouseEvent.CLICK, onStay);
    }
    
    private function onStay(e:MouseEvent = null):void{
        _stayButton.active = false;
        next(comTurn);
    }
    
    private function onNumSelected(e:NumSelectEvent):void{
        fadeOut(_numSelector);
        _numSelector.removeEventListener("numberSelect", onNumSelected);
        _selectedNum = e.data;
        next(attack);
    }

    private function onClick(e:MouseEvent):void{
        activateClick();
        var t:AlgoCard = e.target as AlgoCard;
        if(!t.isOpen){
            _selectedCard = t;
            event(_numSelector, "numberSelect", onNumSelected);
            fadeIn(_numSelector, _root.mouseX, _root.mouseY);
        }
    }
    
    private function activateClick():void{
        var l:int = _comHand.numChildren;
        for(var i:int = 0; i < l; i++){
            var a:AlgoCard = _comHand.getChildAt(i) as AlgoCard;
            if(a.isSelectable)event(a, MouseEvent.CLICK, onClick);
        }
    }

    
    private function fadeIn(d:DisplayObject, x:Number = 0, y:Number = 0):void{
        d.alpha = 0;
        addChild(d, x, y);
        d.addEventListener(Event.ENTER_FRAME,function():void{
            d.alpha += 0.1;
            if(d.alpha >= 1.0)d.removeEventListener(Event.ENTER_FRAME,arguments.callee);
        });
    }
    
    private function fadeOut(d:DisplayObject):void{
        d.alpha = 1;
        d.addEventListener(Event.ENTER_FRAME,function():void{
            d.alpha -= 0.1;
            if(d.alpha <= 0){
                d.removeEventListener(Event.ENTER_FRAME,arguments.callee);
                removeChild(d);
            }
        });
    }

    
    private function shuffle():void{
        var l:int = _cards.length;
        while(l){
            var m:int = int(Math.random()*l);
            var tmp:* = _cards[--l];
            _cards[l] = _cards[m];
            _cards[m] = tmp;
        }
    }
    
    private function addChild(d:DisplayObject, x:Number = 0, y:Number = 0):void{
        d.x = x;
        d.y = y;
        _root.addChild(d);
    }
    
    private function removeChild(d:DisplayObject):void{
        _root.removeChild(d);
    }

    
    private function tr(...o:Array):void{
        _tf.appendText(o + "\n");
        _tf.scrollV = _tf.maxScrollV;
    }
}

class AlgoCard extends Sprite{
    private var _bmp:Bitmap;
    private var _id:int;
    public var my:Boolean = true;
    
    public function get id():int{return this._id;}
    public function get number():int{return int(this._id / 2);}
    public function get isBlack():Boolean{return !Boolean(_id % 2)};
    
    public function get isOpen():Boolean{
        if(!this.my)return this._bmp.visible;
        return this.filters == [new ColorMatrixFilter([1,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,1,0])];
    }
    public function get isSelectable():Boolean{return !_bmp.visible;}
    
    function AlgoCard(arg:int){
        this._id = arg;

        var g:Graphics = this.graphics;
        g.beginFill(0xffffff * int(!isBlack));
        g.drawRoundRect(0,0,50,70,10);
        g.endFill();
        var fmt:TextFormat = new TextFormat("Osaka",50,0xffffff * int(isBlack));
        var tf:TextField = new TextField();
        tf.defaultTextFormat = fmt;
        tf.autoSize = "left";
        tf.text = String(number);
        var bmpdata:BitmapData = new BitmapData(tf.width,tf.height,true,0);
        bmpdata.draw(tf);
        _bmp = new Bitmap(bmpdata);
        _bmp.x = this.width / 2 - _bmp.width / 2;
        _bmp.y = this.height / 2 - _bmp.height / 2;
        addChild(_bmp);
    }
    
    public function uragaesi():void{
        if(!this.my)this._bmp.visible = !this._bmp.visible;
        else this.filters = [new ColorMatrixFilter([1,0,0,0,0, 0,0,0,0,0, 0,0,0,0,0, 0,0,0,1,0])];
    }
}

class Hand extends Sprite{
    private var _my:Boolean;
    
    function Hand(my:Boolean){
        this._my = my;
        var g:Graphics = this.graphics;
        g.beginFill(0x218555);
        g.drawRect(0,0,400,70);
        g.endFill();
    }
    
    public function add(d:AlgoCard):void{
        if(!this._my){
            d.my = false;
            d.uragaesi();
        }
        for(var i:int = 0; i < numChildren; i++){
            if((getChildAt(i) as AlgoCard).id > d.id)break;
        }
        addChildAt(d,i);
        draw();
    }
    
    private function draw():void{
        var l:int = numChildren;
        for(var i:int = 0; i < l; i++){
            Tweener.addTween(this.getChildAt(i), {x: width / 2 + (i - l / 2) * 50, time:0.8});
        }

    }
}

class NumSelector extends Sprite{
    function NumSelector():void{
        var g:Graphics = this.graphics;
        g.lineStyle(3,0x007929);
        g.beginFill(0xaaff88);
        g.drawRoundRect(-50,0,100,120,10);
        g.endFill();
        this.filters = [new DropShadowFilter()];
        this.name = "body";
        
        var n:Vector.<NumButton> = new Vector.<NumButton>(12);
        for(var i:int = 0; i < 12; i++){
            n[i] = new NumButton(i);
            addChild1(n[i],-42 + 30 * (i % 3),6 + 28 * int(i / 3));
            n[i].addEventListener(MouseEvent.CLICK,onButtonClicked);
        }
        addEventListener(MouseEvent.MOUSE_DOWN,onMouseDown);
    }
    
    private function addChild1(d:DisplayObject,x:Number, y:Number):void{
        d.x = x;
        d.y = y;
        addChild(d);
        
    }
    
    private function onButtonClicked(e:MouseEvent):void{
        dispatchEvent(new NumSelectEvent("numberSelect",(e.target as NumButton).number));
    }

    
    private function onMouseDown(e:MouseEvent):void{
        if(e.target.name != "body") return;
        removeEventListener(MouseEvent.MOUSE_DOWN,onMouseDown);
        startDrag();
        addEventListener(MouseEvent.MOUSE_UP,onMouseUp);
    }
    
    private function onMouseUp(e:MouseEvent):void{
        removeEventListener(MouseEvent.MOUSE_UP,onMouseUp);
        stopDrag();
        addEventListener(MouseEvent.MOUSE_DOWN,onMouseDown);
    }



}

class NumSelectEvent extends Event{
    public var data:int; 
    function NumSelectEvent(type:String,num:int){
        super(type);
        this.data = num;
    }

}

class NumButton extends Sprite{
    
    private var _number:int;
    private var _bmp:Bitmap;
    
    public function get number():int{return _number;}
    
    function NumButton(number:int){
        _number = number;
        var g:Graphics = this.graphics;
        g.lineStyle(2,0x007536);
        g.beginFill(0x38e156);
        g.drawRoundRect(0,0,25,25,10);
        g.endFill();
        var fmt:TextFormat = new TextFormat("MSGothic",28,0x002222);
        var tf:TextField = new TextField();
        tf.defaultTextFormat = fmt;
        tf.autoSize = "left";
        tf.text = String(number);
        var bmpdata:BitmapData = new BitmapData(tf.width,tf.height,true,0);
        bmpdata.draw(tf);
        _bmp = new Bitmap(bmpdata);
        _bmp.x = this.width / 2 - _bmp.width / 2;
        _bmp.y = this.height / 2 - _bmp.height / 2;
        addChild(_bmp);
        addEventListener(MouseEvent.MOUSE_OVER,onMouseOver);
    }
    
    private function onMouseOver(e:MouseEvent):void{
        removeEventListener(MouseEvent.MOUSE_OVER,onMouseOver);
        this.filters = [new GlowFilter()];
        addEventListener(MouseEvent.MOUSE_OUT,onMouseOut);
    }
    private function onMouseOut(e:MouseEvent):void{
        removeEventListener(MouseEvent.MOUSE_OUT,onMouseOut);
        this.filters = [];
        addEventListener(MouseEvent.MOUSE_OVER,onMouseOver);
    }
}

class StayButton extends Sprite{
    private var _active:Boolean;
    
    public function get active():Boolean{return active;}
    public function set active(value:Boolean):void{
        if(value == true){
            this._active = true;
            alpha = 1;
        }
        else {
            this._active = false;
            alpha = 0.5;
        }

    }

    
    function StayButton(){
        var g:Graphics = graphics;
        g.lineStyle(5, 0x006f48);
        g.beginFill(0x60d5ac);
        g.drawRoundRect(0,0,130,50,10);
        g.endFill();
        
        var fmt:TextFormat = new TextFormat("Meiryo",40, 0x003010);
        var tf:TextField = new TextField();
        tf.defaultTextFormat = fmt;
        tf.autoSize = "left";
        tf.text = "Stay";
        var bmpdata:BitmapData = new BitmapData(tf.width,tf.height,true,0);
        bmpdata.draw(tf);
        var bmp:Bitmap = new Bitmap(bmpdata);
        bmp.x = this.width / 2 - bmp.width / 2;
        bmp.y = this.height / 2 - bmp.height / 2;
        addChild(bmp);
    }

}


class BackGround extends Shape{
    function BackGround(){
        var g:Graphics = this.graphics;
        g.beginFill(0x218555);
        g.drawRect(0,0,465,465);
        g.endFill();
    }
}
