/**
 * Copyright nbhd ( http://wonderfl.net/user/nbhd )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jfsl
 */

// 重いので注意！
package  
{
	import flash.filters.GlowFilter;
	import flash.filters.BlurFilter;
	import flash.geom.ColorTransform;
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.events.Event;
	import flash.display.Sprite;

	/**
	 * @author NBHD
	 */
	public class MathGraphics1 extends Sprite 
	{
		
		private var _circle:Particle;
		private var _particleList:Array = [];
		
		private const MAX:uint = 1500;
		
		private var _bmd:BitmapData;
		private var _bmp:Bitmap;
		
		public function MathGraphics1()
		{
			addEventListener(Event.ADDED_TO_STAGE, _onAdded);
		}
		
		private function _onAdded(event:Event):void
		{
			removeEventListener(event.type, arguments.callee);
			
			_circle = new Particle(5, 0xff0000,1);
			addChild(_circle);
			_circle.x = stage.stageWidth / 2;
			_circle.y = stage.stageHeight / 2;
			_circle.mass = 1000;
			
			_bmd = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x000000);
			_bmp = new Bitmap(_bmd);
			
			addChild(_bmp);
			
			
			for(var i:uint = 0; i < MAX; i++) {
				_particleList[i] = new Particle(1, 0xffffff, 0.2);
				_particleList[i].blendMode = 'add';
				addChild(_particleList[i]);
				_particleList[i].x = Math.random() * stage.stageWidth;
				_particleList[i].y = Math.random() * stage.stageHeight;
				_particleList[i].vx = 0;
				_particleList[i].vy = 1;
				_particleList[i].mass = 1;
				_particleList[i].filters = [new BlurFilter(2.5, 2.5), new GlowFilter(Math.random()*0xffffff, 0.7, 2, 2)];
			}
			
			addEventListener(Event.ENTER_FRAME, _onEnterFrame);
			
		}
		
		private function _onEnterFrame(event:Event):void
		{
			_bmd.lock();
			
			for(var i:uint = 0; i < MAX ; i++) {
				_particleList[i].x += _particleList[i].vx;
				_particleList[i].y += _particleList[i].vy;
				_gravitate(_particleList[i], _circle);
			}
			
			_bmd.colorTransform(_bmd.rect, new ColorTransform(1, 1, 1, 1, 1, 1, 1, -1));
			_bmd.draw(root);
			
			_bmd.unlock();
		}
		
		private function _gravitate(tg1:Particle, tg2:Particle):void
		{
			var dx:Number		= tg2.x - tg1.x;
			var dy:Number		= tg2.y - tg1.y;
			var dist:Number	= dx * dx + dy * dy;
			var force:Number	= tg1.mass * tg2.mass / dist;
			var rad:Number		= Math.atan2(dy, dx);
			var forceX:Number	= force * Math.cos(rad);
			var forceY:Number	= force * Math.sin(rad);
			var sumMass:Number	= tg1.mass + tg2.mass;
			
			
			tg1.vx += forceX * tg2.mass / sumMass;
			tg1.vy += forceY * tg2.mass / sumMass;
			tg2.vx -= forceX * tg1.mass / sumMass;
			tg2.vy -= forceY * tg1.mass / sumMass;
		}
	}
}

import flash.display.Sprite;
internal class Particle extends Sprite
{
	private var _vx:Number=0;
	public function get vx():Number {
		return _vx;
	}
	public function set vx(vx:Number):void {
		_vx = vx;
	}
	
	
	private var _vy:Number=0;
	public function get vy():Number {
		return _vy;
	}
	public function set vy(vy:Number):void {
		_vy = vy;
	}
	
	
	private var _mass:Number=1;
	public function get mass():Number {
		return _mass;
	}
	public function set mass(mass:Number):void {
		_mass = mass;
	}
	
	
	public function Particle(r:Number = 1, c:uint = 0xFFFFFF, a:Number = 1):void
	{
		graphics.beginFill(c, a);
		graphics.drawCircle(0, 0, r);
		graphics.endFill();
	}
	
}