/**
 * Copyright NewKrok ( http://wonderfl.net/user/NewKrok )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jfsB
 */

// forked from FLASHMAFIA's qb + disqo
package {
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.filters.BlurFilter;
    import flash.geom.Matrix;

    [SWF(width = '465', height = '465')]
    public class QBlur extends Sprite {
        private var meshes : Vector.<Mesh>;
        private var camTX : Number;
        private var camTY : Number;
        private var camX : Number = 0.0;
        private var camY : Number = 0.0;
        private var camZ : Number = 0.0;
        private var camRX : Number = 0.0;
        private var camRY : Number = 0.0;
        private var camRZ : Number = 0.0;
        private var seed : int = 2222;

        function QBlur() {
            stage.stageFocusRect = mouseEnabled = mouseChildren = tabEnabled = tabChildren = false;
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.quality = StageQuality.HIGH;
            stage.frameRate = 64;
            opaqueBackground = 0x0;

            camTX = 465 / 2;
            camTY = 465 / 2;
            meshes = new Vector.<Mesh>(27, true);

            var meshCnt : uint;
            for (var px : Number = 0; px < 1; px++) {
                for (var py : Number = 0; py < 1; py++) {
                    for (var pz : Number = 0; pz < 1; pz++) {
                        seed = (((seed & 1) - 1) & 0xF00FC7C8) ^ (seed >> 1);
                        var mesh : Mesh = new Cube(new CubeTex(seed & 0xFFCC88), 100);

                        mesh.x = px * 100;
                        mesh.y = py * 100;
                        mesh.z = pz * 100;

                        var faces : Vector.<Face> = mesh.faces;

                        for each (var face : Face in faces) {
                            var tmpSp : Sprite = this;

                            if (face.meshRef.container == null) {
                                var sp : Sprite = new Sprite();
                                tmpSp.addChild(sp);
                                face.meshRef.container = tmpSp = sp;
                            } else {
                                tmpSp = face.meshRef.container;
                            }

                            face.container = tmpSp;
                            face.container.blendMode = BlendMode.ADD;
                            face.blur = new BlurFilter(0, 0, 2);
                            face.graphics = tmpSp.graphics;
                        }

                        meshes[meshCnt++] = mesh;
                    }
                }
            }

            stage.quality = StageQuality.MEDIUM;

            addEventListener(Event.ENTER_FRAME, oef);
        }

        private function oef(evt : Event) : void {
            camRX += .005;
            //camRY += (stage.mouseX - camTX) * 0.00033;

            graphics.clear();
            graphics.beginFill(0x363230);
            graphics.drawRect(0, 0, 465, 465);

            /* render */

            var cosz : Number = lqcos(camRZ);
            var sinz : Number = lqsin(camRZ);
            var cosy : Number = lqcos(camRY);
            var siny : Number = lqsin(camRY);
            var cosx : Number = lqcos(camRX);
            var sinx : Number = lqsin(camRX);
            var sMat : Matrix = new Matrix();
            var tMat : Matrix = new Matrix();

            for each (var mesh : Mesh in meshes) {
                var meshX : Number = mesh.x;
                var meshY : Number = mesh.y;
                var meshZ : Number = mesh.z;

                var vertices : Vector.<Vertex> = mesh.vertices;
                for each (var vertex : Vertex in vertices) {
                    /* mesh : axis */
                    var x1 : Number = vertex.x;
                    var y1 : Number = vertex.y;
                    var z1 : Number = vertex.z;

                    /* mesh : move */
                    var x2 : Number = x1 + meshX - camX;
                    var y2 : Number = y1 + meshY - camY;
                    var z2 : Number = z1 + meshZ - camZ;

                    /* cam : rotate */
                    x1 = x2 * cosz - y2 * sinz;
                    y1 = y2 * cosz + x2 * sinz;
                    z1 = z2 * cosy + x1 * siny;
                    x2 = x1 * cosy - z2 * siny;
                    y2 = y1 * cosx - z1 * sinx;
                    z2 = z1 * cosx + y1 * sinx;

                    /* 3D --> 2D */
                    /* cam focal Length : 250 // camera z-offset : 128 */
                    var s : Number = 250 / (250 + z2 + 150);
                    vertex.scale = s;
                    vertex.prx = (camTX + x2 * s);
                    vertex.pry = (camTY + y2 * s);
                    vertex.x3d = x2;
                    vertex.y3d = y2;
                    vertex.z3d = z2;
                }

                /* Depth of Field */

                var face : Face = mesh.faces[0];

                var a : Vertex = face.va;
                var b : Vertex = face.vb;
                var c : Vertex = face.vc;
                var avgd : Number = 1 - ((a.scale + b.scale + c.scale) / 3);

                //mesh.container.filters = [blur];

                var fg : Graphics = mesh.container.graphics;
                fg.clear();

                for each (face in mesh.faces) {
                    a = face.va;
                    b = face.vb;
                    c = face.vc;

                    var ftex : BitmapData = face.tex;
                    var fw : Number = ftex.width;
                    var fh : Number = ftex.height;
                    var ax : Number = a.prx;
                    var ay : Number = a.pry;
                    var bx : Number = b.prx;
                    var by : Number = b.pry;
                    var cx : Number = c.prx;
                    var cy : Number = c.pry;
                    var u0 : Number = face.u0 * fw;
                    var v0 : Number = face.v0 * fh;
                    var u1 : Number = face.u1 * fw;
                    var v1 : Number = face.v1 * fh;
                    var u2 : Number = face.u2 * fw;
                    var v2 : Number = face.v2 * fh;

                    sMat.setTo((bx - ax) / fw, (by - ay) / fw, (cx - ax) / fh, (cy - ay) / fh, ax, ay);
                    tMat.setTo((u1 - u0) / fw, (v1 - v0) / fw, (u2 - u0) / fh, (v2 - v0) / fh, u0, v0);
                    tMat.invert();
                    tMat.concat(sMat);

                    fg.beginBitmapFill(ftex, tMat, false, false);

                    /* TODO ==>>> Optimize with drawTriangle ? */
                    fg.moveTo(ax, ay);
                    fg.lineTo(bx, by);
                    fg.lineTo(cx, cy);

                    fg.endFill();
                }
            }
        }

        private function lqsin(n : Number) : Number {
            n %= 6.283185307179586;
            if (n > 3.141592653589793) n -= 6.283185307179586;
            if (n < -3.141592653589793) n += 6.283185307179586;
            if (n < 0) return (1.27323954 * n + 0.405284735 * n * n);
            else return (1.27323954 * n - 0.405284735 * n * n);
        }

        private function lqcos(n : Number) : Number {
            n += 1.5707963267948966;
            n %= 6.283185307179586;
            if (n > 3.141592653589793) n -= 6.283185307179586;
            if (n < -3.141592653589793) n += 6.283185307179586;
            if (n < 0) return (1.27323954 * n + 0.405284735 * n * n);
            else return (1.27323954 * n - 0.405284735 * n * n);
        }
    }
}
import flash.display.Bitmap;
import flash.events.Event;
import flash.display.BitmapData;
import flash.display.BlendMode;
import flash.display.Graphics;
import flash.display.Shape;
import flash.display.Sprite;
import flash.filters.BlurFilter;
import flash.filters.GlowFilter;
import flash.display.Loader;
import flash.net.URLRequest;
import flash.system.LoaderContext;


internal class CubeTex extends BitmapData {
    function CubeTex(color : uint) {
        super(100, 100, false, color & 0x20201F);

        var shp : Shape = new Shape();
        shp.graphics.beginFill(0xFF0000);
        shp.graphics.drawRect(0, 0, width, height);
        draw(shp);
        
        loadImage ( "http://th07.deviantart.net/fs71/200H/f/2012/345/d/0/crate_generator_by_dactilardesign-d5np5b6.jpg", drawR )
    }
    
    private function loadImage ( $url:String, $onComplete:Function ) :void {
        var imageLoader:Loader = new Loader ();
        imageLoader.contentLoaderInfo.addEventListener ( Event.COMPLETE, $onComplete );
        var image:URLRequest = new URLRequest ( $url );
        imageLoader.load ( image, new LoaderContext ( true ) );
    }
    
    private function drawR ( event:Event ) :void {
         var tmp:BitmapData = new BitmapData ( event.currentTarget.content.width, event.currentTarget.content.height, true, 0x60 );
         tmp.draw ( event.currentTarget.content );
         draw(tmp);
         var shp : Shape = new Shape();
        shp.graphics.beginFill(0x00FF00);
        shp.graphics.drawRect(0, 0, width, height);
        draw(shp);
    }
}

internal class Mesh {
    public static var seed : uint = 2222;
    public var color : uint;
    public var container : Sprite;
    public var faces : Vector.<Face>;
    public var vertices : Vector.<Vertex>;
    public var x : Number = 0;
    public var y : Number = 0;
    public var z : Number = 0;

    function Mesh() {
        seed = (((seed & 1) - 1) & 0xF00FC7C8) ^ (seed >> 1);
        color = (seed & 0xFF8040);
        faces = new Vector.<Face>();
        vertices = new Vector.<Vertex>();
        vertices.push(new Vertex(0, 0, 0));
    }
}

internal class UV {
    public var u : Number;
    public var v : Number;

    function UV(u : Number = 0.0, v : Number = 0.0) {
        this.u = u;
        this.v = v;
    }
}

internal class Face {
    public var meshRef : Mesh;
    public var blur : BlurFilter;
    public var container : Sprite;
    public var graphics : Graphics;
    public var tex : BitmapData;
    public var va : Vertex;
    public var vb : Vertex;
    public var vc : Vertex;
    public var u0 : Number;
    public var u1 : Number;
    public var u2 : Number;
    public var v0 : Number;
    public var v1 : Number;
    public var v2 : Number;

    function Face(meshRef : Mesh, va : Vertex, vb : Vertex, vc : Vertex, tex : BitmapData, uv0 : UV, uv1 : UV, uv2 : UV) {
        this.meshRef = meshRef;
        this.va = va;
        this.vb = vb;
        this.vc = vc;
        this.tex = tex;
        this.u0 = uv0.u;
        this.u1 = uv1.u;
        this.u2 = uv2.u;
        this.v0 = uv0.v;
        this.v1 = uv1.v;
        this.v2 = uv2.v;
    }
}

internal class Vertex {
    public var x : Number;
    public var y : Number;
    public var z : Number;
    public var prx : Number;
    public var pry : Number;
    public var scale : Number;
    public var x3d : Number;
    public var y3d : Number;
    public var z3d : Number;

    function Vertex(x : Number, y : Number, z : Number) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public function dot(v : Vertex) : Number {
        return (x * v.x + y * v.y + v.z * z);
    }
}

internal class Cube extends Mesh {
    function Cube(tex : BitmapData, s : uint) {
        var v0 : Vertex = new Vertex(-s, -s, -s);
        var v1 : Vertex = new Vertex(s, -s, -s);
        var v2 : Vertex = new Vertex(s, s, -s);
        var v3 : Vertex = new Vertex(-s, s, -s);
        var v4 : Vertex = new Vertex(-s, -s, s);
        var v5 : Vertex = new Vertex(s, -s, s);
        var v6 : Vertex = new Vertex(s, s, s);
        var v7 : Vertex = new Vertex(-s, s, s);
        /* F */
        addFace(v0, v2, v1, tex, new UV(0, 0), new UV(1, 1), new UV(1, 0));
        addFace(v0, v3, v2, tex, new UV(0, 0), new UV(0, 1), new UV(1, 1));
        /* T */
        addFace(v0, v1, v5, tex, new UV(0, 0), new UV(1, 0), new UV(1, 1));
        addFace(v0, v5, v4, tex, new UV(0, 0), new UV(1, 1), new UV(0, 1));
        /* BK */
        addFace(v4, v5, v6, tex, new UV(0, 0), new UV(0, 1), new UV(1, 1));
        addFace(v4, v6, v7, tex, new UV(0, 0), new UV(1, 1), new UV(1, 0));
        /* BT */
        addFace(v3, v6, v2, tex, new UV(0, 0), new UV(1, 1), new UV(1, 0));
        addFace(v3, v7, v6, tex, new UV(0, 0), new UV(0, 1), new UV(1, 1));
        /* R */
        addFace(v1, v6, v5, tex, new UV(0, 0), new UV(1, 1), new UV(0, 1));
        addFace(v1, v2, v6, tex, new UV(0, 0), new UV(1, 0), new UV(1, 1));
        /* L */
        addFace(v4, v3, v0, tex, new UV(0, 0), new UV(1, 1), new UV(0, 1));
        addFace(v4, v7, v3, tex, new UV(0, 0), new UV(1, 0), new UV(1, 1));
    }

    private function addFace(v1 : Vertex, v2 : Vertex, v3 : Vertex, tex : BitmapData, uv0 : UV, uv1 : UV, uv2 : UV) : void {
        faces.push(new Face(this, v1, v2, v3, tex, uv0, uv1, uv2));
        vertices.push(v1);
        vertices.push(v2);
        vertices.push(v3);
    }
}