/**
 * Copyright mousepancyo ( http://wonderfl.net/user/mousepancyo )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jeMM
 */

// ScoreAPIの実装方法を知らなかったので、ちょっと練習のために作ってみました。
// 参考：http://level0.kayac.com/2010/03/wonderflapi.php

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    public class Main extends Sprite {
        
        private var _scoreBoard:ScoreAPI
        
        public function Main(){
            _scoreBoard = new ScoreAPI(stage)
            addScore(Math.random()*1000)
        }
        
        private function mouseClick(e:MouseEvent):void{
            stage.removeEventListener(MouseEvent.MOUSE_DOWN, mouseClick)
            addScore(Math.random()*1000)
        }
        
        private function addScore(score:int):void{
            _scoreBoard.showScoreForm(score)
            _scoreBoard.addEventListener(ScoreAPI.CLOSED, rankingClosed)
        }
        
        private function rankingClosed(e:Event):void{
            stage.addEventListener(MouseEvent.MOUSE_DOWN, mouseClick)
        }
    }
}


import flash.events.EventDispatcher;
import flash.events.Event
import flash.text.TextField;
import flash.display.DisplayObjectContainer;
import flash.display.Stage;
import com.bit101.components.Component;
import com.bit101.components.PushButton;
import net.wonderfl.score.basic.BasicScoreForm;
import net.wonderfl.score.basic.BasicScoreRecordViewer;


class ScoreAPI extends EventDispatcher {
    private var _tfStatus:TextField;
    private var _form:BasicScoreForm;
    private var _ranking:BasicScoreRecordViewer
    private var _stage:Stage
    
    public static const CLOSED:String = "closed"
    
    public function ScoreAPI(target:Stage) {
        _stage = target
        Component.initStage(_stage);
        _tfStatus = new TextField;
        _tfStatus.width = 200
    }
    
    public function showScoreForm(score:int):void{
        _form = new BasicScoreForm(_stage, (465-BasicScoreForm.WIDTH)/2, (465-BasicScoreForm.HEIGHT)/2, score, 'SAVE SCORE', showRanking);
    }
    
    private function showRanking($didSavedScore:Boolean):void {
        _tfStatus.text = 'saved score : ' + $didSavedScore;
        _stage.addChild(_tfStatus);
        //removes form
        _stage.removeChild(_form);
        //
        _ranking = new BasicScoreRecordViewer(_stage, (465-BasicScoreRecordViewer.WIDTH)/2,(465-BasicScoreRecordViewer.HEIGHT)/2,'RANKING', 99, true, onClosed);
    }
    
    private function onClosed():void{
        _stage.removeChild(_ranking)
        dispatchEvent(new Event(ScoreAPI.CLOSED))
        _tfStatus.text = "ステージをクリック"
    }
}