/**
 * Copyright yoneken ( http://wonderfl.net/user/yoneken )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jdE1
 */

// 色々あっていいじゃない Googleだもの
// Matrixの係数には、小数や負数も入れられます
//
// 5ivestar様のProxyを利用させて頂きました。   
// 詳細 => http://5ivestar.org/blog/2008/12/wonderfl-webproxy/     

package {
  [SWF(width="400", height="400")]
  import flash.display.Sprite;
  import flash.events.Event;
  import flash.display.Loader;
  import flash.net.URLRequest;
  import flash.system.Security;
  import flash.events.Event;
  import flash.display.Bitmap;
  import flash.display.BitmapData;
  import flash.filters.ColorMatrixFilter;
  import flash.geom.Rectangle;
  import flash.geom.Point;
  import flash.utils.Timer;
  import flash.events.TimerEvent;

  public class GoogleMatrix extends Sprite   
  {
    private var img:Loader;
    private var t:Timer;
    public function GoogleMatrix()
    {
      super();
      Security.loadPolicyFile("http://5ivestar.org/proxy/crossdomain.xml");
      img = new Loader();
      img.contentLoaderInfo.addEventListener("complete", imgLoaded);  
      t = new Timer(1000, 1);
      t.addEventListener(TimerEvent.TIMER, function():void{
        img.load(new URLRequest("http://5ivestar.org/proxy/http://www.google.com/logos/Logo_60wht.gif"));  
      });
      t.start();
    }

    private function imgLoaded(e:Event):void
    {
      [ArrayElementType("BitmapData")] var a:Array = new Array(10);
      a[0] = new BitmapData(img.width, img.height, true, 0x00000000);
      a[0].draw(img);
      addChild(new Bitmap(a[0]));

      for(var i:int=1;i<10;i++)
      {
        a[i] = new BitmapData(img.width, img.height);
        var cmf:ColorMatrixFilter;
        switch(i)
        {
          case 1:
            // b<=>g
            cmf = new ColorMatrixFilter([
                    1,0,0,0,0,
                    0,0,1,0,0,
                    0,1,0,0,0,
                    0,0,0,1,0]);
            break;
          case 2:
            // r<=>b
            cmf = new ColorMatrixFilter([
                    0,0,1,0,0,
                    0,1,0,0,0,
                    1,0,0,0,0,
                    0,0,0,1,0]);
            break;
          case 3:
            // r<=r, g<=g, b<=r
            cmf = new ColorMatrixFilter([
                    1,0,0,0,0,
                    0,1,0,0,0,
                    1,0,0,0,0,
                    0,0,0,1,0]);
            break;
          case 4:
            // r<=r, g<=g, b<=g
            cmf = new ColorMatrixFilter([
                    1,0,0,0,0,
                    0,1,0,0,0,
                    0,1,0,0,0,
                    0,0,0,1,0]);
            break;
          case 5:
            // r<=r, g<=r, b<=r
            cmf = new ColorMatrixFilter([
                    1,0,0,0,0,
                    1,0,0,0,0,
                    1,0,0,0,0,
                    0,0,0,1,0]);
            break;
          case 6:
            // グレースケール
            cmf = new ColorMatrixFilter([
                    0.3, 0.3, 0.3,   0,   0,
                    0.3, 0.3, 0.3,   0,   0,
                    0.3, 0.3, 0.3,   0,   0,
                      0,   0,   0,   1,   0]);
            break;
          case 7:
            // ネガポジ反転
            cmf = new ColorMatrixFilter([
                     -1,   0,   0,   1,   0,
                      0,  -1,   0,   1,   0,
                      0,   0,  -1,   1,   0,
                      0,   0,   0,   1,   0]);
            break;
          case 8:
            // 夕方（全体的に赤をかける）
            cmf = new ColorMatrixFilter([
                    0.5,   0,   0, 0.5,  0,
                      0,   1,   0,   0,  0,
                      0,   0,   1,   0,  0,
                      0,   0,   0,   1,  0]);
            break;
          case 9:
            // 半透明
            cmf = new ColorMatrixFilter([
                      1,   0,   0,   0,   0,
                      0,   1,   0,   0,   0,
                      0,   0,   1,   0,   0,
                      0,   0,   0, 0.5,   0]);
            break;
        }
        a[i].applyFilter(a[0], new Rectangle(0, 0, img.width, img.height), new Point(0, 0), cmf);
        var b:Bitmap = new Bitmap(a[i]);
        if(i<5){
          b.y = img.height*i;
        }else{
          b.x = img.width;
          b.y = img.height*(i-5);
        }
        addChild(b);
      }
      Wonderfl.capture_delay( 2 );
    }
  }
}