/**
 * Copyright dizgid ( http://wonderfl.net/user/dizgid )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jd2g
 */

// forked from dizgid's flash on 2010-2-4
/*
	Event.RENDERをつかってやってみる。
	たまにうまくいかないことがある。
*/
/*
クリックでstageのqualityを変更してsprite生成

赤がLOWのときにつくったsprite
青がHIGHのときにつくったsprite

3Dのspriteがstage.qualityを変更しても生成時の見えが保持されている。
StageQuality.HIGHのときにつくったものは、stage.qualityを変えてもスムーズ。
StageQuality.LOWのときにつくったものは、stage.qualityを変えてもスムーズではない。
この描画を、制御できないのか？
*/
package {
	import flash.text.TextFormat;
	import flash.text.TextField;
	import flash.events.*;
	import flash.display.StageQuality;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
    	
    		private var _preSp:Sprite;
    		private var _count:int;
        public function FlashTest() {
        		stage.quality = StageQuality.LOW;
			_count = 0;
        		stage.addEventListener(MouseEvent.CLICK, _mouseClickHandler);
        		
        		stage.addEventListener(Event.ENTER_FRAME, _enterframeHandler);
        }
        
        private function _enterframeHandler(e:Event):void
        {
        		stage.invalidate();
        }
        
        private function _mouseClickHandler(e:MouseEvent):void
        {
            	//_delete();
            	stage.quality = StageQuality.HIGH;
            	_create();
            	_count++;
        }
        private function _create():void
        {
        	    var sp:Sprite = new Sprite();
            var size:Number = 250;
            var color:uint = (_count % 2 == 0) ? 0xff0000 : 0x0000ff;
            sp.graphics.lineStyle(4, 0x000000);
            sp.graphics.beginFill(color, 0.8);
            sp.graphics.drawRect(-size/2, -size/2, size, size);
            sp.graphics.endFill();
            
            var txt:TextField = new TextField();
            txt.defaultTextFormat = new TextFormat(null, 60);
            txt.text = "FLASH TEST";
            txt.width = size;
            txt.x = -size/2;
            txt.y = -size/2;
            sp.addChild(txt);
            
            sp.x = stage.stageWidth / 2;
            sp.y = stage.stageHeight / 2;
            sp.x += Math.random() * 60 - 35;
            sp.y += Math.random() * 60 - 35;
            sp.rotationZ = 20;//3D
            //sp.rotation = 20;//2D
            
            sp.addEventListener(Event.ADDED_TO_STAGE, _addStageHandler);
            this.addChild(sp);
            
            _preSp = sp;
        }
        private function _addStageHandler(e:Event):void
        {
        		e.target.addEventListener(Event.RENDER, _renderHandler);
        }
        private function _renderHandler(e:Event):void
        {
        		e.target.removeEventListener(Event.RENDER, _renderHandler);
        		stage.quality = StageQuality.LOW;
        }
        private function _delete():void
        {
        		if(_preSp != null){
        			this.removeChild(_preSp);
        		}
        }
    }
}