/**
 * Copyright Aquioux ( http://wonderfl.net/user/Aquioux )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jbwo
 */

package {
	import flash.display.Sprite;
	[SWF(width = "480", height = "480", frameRate = "30", backgroundColor = "#000000")]
	/**
	 * [WebCam]擬似カラー
	 * 解説：http://aquioux.blog48.fc2.com/blog-entry-709.html
	 * @author Aquioux(Yoshida, Akio)
	 */
	public class Main extends Sprite {
		public function Main():void {
			Wonderfl.capture_delay(10);
			// model
			try {
				var model:Model = new Model(stage);
			} catch (err:Error) {
				trace(err.message);
				return;
			}
			
			// view
			var view:View = new View(model);
			addChild(view);
		}
	}
}


	import flash.display.BitmapData;
	import flash.display.Stage;
	import flash.events.ActivityEvent;
	import flash.events.Event;
	import flash.events.EventDispatcher;
	import flash.geom.Matrix;
	import flash.media.Camera;
	import flash.media.Video;
	/**
	 * Model
	 * @author YOSHIDA, Akio (Aquioux)
	 */
	class Model extends EventDispatcher {
		// ---------- パブリックプロパティ ----------
		//
		// View へ渡すデータ
		public function get data():BitmapData { return _data; }
		private var _data:BitmapData;

		
		// ---------- ローカルプロパティ ----------
		//
		private var stage_:Stage;
		private var cameraWidth_:uint;
		private var cameraHeight_:uint;
		private var camera_:Camera;
		private var video_:Video;
		private var matrix_:Matrix;
		

		// ---------- パブリックメソッド ----------
		//
		/**
		 * コンストラクタ
		 * @param	stage	ステージ
		 * @param	cw		カメラ幅（省略時はステージ幅）
		 * @param	ch		カメラ高（省略時はステージ高）
		 */
		public function Model(stage:Stage, cw:uint = 0, ch:uint = 0) {
			// 引数の処理
			stage_ = stage;
			var w:uint = stage_.stageWidth;
			var h:uint = stage_.stageHeight;
			cameraWidth_  = (cw == 0) ? w : cw;
			cameraHeight_ = (ch == 0) ? h : ch;

			// View へ渡すデータの生成
			_data = new BitmapData(w, h, false, 0x000000);
			
			// 鏡像になるよう、Matrix で左右反転
			var tx:uint = (w - cameraWidth_)  / 2 + cameraWidth_;
			var ty:uint = (h - cameraHeight_) / 2;
			matrix_ = new Matrix( -1, 0, 0, 1, tx, ty);
			
			// カメラ準備
			camera_ = Camera.getCamera();
			if (camera_) {
				// camera のセットアップ
				camera_.setMode(cameraWidth_, cameraHeight_, stage_.frameRate);
				// video のセットアップ
				video_ = new Video(cameraWidth_, cameraHeight_);
				video_.attachCamera(camera_);
				// カメラがアクティブになるまで待つ
				camera_.addEventListener(ActivityEvent.ACTIVITY, activeHandler);
			} else {
				throw new Error("カメラがありません。");
			}
		}
		
		
		// ---------- ローカルメソッド ----------
		//
		// ACTIVITY イベントハンドラ
		private function activeHandler(e:ActivityEvent):void {
			camera_.removeEventListener(ActivityEvent.ACTIVITY, arguments.callee);
			stage_.addEventListener(Event.ENTER_FRAME, enterFrameHandler);
		}
		// ENTER_FRAME イベントハンドラ
		private function enterFrameHandler(event:Event):void {
			_data.draw(video_, matrix_);
			dispatchEvent(new Event(Event.CHANGE));
		}
	}


	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.events.Event;
	/**
	 * View
	 * @author YOSHIDA, Akio (Aquioux)
	 */
	class View extends Bitmap {
		// ---------- パブリックプロパティ ----------
		//
		// Model の参照
		public function set model(value:Model):void { _model = value; }
		private var _model:Model;
		
		
		// ---------- ローカルプロパティ ----------
		//
		private var bmd_:BitmapData;		// Model から取得した BitmapData
		private var pseudo_:PseudoColor;
		private var smooth_:Smooth;

		
		// ---------- パブリックメソッド ----------
		//
		/**
		 * コンストラクタ
		 * @param	model	Model
		 */
		public function View(model:Model) {
			_model = model;
			_model.addEventListener(Event.CHANGE, changeHandler);
			
			pseudo_ = new PseudoColor();
			smooth_ = new Smooth();
			smooth_.strength = 4;
		}
		

		// ---------- ローカルメソッド ----------
		//
		// Model から Event.CHANGE が発行されたときの処理
		// Model から BitmapData を受け取り、視覚化する
		private function changeHandler(e:Event):void {
			if (!bmd_) bmd_ = _model.data.clone();
			bmd_ = _model.data;
			smooth_.applyEffect(bmd_);
			pseudo_.applyEffect(bmd_);
			bitmapData = bmd_;
		}
	}


	import flash.display.BitmapData;
	/**
	 * BitmapDataEffector 用 interface
	 * @author YOSHIDA, Akio (Aquioux)
	 */
	interface IEffector {
		function applyEffect(value:BitmapData):BitmapData;
	}


	import flash.geom.Point;
	/**
	 * bitmapDataEffector パッケージ内のクラスで共通に使う定数など
	 * @author YOSHIDA, Akio (Aquioux)
	 */
	class EffectorUtils {
		// ---------- パブリックプロパティ ----------
		//
		// BitmapData が備える各種メソッドの destPoint 用
		static public const ZERO_POINT:Point = new Point(0, 0);

		
		// ---------- パブリックメソッド ----------
		//
		// 一つのチャンネルにおける濃度の平均値を求める（引数のヒストグラムで調整する）
		static public function getAverageOfBrightness1(hist:Vector.<Number>):uint {
			var sum:uint = 0;
			var numOfPixel:uint = 0;
			for (var i:int = 0; i < 256; i++) {
				sum        += i * hist[i];
				numOfPixel += hist[i];
			}
			return sum / numOfPixel >> 0;
		}
		// RGB チャンネルにおける濃度の各平均値を求める
		static public function getAverageOfBrightness3(hist:Vector.<Vector.<Number>>):Vector.<uint> {
			var rSum:uint = 0;
			var gSum:uint = 0;
			var bSum:uint = 0;
			var numOfPixel:uint = 0;
			for (var i:int = 0; i < 256; i++) {
				rSum += i * hist[0][i];
				gSum += i * hist[1][i];
				bSum += i * hist[2][i];
				numOfPixel += hist[0];
			}
			return Vector.<uint>([rSum / numOfPixel >> 0, gSum / numOfPixel >> 0, bSum / numOfPixel >> 0]);
		}
		
		// 一つのチャンネルにおける濃度の平均値を求める（引数のヒストグラムで調整する）
		static public function getSumOfBrightness1(hist:Vector.<Number>):uint {
			var sum:uint = 0;
			for (var i:int = 0; i < 256; i++) {
				sum += i * hist[i];
			}
			return sum;
		}
		// RGB チャンネルにおける濃度の各平均値を求める
		static public function getSumOfBrightness3(hist:Vector.<Vector.<Number>>):Vector.<uint> {
			var rSum:uint = 0;
			var gSum:uint = 0;
			var bSum:uint = 0;
			for (var i:int = 0; i < 256; i++) {
				rSum += i * hist[0][i];
				gSum += i * hist[1][i];
				bSum += i * hist[2][i];
			}
			return Vector.<uint>([rSum, gSum, bSum]);
		}
	}


	import flash.display.BitmapData;
	import flash.geom.Point;
	import frocessing.color.ColorHSV;
	/**
	 * 疑似カラー
	 * 参考：「ディジタル画像処理」 CG-ARTS協会　P97　「5-3-2 疑似カラー」
	 * http://www.amazon.co.jp/gp/product/4903474011?ie=UTF8&tag=laxcomplex-22
	 * 参考：疑似カラー(Pseudo-color)@画像処理ソリューション
	 * http://imagingsolution.blog107.fc2.com/blog-entry-171.html
	 * @author YOSHIDA, Akio (Aquioux)
	 */
	class PseudoColor implements IEffector {
		// ---------- ローカルプロパティ ----------
		//
		// paletteMap の引数となる Channel 用の Array
		private var array_:Array;
		// グレイスケールエフェクタ
		private var grayscale_:GrayScale;

		private const ZERO_POINT:Point = EffectorUtils.ZERO_POINT;

		
		// ---------- パブリックメソッド ----------
		//
		/*
		 * コンストラクタ
		 */
		public function PseudoColor() {
			// paletteMap 用 Array
			array_ = [];
			var hsv:ColorHSV = new ColorHSV();
			for (var i:int = 0; i < 256; i++) {
				hsv.h = i * 3;
				array_.push(hsv.value);
			}
			array_.reverse();	// 配列を反転
			
			// グレイスケールエフェクタ
			grayscale_ = new GrayScale();
		}
		
		/*
		 * 効果適用
		 * @param	value	効果対象 BitmapData
		 */
		public function applyEffect(value:BitmapData):BitmapData {
			grayscale_.applyEffect(value);
			value.paletteMap(value, value.rect, ZERO_POINT, array_, [], []);
			return value;
		}
	}


	import flash.display.BitmapData;
	import flash.filters.ColorMatrixFilter;
	import flash.geom.Point;
	/**
	 * ColorMatrixFilter による BitmapData のグレイスケール化（NTSC 系加重平均による）
	 * 参考：Foundation ActionScript 3.0 Image Effects(P106)
	 * 		http://www.amazon.co.jp/gp/product/1430218711?ie=UTF8&tag=laxcomplex-22
	 * @author YOSHIDA, Akio (Aquioux)
	 */
	class GrayScale implements IEffector {
		// ---------- ローカルプロパティ ----------
		//
		private const MATRIX:Array = [
			0.3, 0.59, 0.11, 0, 0,
			0.3, 0.59, 0.11, 0, 0,
			0.3, 0.59, 0.11, 0, 0,
			0,   0,    0,    1, 0
		];
		private const FILTER:ColorMatrixFilter = new ColorMatrixFilter(MATRIX);
		
		private const ZERO_POINT:Point = EffectorUtils.ZERO_POINT;

		
		// ---------- パブリックメソッド ----------
		//
		/*
		 * 効果適用
		 * @param	value	効果対象 BitmapData
		 */
		public function applyEffect(value:BitmapData):BitmapData {
			value.applyFilter(value, value.rect, ZERO_POINT, FILTER);
			return value;
		}
	}


	import flash.display.BitmapData;
	import flash.filters.BitmapFilterQuality;
	import flash.filters.BlurFilter;
	import flash.geom.Point;
	/**
	 * BlurFilter による平滑化
	 * @author YOSHIDA, Akio (Aquioux)
	 */
	class Smooth implements IEffector {
		// ---------- パブリックプロパティ ----------
		//
		/*
		 * ぼかしの強さ
		 * @param	value	数値
		 */
		public function set strength(value:Number):void {
			filter_.blurX = filter_.blurY = value;
		}
		/*
		 * ぼかしの質
		 * @param	value	数値
		 */
		public function set quality(value:int):void {
			filter_.quality = value;
		}


		// ---------- ローカルプロパティ ----------
		//
		private var filter_:BlurFilter;		// ブラーフィルタ
		private const ZERO_POINT:Point = EffectorUtils.ZERO_POINT;


		// ---------- パブリックメソッド ----------
		//
		/*
		 * コンストラクタ
		 */
		public function Smooth() {
			filter_ = new BlurFilter(2, 2, BitmapFilterQuality.MEDIUM);
		}
		
		/*
		 * 効果適用
		 * @param	value	効果対象 BitmapData
		 */
		public function applyEffect(value:BitmapData):BitmapData {
			value.applyFilter(value, value.rect, ZERO_POINT, filter_);
			return value;
		}
	}
