/**
 * Copyright onedayitwillmake ( http://wonderfl.net/user/onedayitwillmake )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jbtA
 */

package  
{
	import flash.display.Bitmap;
	import flash.display.BitmapData;
	import flash.display.DisplayObject;
	import flash.display.Graphics;
	import flash.display.PixelSnapping;
	import flash.display.Shape;
	import flash.events.Event;
	import flash.events.TimerEvent;
	import flash.filters.ColorMatrixFilter;
	import flash.utils.Timer;
	import frocessing.color.ColorHSV;
	import gs.easing.Sine;
	import gs.TweenMax;
	import org.papervision3d.cameras.SpringCamera3D;
	import org.papervision3d.core.geom.Lines3D;
	import org.papervision3d.core.geom.Particles;
	import org.papervision3d.core.geom.renderables.Line3D;
	import org.papervision3d.core.geom.renderables.Particle;
	import org.papervision3d.core.geom.renderables.Vertex3D;
	import org.papervision3d.core.math.Number3D;
	import org.papervision3d.core.render.data.RenderHitData;
	import org.papervision3d.core.utils.Mouse3D;
	import org.papervision3d.materials.special.BitmapParticleMaterial;
	import org.papervision3d.materials.special.LineMaterial;
	import org.papervision3d.objects.DisplayObject3D;
	import org.papervision3d.view.BasicView;
	
	/**
	 * Papervsion Particles step 1
	 * @author Mario Gonzalez
	 */
	[SWF(width="465", height="465", backgroundColor="0x000000", frameRate="60")]
	public class ParticleOrbit extends BasicView
	{
		private var _mouse3D			:Mouse3D;
		private var _particles			:Particles = new Particles();
		private var _currentParticle	:Particle;
		
		private var _lines				:Lines3D;
		private var _currentLine		:Line3D;
		private var _lineMaterial		:LineMaterial;
		
		private var PARTICLE_COUNT		:int = 80;
		
		private var _extraRotation		:Number = 0;
		private var _rotationSpeed		:Number = 0.01;
		private var _springCamera		:SpringCamera3D;
		
		private var _currentParticleInArray	:int = 0;
		private var _camTarget			:DisplayObject3D = new DisplayObject3D();
		private var _timer:Timer;
		
		
		private var colorHSV:ColorHSV = new ColorHSV(360, 1, 1);
		private var data:BitmapData;
		
		public function ParticleOrbit() 
		{
                        Wonderfl.capture_delay(6);
                
			Mouse3D.enabled = true;
			super.viewport.interactive = true;
			_mouse3D = viewport.interactiveSceneManager.mouse3D;
			
			
			createParticleRing();
			//createLines3D();
			_springCamera = new SpringCamera3D(90, 10, 5000, false);
			_springCamera.focus = 300;
			_springCamera.zoom = 1;
			_springCamera.target = _camTarget;
			_springCamera.positionOffset = new Number3D(0, -200, 100);
			_springCamera.mass = 20
			_springCamera.damping = 20;
			//_springCamera
			
			_timer = new Timer(3000, 0);
			_timer.addEventListener(TimerEvent.TIMER, changeTarget);
			_timer.start();
			_timer.dispatchEvent(new TimerEvent(TimerEvent.TIMER));
			startRendering();
		}
		
		private function changeTarget(e:TimerEvent):void 
		{
			var p:Particle = Utils.randInArray(_particles.particles) as Particle
			
			TweenMax.to(_camTarget, 1, { x: p.x, y: p.y, z: p.z, ease: Sine.easeInOut } );
		}
		
		private function createLines3D():void
		{
			_lines = new Lines3D();
			_lineMaterial = new LineMaterial(0xffff);
			
			for (var i:int = 0; i < PARTICLE_COUNT; i++)
			{
				var startParticle	:Particle = Utils.randInArray(_particles.particles);
				var endParticle		:Particle = Utils.randInArray(_particles.particles);
				
				var line	:Line3D = new Line3D(_lines, _lineMaterial, 2, startParticle.vertex3D, endParticle.vertex3D);
					line._userData = new LineInfo(startParticle, endParticle);
				_lines.addLine(line);
			}
			
			
			scene.addChild(_lines);
		}
		
		private function createParticleRing():void
		{
			// Make the particle example
			var shape:Shape = new Shape();
			var g:Graphics = shape.graphics;
				g.beginFill(0xffffff, 0.5);
				g.drawCircle(16, 16, 16);
				g.beginFill(0xffffff);
				g.drawCircle(16, 16, 8);
				g.endFill();
			
			data = new BitmapData(shape.width, shape.height, true, 0xFFFFFF);
			data.draw(shape);
			var material:BitmapParticleMaterial = new BitmapParticleMaterial(data, 1);
			
			//_currentParticle = new Particle(material, 1);
			//_particles.addParticle(_currentParticle);
			
			var image:BitmapData = new BitmapData(data.width, data.height, true);
			//Createa a few particles
			for (var i:int = 0; i < PARTICLE_COUNT; i++)
			{
				var theta:Number = (i / PARTICLE_COUNT) * Math.PI * 2;
				colorHSV.h = theta * 180 / Math.PI;
				image = data.clone();
				image.applyFilter(image, image.rect, image.rect.topLeft, new ColorMatrixFilter(ColorHelper.colorize(colorHSV.value)))

				material = new BitmapParticleMaterial(image, 1);
				_currentParticle = new Particle(material, Math.random() * 2 + 1);
				_particles.addParticle(_currentParticle);
			}			
			scene.addChild(_particles);
		}
		
		override protected function onRenderTick(e:Event = null):void
		{
			//_particles.rotationX += 3;
			//_particles.rotationZ += 0.5;
			//_particles.rotationY += 0.5;
			//_mouse3D.updatePosition(viewport.renderHitData)
			//trace(_mouse3D.x, _mouse3D.y, _mouse3D.z);
			//trace(viewport.interactiveSceneManager.currentMousePos)
			//trace(viewport.interactiveSceneManager.currentMousePos);
			_extraRotation += _rotationSpeed;
			for (var i:int = 0; i < PARTICLE_COUNT; i++)
			{
				var theta:Number = (i / PARTICLE_COUNT) * Math.PI * 2 + _extraRotation;
				//_currentParticle = _particles[i] as Particle;
				
				_currentParticle = _particles.particles[i] as Particle;
				_currentParticle.x = Math.cos(theta) * 465;
				_currentParticle.y = Math.sin(theta) * 465;
                               
			}
			
			//for (i = 0; i < PARTICLE_COUNT; i++)
			//{
				//
				//var line:Line3D = _lines.lines[i] as Line3D;
				//var lineInfo:LineInfo = line._userData as LineInfo;
					//line.v0 = lineInfo._startParticle.vertex3D;
					//line.v1 = lineInfo._endParticle.vertex3D;
			//}
//
			//
			//super.onRenderTick(e);
			super.renderer.renderScene(scene, _springCamera, viewport);
		}
	}
}

import org.papervision3d.core.data.UserData;
import org.papervision3d.core.geom.renderables.Particle;

internal class LineInfo extends UserData
{
	public var _startParticle	:Particle;
	public var _endParticle		:Particle;
	
	public function LineInfo(s:Particle, e:Particle)
	{
		_startParticle = s;
		_endParticle = e;
	}
}
internal class Utils
{
	/**
	 * Return a random element inside an array
	 * @param	array, The array you want to get a random element from
	 * @return	*, An object in that array
	 */
	public static function randInArray(array:*):*
	{
		if (array) return array[randRange(0, array.length - 1)];
	}
	
	/**
	 * Random interger within range.
	 * @param	min
	 * @param	max
	 * @return
	 */
	public static function randRange(min:int, max:int):int
	{
		var fmin:Number = min - .4999;
		var fmax:Number = max + .4999;
		return int(Math.round(fmin + (fmax - fmin) * Math.random()));
	}
}


/**
 * Modify the color of an asset without destroying color contrast / shading in the asset.
 * Uses hue/saturation/brightness/contrast to modify a color keeping contrast between colors in the asset intact
 * @version 1.3
 */
internal class ColorHelper
{
	/**
	 * Colorize an asset based on an RGB value
	 * @param	rgb		Hex color value
	 * @param	amount	How much of the original color to keep. [0.0-1.0], 1.0 means none. Range can exceed 1.0 for experimental results
	 */
	public static function colorize(rgb:Number, amount:Number=1):Array
	{
		var r:Number;
		var g:Number;
		var b:Number;
		var inv_amount:Number;
		
		// Found after some googling - @ http://www.faqs.org/faqs/graphics/colorspace-faq/ (ctrl+f luminance)
		var LUMA_R:Number = 0.4086;
		var LUMA_G:Number = 0.7094;
		var LUMA_B:Number = 0.0920;
		
		r = (((rgb >> 16) & 0xFF) / 0xFF);
		g = (((rgb >> 8) & 0xFF) / 0xFF);
		b = ((rgb & 0xFF) / 0xFF);
		
		inv_amount = (1 - amount);
		
		return concat([(inv_amount + ((amount * r) * LUMA_R)), ((amount * r) * LUMA_G), ((amount * r) * LUMA_B), 0, 0,
				((amount * g) * LUMA_R), (inv_amount + ((amount * g) * LUMA_G)), ((amount * g) * LUMA_B), 0, 0, 
				((amount * b) * LUMA_R), ((amount * b) * LUMA_G), (inv_amount + ((amount * b) * LUMA_B)), 0, 0, 
				0, 0, 0, 1, 0]);
	}
	
	/**
	 * Concat two matrices
	 * Could be used to mix colors, but for now it only concacts with an identy matrix
	 * @param	mat	Matrix we want to concact
	 */
	public static function concat( mat:Array ):Array
	{
		// Identity matrix
		var matrix:Array = [1, 0, 0, 0, 0, // RED
							0, 1, 0, 0, 0, // GREEN
							0, 0, 1, 0, 0, // BLUE
							0, 0, 0, 1, 0]; // ALPHA
							
		var temp:Array = new Array();
		
		var i:int = 0;
		var x:int, y:int;
		
		
		// Loop through the matrice
		for (y = 0; y < 4; y++ )
		{
			
			for (x = 0; x < 5; x++ )
			{
				temp[ int( i + x) ] =  Number(mat[i])      * Number(matrix[x]) + 
									   Number(mat[int(i + 1)]) * Number(matrix[int(x +  5)]) + 
									   Number(mat[int(i + 2)]) * Number(matrix[int(x + 10)]) + 
									   Number(mat[int(i + 3)]) * Number(matrix[int(x + 15)]) +
									   (x == 4 ? Number(mat[int(i + 4)]) : 0);
			}
			i+=5;
		}
		
		return temp;
	}
}