/**
 * Copyright tjoen ( http://wonderfl.net/user/tjoen )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jbdW
 */

package {
 
    import away3d.cameras.Camera3D;
    import away3d.containers.ObjectContainer3D;
    import away3d.containers.Scene3D;
    import away3d.containers.View3D;
    import away3d.debug.AwayStats;
    import away3d.lights.DirectionalLight;
    import away3d.materials.ColorMaterial;
    import away3d.materials.methods.FilteredShadowMapMethod;
    import away3d.primitives.Cube;
 
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.events.Event;
    import flash.geom.Vector3D;
 
    [SWF(backgroundColor="#FFFFFF", frameRate="60", width="1000", height="650")]
 
    /**
     * @author Aymeric
     */
    public class Main extends Sprite {
 
        private const _ORIGINE:Vector3D = new Vector3D(0, 0, 0);
        private const _NBR_ELEMENTS:uint = 250;
 
        private var _camera:Camera3D;
        private var _scene:Scene3D;
        private var _view:View3D;
        private var _container:ObjectContainer3D;
 
        private var _tab:Vector.<Cube>;
 
        private var _formOneElement:Boolean;
 
        private var _diffX:int, _diffY:int, _diffZ:int;
 
        public function Main() {
 
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
 
            _scene = new Scene3D();
            _camera = new Camera3D();
            _view = new View3D();
            _view.antiAlias = 2;
            _view.backgroundColor = 0xEEEEEE;
            _view.camera = _camera;
            _view.scene = _scene;
 
            addChild(_view);
            addChild(new AwayStats(_view, false));
 
            _container = new ObjectContainer3D();
            _scene.addChild(_container);
 
            var light:DirectionalLight = new DirectionalLight(-1, -1, 1);
            light.color = 0xFFFFFF;
            light.castsShadows = true;
 
            _container.addChild(light);
            light.x = -15000;
            light.y = -15000;
            light.z = -15000;
 
            _camera.lookAt(_container.position);
 
            _tab = new Vector.<Cube>();
 
            var cube:Cube;
            var colorMaterial:ColorMaterial;
            for (var i:uint = 0; i < _NBR_ELEMENTS; ++i) {
 
                colorMaterial = new ColorMaterial(Math.random() * 0xFFFFFF);
                colorMaterial.lights = [light];
                colorMaterial.shadowMethod = new FilteredShadowMapMethod(light);
 
                cube = new Cube(colorMaterial, 50, 50, 50);
                _container.addChild(cube);
 
                if (i == 0)
                    cube.x = Math.random() * 1000;
                else
                    cube.x = (Math.random() > 0.5) ? Math.random() * 1000 : -Math.random() * 1000;
                cube.y = (Math.random() > 0.5) ? Math.random() * 1000 : -Math.random() * 1000;
                cube.z = (Math.random() > 0.5) ? Math.random() * 1000 : -Math.random() * 1000;
 
                _tab.push(cube);
            }
 
            _formOneElement = false;
 
            addEventListener(Event.ENTER_FRAME, _ef);
            stage.addEventListener(Event.RESIZE, _resize);
 
            _resize();
        }
 
        private function _ef(evt:Event):void {
 
            if (!_formOneElement) {
 
                if (_tab[0].x < 1000) {
 
                    for each (var cube:Cube in _tab) {
 
                        _diffX = 0 - cube.x;
                        _diffY = 0 - cube.y;
                        _diffZ = 0 - cube.z;
 
                        cube.x -= _diffX * 0.05;
                        cube.y -= _diffY * 0.05;
                        cube.z -= _diffZ * 0.05;
                    }
 
                } else {
                    _formOneElement = true;
                }
 
            } else {
 
                if (_tab[0].x > 2) {
 
                    for each (var cubeOne:Cube in _tab) {
 
                        _diffX = 0 - cubeOne.x;
                        _diffY = 0 - cubeOne.y;
                        _diffZ = 0 - cubeOne.z;
 
                        cubeOne.x += _diffX * 0.05;
                        cubeOne.y += _diffY * 0.05;
                        cubeOne.z += _diffZ * 0.05;
                    }
 
                } else {
                    _formOneElement = false;
                }
 
            }
 
            _view.camera.x = 3 * (stage.mouseX - stage.stageWidth * 0.5);
            _view.camera.y = 3 * (stage.mouseY - stage.stageHeight * 0.5);
            _view.camera.lookAt(_ORIGINE);
 
            _view.render();
        }
 
        private function _resize(evt:Event = null):void {
            _view.width = stage.stageWidth;
            _view.height = stage.stageHeight;
        }
    }
}