/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jadd
 */

// forked from clockmaker's [F-site] Sample 02 - Papervision3D
package {
    import flash.events.Event;
    import org.papervision3d.lights.PointLight3D;
    import org.papervision3d.materials.shadematerials.FlatShadeMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.view.BasicView;

    [SWF(backgroundColor=0)]
    public class Main extends BasicView {
        private var wrap:DisplayObject3D;

        public function Main():void {
        
            opaqueBackground = 0x0;

            wrap = new DisplayObject3D();
            scene.addChild(wrap);

            var light:PointLight3D = new PointLight3D();
            var m:FlatShadeMaterial = new FlatShadeMaterial(light, 0xFFFFFF, 0x222222);
            var ml:MaterialsList = new MaterialsList({all: m});

            for (var i:int = 0; i < 50; i++){
                var cube:Cube = new Cube(ml);
                cube.scaleX = 6;
                cube.scaleY = .5;
                cube.scaleZ = 2;
                cube.x = 10000 * (Math.random() - 0.5);
                cube.y = 10000 * (Math.random() - 0.5);
                cube.z = 10000 * (Math.random() - 0.5);

                wrap.addChild(cube);
            }

            startRendering();
            camera.z = 10000;

            addEventListener(Event.ENTER_FRAME, loop);

        }

        private function loop(e:Event):void {
            wrap.rotationY += 10 * (mouseX / stage.stageWidth - 0.5);
        }
    }
}