/**
 * Copyright hosepens ( http://wonderfl.net/user/hosepens )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jaUU
 */

package 
{
    import flash.display.BitmapData;
    import flash.display.Shape;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Vector3D;
    import flash.events.MouseEvent;
    
    [SWF(backgroundColor="#000000", frameRate="60")]
    public class Main extends Sprite 
    {
        private var bmpData:BitmapData;
        private var rightBoards:Vector.<Board>;
        private var leftBoards:Vector.<Board>;
        private var mouse: Vector3D;
        private var vector: Vector3D;
        private var move:Vector3D;
        private var click: Boolean;
        
        public function Main():void
        {
            var shape: Shape = new Shape();
            shape.graphics.beginFill(0xFFFFFF);
            shape.graphics.drawRect(0, 465 / 4, 465, 465 / 2);
            shape.graphics.endFill();
            this.addChild(shape);
            
            const POP: Number = 20;
            
            var leftMask: Sprite = new Sprite();
            leftMask.graphics.beginFill(0x000000);
            leftMask.graphics.drawRect(0, 465 / 4, 465 / 2, 465 / 2);
            leftMask.graphics.endFill();
            var left: Sprite = new Sprite();
            left.y = 465 / 4;
            left.mask = leftMask;
            this.addChild(left);
            leftBoards = new Vector.<Board>();
            for (var i: uint = 0; i < 5; i ++) {
                for (var j: uint = 0; j < 5; j ++ ) {
                    leftBoards[i * 5 + j] = new Board(new Vector3D(i * 100 - 200 + POP, j * 100 - 200, 200 + i * 50), 50, (0xFF * i / 5) << 16 | (0xFF * j / 5) << 8);
                    left.addChild(leftBoards[i * 5 + j]);
                    leftBoards[i * 5 + j].draw();
                }
            }
            
            var rightMask: Sprite = new Sprite();
            rightMask.graphics.beginFill(0x000000);
            rightMask.graphics.drawRect(465 / 2, 465 / 4, 465 / 2, 465 / 2);
            rightMask.graphics.endFill();
            var right: Sprite = new Sprite();
            right.x = 465 / 2;
            right.y = 465 / 4;
            right.mask = rightMask;
            this.addChild(right);
            rightBoards = new Vector.<Board>();
            for (i = 0; i < 5; i ++) {
                for (j = 0; j < 5; j ++ ) {
                    rightBoards[i * 5 + j] = new Board(new Vector3D(i * 100 - 200 - POP, j * 100 - 200, 200 + i * 50), 50, (0xFF * i / 5) << 16 | (0xFF * j / 5) << 8);
                    right.addChild(rightBoards[i * 5 + j]);
                    rightBoards[i * 5 + j].draw();
                }
            }
            
            mouse = new Vector3D(mouseX, mouseY);
            vector = new Vector3D();
            this.addEventListener(Event.ENTER_FRAME, ef);
            click = false;
            stage.addEventListener(MouseEvent.MOUSE_DOWN, md);
            stage.addEventListener(MouseEvent.MOUSE_UP, mu);
        }
        
        private function ef(e: Event): void {
            if(click) {
                vector.incrementBy(new Vector3D((mouseX - mouse.x) / 10, (mouseY - mouse.y) / 10, 0.01));
            }
            vector.scaleBy(0.95);
            mouse.x = mouseX;
            mouse.y = mouseY;
            for (var i: uint = 0; i < 5; i ++) {
                for (var j: uint = 0; j < 5; j ++ ) {
                    leftBoards[i * 5 + j].position.decrementBy(vector);
                    rightBoards[i * 5 + j].position.decrementBy(vector);
                    leftBoards[i * 5 + j].draw();
                    rightBoards[i * 5 + j].draw();
                }
            }
        }
        
        private function md(me: MouseEvent): void {
            click = true;
        }
        
        private function mu(me: MouseEvent): void {
            click = false;
        }
    }
    
}

import flash.display.Sprite;
import flash.filters.BlurFilter;
import flash.geom.Vector3D;

class Board extends Sprite
{
    private var _position: Vector3D;
    private var _size: Number;
    private var _color: uint;
    private var _filter: BlurFilter;
    private const VIEW_ANGLE: Number = 465 / 4 / Math.tan(Math.PI / 6);
    
    public function Board(_position: Vector3D, _size: Number, _color: uint) {
        position = _position;
        size = _size;
        color = _color;
        filter = new BlurFilter();
    }
    
    public function get position():Vector3D { return _position; }
    
    public function set position(value:Vector3D):void 
    {
        _position = value;
    }
    
    public function get size():Number { return _size; }
    
    public function set size(value:Number):void 
    {
        _size = value;
    }
    
    public function get color():uint { return _color; }
    
    public function set color(value:uint):void 
    {
        _color = value;
    }
    
    public function get filter():BlurFilter { return _filter; }
    
    public function set filter(value:BlurFilter):void 
    {
        _filter = value;
    }
    
    public function draw(): void {
        this.graphics.clear();
        if(position.z > 10) {
            this.graphics.beginFill(color);
            this.graphics.drawRect((position.x - size / 2) / position.z * VIEW_ANGLE + 465 / 4, (position.y - size / 2) / position.z * VIEW_ANGLE + 465 / 4, size / position.z * VIEW_ANGLE, size / position.z * VIEW_ANGLE);
            this.graphics.endFill();
            if(position.z < 25500) {
                filter.blurX = position.z / 100;
                filter.blurY = position.z / 100;
            }else {
                filter.blurX = 255;
                filter.blurY = 255;
            }
            this.filters = new Array(filter);
        }
    }
}
