/**
 * Copyright zob ( http://wonderfl.net/user/zob )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jZE8
 */

/**
 * Copyright zonnbe ( http://wonderfl.net/user/zonnbe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/zMMT
 */
package
{
    import flash.display.*;
    import flash.text.*;
    import flash.events.*;
    import flash.display.Sprite;
    import flash.net.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.ui.*;
    import flash.system.*;
    import flash.utils.*;
    import net.hires.debug.Stats;
    import frocessing.color.ColorHSV;
    [SWF(width=465,height=465,backgroundColor=0x000000,frameRate=60)]
    public class gradiusVmini extends Sprite
    {
        private var tbmpd:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight);
        private var bmpd:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight);
        private var bmp:Bitmap = new Bitmap(bmpd);
        private var ebmpd:BitmapData = new BitmapData(stage.stageWidth, stage.stageHeight);
        private var panel:Sprite = new Sprite();
        private var gShip:GShip = new GShip(panel, bmpd, stage.stageWidth/2, stage.stageHeight/2);
        private var hips:Vector.<Dot> = new Vector.<Dot>();
        private var maxhips:int = GB.MAX_ENERMYSHIP;
        private var counter2:int = 0;
        private var gtime:int = 1;
        private var gsum:int = 3;
        private var cT:ColorTransform =  new ColorTransform(1,1,1,0.96);
        private var blurEffect:BlurFilter = new BlurFilter(2,2,2);
        private var glowEffect:GlowFilter = new GlowFilter(0xFF0000CC, 3, 10, 10, 1, 3);
        private var shipBmpd:BitmapData;
        private var enemyBmpd:BitmapData;
        private var ballBmpd:BitmapData;
        private var vcolor:ColorHSV = new ColorHSV(0);
        private var varyColor:Boolean = false;
        private var targetColor:uint = 0x0;
        public function gradiusVmini()
        {
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, init);
            loader.load(new URLRequest("http://assets.wonderfl.net/images/related_images/a/ab/ab4a/ab4afc6ce6b79cbc40cbf6cf019a604c031f437a"), new LoaderContext(true));
        }
        private function init(e:Event):void
        {
            addChild(new Bitmap(new BitmapData(stage.stageWidth, stage.stageHeight, false, 0x000022)));
            var bitmapData:BitmapData = Bitmap(e.target.content).bitmapData;
            shipBmpd = new BitmapData(27, 15, true, 0x0);
            shipBmpd.copyPixels(bitmapData, new Rectangle(0,0,27,15), new Point());
            enemyBmpd = new BitmapData(16, 15, true, 0x0);
            enemyBmpd.copyPixels(bitmapData, new Rectangle(27,0,27,15), new Point());
            ballBmpd = new BitmapData(9, 15, true, 0x0);
            ballBmpd.copyPixels(bitmapData, new Rectangle(44,0,9,15), new Point());
            addChild(new Bitmap(ebmpd));
            addChild(bmp);
            addChild(panel);
            addChild(new Stats());
            panel.filters = [glowEffect]
            stage.addEventListener(KeyboardEvent.KEY_DOWN, onkeyDown);
            stage.addEventListener(KeyboardEvent.KEY_UP, onkeyUp);
            stage.addEventListener(Event.ENTER_FRAME, processing);
        }
        private function onkeyDown(e:KeyboardEvent):void
        {
            switch(e.keyCode)
            {
                case Keyboard.DOWN:
                    gShip.m_moveDown = true;
                    break;
                case Keyboard.UP:
                    gShip.m_moveUp = true;
                    break;
                case Keyboard.LEFT:
                    gShip.m_moveLeft = true;
                    break;
                case Keyboard.RIGHT:
                    gShip.m_moveRight = true;
                    break;
                case 65:
                    gShip.m_rotateLeft = true;
                    break;
                case 68:
                    gShip.m_rotateRight = true;
                    break;
                case 84:
                    gShip.toggleFollowMode();
                    break;
                case 72:
                    gShip.toggleHold();
                    break;
                case 73:
                    gShip.addOption();
                    break
                case 75:
                    gShip.toggleDiffDirection();
                    break
                case 77:
                    gShip.toggleMouseMode();
                    break;
                case 79:
                    gShip.delOption();
                    break;
                case 109:
                    gShip.decreaseEnergyBallsRotateSpeed();
                    break;
                case 107:
                    gShip.increaseEnergyBallsRotateSpeed();
                    break;
                case Keyboard.SPACE:
                    varyColor = !varyColor;
                    if(!varyColor) {glowEffect.color = 0xFF0000AA; panel.filters = [glowEffect];}
                    break;
            }
        }
        private function onkeyUp(e:KeyboardEvent):void
        {
            switch(e.keyCode)
            {
                case Keyboard.DOWN:
                    gShip.m_moveDown = false;
                    break;
                case Keyboard.UP:
                    gShip.m_moveUp = false;
                    break;
                case Keyboard.LEFT:
                    gShip.m_moveLeft = false;
                    break;
                case Keyboard.RIGHT:
                    gShip.m_moveRight = false;
                    break;
                case 65:
                    gShip.m_rotateLeft = false;
                    break;
                case 68:
                    gShip.m_rotateRight = false;
                    break;
            }
        }
        private function processing(e:Event):void
        {
            var i:int = 0;
            bmpd.lock();
            ebmpd.lock();
            var polish:uint = 0x0;
            if(varyColor)
            {
                vcolor.s = 1;
                vcolor.h = getTimer()/5;
                polish = vcolor.value32;
                vcolor.s = 0.1;
                targetColor = vcolor.value32;
            }
            gShip.updateMouse(mouseX, mouseY);
            gShip.update();
            gShip.paint((varyColor)?polish:0xFF0000CC);
            if(counter2%gtime==0)
            {
                var gm:int = 0;
                var rand:Number = 0;
                while(gm<gsum && hips.length<maxhips)
                {
                    rand = Math.random()*(2*Math.PI);
                    hips.push(new Dot(stage.stageWidth/2+250*Math.cos(rand),stage.stageHeight/2+250*Math.sin(rand)));

                    gm++;
                }
                counter2%=gtime;
            }
            counter2++;
            bmpd.colorTransform(bmpd.rect, cT);
            bmpd.applyFilter(bmpd, bmpd.rect, new Point(), blurEffect);
            bmpd.draw(panel);
            gShip.paint((varyColor)?targetColor:0xFF77CCFF);
            ebmpd.fillRect(ebmpd.rect, 0x0);
            var hlen:Number = 0;
            var hvx:Number = 0;
            var hvy:Number = 0;
            for(i=0;i<hips.length;i++)
            {
                hvx = hips[i].x - gShip.m_pos.x;
                hvy = hips[i].y - gShip.m_pos.y;
                hlen = Math.sqrt(hvx*hvx+hvy*hvy);
                if(hlen>10 && !touched(bmpd, hips[i]))
                {
                    hips[i].x -= hvx/hlen;
                    hips[i].y -= hvy/hlen;
                    ebmpd.copyPixels(enemyBmpd, enemyBmpd.rect, new Point(hips[i].x - enemyBmpd.width/2, hips[i].y - enemyBmpd.height/2), null, null, true);
                } else {
                    hips.splice(i,1);
                    i--;
                }
            }
            for(i = 0; i < gShip.m_energyBalls.length; i++)
            {
                ebmpd.copyPixels(ballBmpd, ballBmpd.rect, new Point(gShip.m_energyBalls[i].m_pos.x - ballBmpd.width/2, gShip.m_energyBalls[i].m_pos.y - ballBmpd.height/2), null, null, true);
            }
            ebmpd.copyPixels(shipBmpd, shipBmpd.rect, new Point(gShip.m_pos.x - shipBmpd.width/2, gShip.m_pos.y - shipBmpd.height/2), null, null, true);
            bmpd.unlock();
            ebmpd.unlock();
        }
        private function touched(target:BitmapData, thisDot:Dot):Boolean
        {
            var tx:int = Math.round(thisDot.x);
            var ty:int = Math.round(thisDot.y);
            var tc:uint = (varyColor?targetColor:0xFF77CCFF);
            for(var i:int = -7; i<7; i++)
            {
                if(target.getPixel32(tx,ty+i)==tc) return true;
                if(target.getPixel32(tx+i,ty)==tc) return true;
            }
            return false;
        }
    }
}
import flash.display.*;
import flash.text.*;
import flash.events.*;
import flash.display.Sprite;
import flash.net.*;
import flash.filters.*;
import flash.geom.*;
import flash.ui.*;    
import flash.utils.*;
class EnergyBall
{
    private var m_bmpd:BitmapData;
    private var m_panel:Sprite;
    public var m_pos:Dot;
    private var m_ship:GShip;
    private var m_bpf:int = 1;
    private var m_bltSpeed:int = GB.BULLET_SPEED;
    private var m_blts:Vector.<Dot> = new Vector.<Dot>();
    private var m_reducer:int = GB.BULLET_REDUCER;
    private var m_counter:int = 0;
    private var P0:Point = new Point();
    private var P1:Point = new Point();
    private var P2:Point = new Point();
    private var P3:Point = new Point();
    private var PA:Point = new Point();
    private var PB:Point = new Point();
    private var dx:Number = 0;
    private var dy:Number = 0;
    private var Pc_1:Point = new Point();
    private var Pc_2:Point = new Point();
    private var Pc_3:Point = new Point();
    private var Pc_4:Point = new Point();
    private var Pa_1:Point = new Point();
    private var Pa_2:Point = new Point();
    private var Pa_3:Point = new Point();
    public function EnergyBall(mPanel:Sprite, mBmpd:BitmapData, px:Number, py:Number, mShip:GShip)
    {
        m_ship = mShip;
        m_panel = mPanel;
        m_bmpd = mBmpd;
        m_pos = new Dot(px, py);
    }
    public function update(r:Number = 0):void
    {
        if(m_counter%m_bpf==0)
        {
            var vx:Number = m_ship.m_drt.x;
            var vy:Number = m_ship.m_drt.y;
            if(r!=0)
            {
                var tx:Number = vx;
                vx = vx*Math.cos(r)-vy*Math.sin(r);
                vy = tx*Math.sin(r)+vy*Math.cos(r);
            }
            var len:Number = Math.sqrt(vx*vx+vy*vy);
            var currRad:Number = Math.atan2(vy, vx);
            var lastRad:Number = Math.atan2(m_ship.m_lastdrt.y, m_ship.m_lastdrt.x);
            var radDist:Number = (lastRad-currRad)/Math.PI*180;
            if(radDist>180)
            {
                radDist-=360;
            }
            if(radDist<-180)
            {
                radDist+=360;
            }
            if(m_ship.m_mouseMode && (radDist>0||radDist<0))//mouse mode is dangerous
            {
                var sum:int = radDist;
                var cSum:int;
                while(radDist>0 && radDist >=m_reducer)
                {
                    radDist-=m_reducer;
                    cSum = m_bltSpeed*(sum-radDist)/sum;
                    lastRad-=m_reducer*Math.PI/180;
                    m_blts.push(new Dot(m_pos.x-Math.cos(lastRad)*cSum, m_pos.y-Math.sin(lastRad)*cSum));
                    m_blts[m_blts.length-1].vx = Math.cos(lastRad);
                    m_blts[m_blts.length-1].vy = Math.sin(lastRad);
                }
                while(radDist<0 && radDist <=-m_reducer)
                {
                    radDist+=m_reducer;
                    cSum = m_bltSpeed*(sum-radDist)/sum;
                    lastRad+=m_reducer*Math.PI/180;
                    m_blts.push(new Dot(m_pos.x-Math.cos(lastRad)*cSum, m_pos.y-Math.sin(lastRad)*cSum));
                    m_blts[m_blts.length-1].vx = Math.cos(lastRad);
                    m_blts[m_blts.length-1].vy = Math.sin(lastRad);
                }
            }
            m_blts.push(new Dot(m_pos.x-(vx/len)*m_bltSpeed, m_pos.y-(vy/len)*m_bltSpeed));
            var ci:int = m_blts.length-1;
            m_blts[ci].vx = vx/len;
            m_blts[ci].vy = vy/len;
            m_counter = 0;
            
            m_ship.m_lastdrt.val_p_(vx, vy);
        }
        m_counter++;
        var i:int = 0;
        for(; i<m_blts.length; i++)
        {
            if(m_blts[i].x <0-(m_reducer+1)*m_bltSpeed || m_blts[i].x >GB.STAGE_WIDTH+(m_reducer+1)*m_bltSpeed || m_blts[i].y <0-(m_reducer+1)*m_bltSpeed || m_blts[i].y >GB.STAGE_HEIGHT+(m_reducer+1)*m_bltSpeed)
            {
                m_blts.splice(i,1);
                i--;
            } else {
                m_blts[i].x += m_blts[i].vx*m_bltSpeed;
                m_blts[i].y += m_blts[i].vy*m_bltSpeed;
            }
        }
    }
    public function paint(c:uint = 0x0):void
    {
        var i:int = 0;
        var xc1:Number = 0;
        var yc1:Number = 0;
        var xc2:Number = 0;
        var yc2:Number = 0;
        var xc3:Number = 0;
        var yc3:Number = 0;
        var len1:Number = 0;
        var len2:Number = 0;
        var len3:Number = 0;
        var k1:Number = 0;
        var k2:Number = 0;
        var xm1:Number = 0;
        var ym1:Number = 0;
        var xm2:Number = 0;
        var ym2:Number = 0;
        var ctrl1_x:Number = 0;
        var ctrl1_y:Number = 0;
        var ctrl2_x:Number = 0;
        var ctrl2_y:Number = 0;
        var x1x0:Number = 0;
        var y1y0:Number = 0;
        var x2x1:Number = 0;
        var y2y1:Number = 0;
        var x3x2:Number = 0;
        var y3y2:Number = 0;
        var smooth_value:Number = 1;
        for(i=1; i<m_blts.length-2; i++)
        {
            xc1 = (m_blts[i-1].x + m_blts[i].x) / 2.0;
            yc1 = (m_blts[i-1].y + m_blts[i].y) / 2.0;
            xc2 = (m_blts[i].x + m_blts[i+1].x) / 2.0;
            yc2 = (m_blts[i].y + m_blts[i+1].y) / 2.0;
            xc3 = (m_blts[i+1].x + m_blts[i+2].x) / 2.0;
            yc3 = (m_blts[i+1].y + m_blts[i+2].y) / 2.0;
            x1x0 = m_blts[i].x-m_blts[i-1].x;
            y1y0 = m_blts[i].y-m_blts[i-1].y;
            x2x1 = m_blts[i+1].x-m_blts[i].x;
            y2y1 = m_blts[i+1].y-m_blts[i].y;
            x3x2 = m_blts[i+2].x-m_blts[i+1].x;
            y3y2 = m_blts[i+2].y-m_blts[i+1].y;
            len1 = Math.sqrt((x1x0) * (x1x0) + (y1y0) * (y1y0));
            len2 = Math.sqrt((x2x1) * (x2x1) + (y2y1) * (y2y1));
            len3 = Math.sqrt((x3x2) * (x3x2) + (y3y2) * (y3y2));
            k1 = len1 / (len1 + len2);
            k2 = len2 / (len2 + len3);
            xm1 = xc1 + (xc2 - xc1) * k1;
            ym1 = yc1 + (yc2 - yc1) * k1;
            xm2 = xc2 + (xc3 - xc2) * k2;
            ym2 = yc2 + (yc3 - yc2) * k2;
            ctrl1_x = xm1 + (xc2 - xm1) * smooth_value + m_blts[i].x - xm1;
            ctrl1_y = ym1 + (yc2 - ym1) * smooth_value + m_blts[i].y - ym1;
            ctrl2_x = xm2 + (xc2 - xm2) * smooth_value + m_blts[i+1].x - xm2;
            ctrl2_y = ym2 + (yc2 - ym2) * smooth_value + m_blts[i+1].y - ym2;
            GGraphic.efla(m_bmpd,   m_blts[i].x, m_blts[i].y,   m_blts[i+1].x,m_blts[i+1].y, c);
        }
    }
}
class GShip
{
    public var m_pos:Dot;
    private var m_lastpos:Dot;
    private var m_totalBalls:int = 4;
    private var m_maxBalls:int = GB.MAX_BALLS;
    private var m_radian:Number = 0;
    private var m_radius:Number = GB.MIN_RADIUS;
    private var m_energyPathLength:int = GB.MAX_PATH; //MAX
    private var m_energyPathFLength:int = 0;
    private var m_energyPathAverage:int = 0;
    private var m_energyPath:Vector.<EnergyPath> = new Vector.<EnergyPath>();
    public var m_energyBalls:Vector.<EnergyBall> = new Vector.<EnergyBall>();
    private var m_energyBall:EnergyBall;
    private var m_bmpd:BitmapData;
    private var m_panel:Sprite;
    private var m_moveSpeed:int = GB.SHIP_MOVESPEED;
    public var m_moveUp:Boolean = false;
    public var m_moveDown:Boolean = false;
    public var m_moveLeft:Boolean = false;
    public var m_moveRight:Boolean = false;
    public var m_rotateLeft:Boolean = false;
    public var m_rotateRight:Boolean = false;
    public var m_drt:Dot;
    public var m_lastdrt:Dot;
    private var m_hold:Boolean = false;
    private var m_diffDirection:Boolean = false;
    private var m_totalModes:int = 5;
    private var m_followMode:int = 0;
    public var m_mouseMode:Boolean = false;
    private var m_energyBallsRotateSpeed:int = 10;
    private var m_energyBallsRotateSpeedLimit:int = GB.BULLET_MAX_ROTATESPEED;
    private var m_pAverageMap:Vector.<int> = new Vector.<int>();
    public function GShip(mPanel:Sprite, mBmpd:BitmapData, px:Number, py:Number)
    {
        var i:int;
        m_panel = mPanel;
        m_bmpd = mBmpd;
        
        m_pos = new Dot(px, py);
        m_lastpos = new Dot(px, py);
        m_drt = new Dot(100, 0);
        m_lastdrt = new Dot(100, 0);
        
        for(i = 0; i<m_energyPathLength; i++) m_energyPath.push(new EnergyPath(px, py));
        for(i = 0; i<m_totalBalls; i++) m_energyBalls.push(new EnergyBall(mPanel, mBmpd, px, py, this));
        m_pAverageMap.push(10,  9,  8,  8,  6,  6,  5,  4,  4,  4,  4,  4,  4,  4,  3,  3,  3,  3,  3,  3);
        m_pAverageMap.fixed = true;
        updateShip();
    }
    private function updateShip():void
    {
        m_totalBalls = m_energyBalls.length;
        if(m_totalBalls>0)
        {
            m_energyPathAverage = m_pAverageMap[m_totalBalls-1];
            m_energyPathFLength = m_totalBalls*m_energyPathAverage;
            m_radius = 16 + m_totalBalls;
        }
    }
    public function addOption():void
    {
        if(m_energyBalls.length<m_maxBalls)
        {
            m_energyBalls.push(new EnergyBall(m_panel, m_bmpd, m_pos.x, m_pos.y, this));
            updateShip();
        }
    }
    public function delOption():void
    {
        if(m_energyBalls.length>0)
        {
            m_energyBalls.pop();
            updateShip();
        }
    }
    public function updateMouse(px:Number, py:Number):void
    {
        if(m_mouseMode)
        {
            m_drt.x = px-m_pos.x;
            m_drt.y = py-m_pos.y;
        }
    }
    public function toggleHold():void { m_hold = !m_hold; }
    public function toggleDiffDirection():void { m_diffDirection = !m_diffDirection; }
    public function toggleMouseMode():void { m_mouseMode = !m_mouseMode; }
    public function toggleFollowMode():void
    {
        m_followMode++;
        if(m_followMode>=m_totalModes)
        {
            m_followMode = 0;
        }
    }
    public function decreaseEnergyBallsRotateSpeed():void
    {
        m_energyBallsRotateSpeed--;
        if(m_energyBallsRotateSpeed<=0)
            m_energyBallsRotateSpeed = m_energyBallsRotateSpeedLimit;
    }
    public function increaseEnergyBallsRotateSpeed():void
    {
        m_energyBallsRotateSpeed++;
        if(m_energyBallsRotateSpeed>=m_energyBallsRotateSpeedLimit)
            m_energyBallsRotateSpeed = 1;
    }
    public function update():void
    {
        var i:int;
        
        if(!m_mouseMode && (m_rotateLeft || m_rotateRight))
        {
            var radius:Number;
            var tempX:Number;
            if(m_rotateLeft)
            {
                radius= -8*Math.PI/180;
            }
            if(m_rotateRight)
            {
                radius= 8*Math.PI/180;
            }
            tempX = m_drt.x;
            m_drt.x = m_drt.x * Math.cos(radius) - m_drt.y * Math.sin(radius);
            m_drt.y = tempX * Math.sin(radius) + m_drt.y * Math.cos(radius);
        }
        if(m_moveUp || m_moveDown || m_moveLeft || m_moveRight)
        {
            m_lastpos.val_(m_pos);
            if(m_moveUp)
            {
                m_pos.add_( 0, -m_moveSpeed);
            }
            if(m_moveDown)
            {
                m_pos.add_( 0,  m_moveSpeed);
            }
            if(m_moveLeft)
            {
                m_pos.add_(-m_moveSpeed,  0);
            }
            if(m_moveRight)
            {
                m_pos.add_( m_moveSpeed,  0);
            }
            if(m_followMode==0)
            {
                if(m_hold)
                {
                    var dx:Number = m_pos.x - m_lastpos.x;
                    var dy:Number = m_pos.y - m_lastpos.y;
                    for(i = 0; i<m_energyPathFLength; i++)
                    {
                        m_energyPath[i].m_lastpos.add_(dx, dy);
                        m_energyPath[i].m_pos.add_(dx, dy);
                    }
                } else {
                    m_energyPath[0].m_lastpos.val_(m_energyPath[0].m_pos);
                    m_energyPath[0].m_pos.val_(m_lastpos);
                    for(i = 1; i<m_energyPathFLength; i++)
                    {
                        m_energyPath[i].m_lastpos.val_(m_energyPath[i].m_pos);
                        m_energyPath[i].m_pos.val_(m_energyPath[i-1].m_lastpos);
                    }
                }
                for(i = 0; i< m_totalBalls; i++)
                {
                    m_energyBalls[i].m_pos.val_(m_energyPath[(i+1)*m_energyPathAverage-1].m_pos);
                }
            }
        }
        if(m_followMode==1)
        {
            m_radian +=m_energyBallsRotateSpeed*Math.PI/180;
            m_energyPath[0].m_lastpos.val_(m_energyPath[0].m_pos);
            m_energyPath[0].m_pos.val_p_(m_pos.x+m_radius*Math.cos(m_radian),m_pos.y+m_radius*Math.sin(m_radian));
            for(i = 1; i<m_energyPathFLength; i++)
            {
                m_energyPath[i].m_lastpos.val_(m_energyPath[i].m_pos);
                m_energyPath[i].m_pos.val_(m_energyPath[i-1].m_lastpos);
            }
            for(i = 0; i< m_totalBalls; i++)
            {
                m_energyBalls[i].m_pos.val_(m_energyPath[(i+1)*m_energyPathAverage-1].m_pos);
            }
        }
        if(m_followMode==2)
        {
            m_radian += m_energyBallsRotateSpeed*Math.PI/180;
            var temprad:Number = 0;
            for(i = 1; i<m_energyPathFLength; i++)
            {
                temprad = m_radian+i*Math.PI/180*360/m_energyPathFLength;
                m_energyPath[i].m_pos.val_p_(m_pos.x+m_radius*Math.cos(temprad),m_pos.y+m_radius*Math.sin(temprad));
                m_energyPath[i].m_lastpos.val_(m_energyPath[i].m_pos);
            }
            for(i = 0; i< m_totalBalls; i++)
            {
                m_energyBalls[i].m_pos.val_(m_energyPath[(i+1)*m_energyPathAverage-1].m_pos);
            }
        }
        if(m_followMode==3 || m_followMode==4)
        {
            m_radian += m_energyBallsRotateSpeed*Math.PI/180;
            var vx:Number = 0;
            var vy:Number = 0;
            var rad:Number = Math.PI*2/m_energyPathFLength;
            var t:Number = m_radian;
            for(i = 0; i < m_energyPathFLength; i++)
            {
                if(m_followMode==3)
                {
                    vx = m_pos.x + (m_radius) * Math.sin((t+i*rad));
                    vy = m_pos.y - (m_radius) * Math.cos((t-i*rad));
                }
                if(m_followMode==4)
                {
                    vx = m_pos.x + (m_radius) * Math.sin((t+i*rad)+(i*2)*rad);
                    vy = m_pos.y - (m_radius) * Math.cos((t-(i-1)*rad)+i*(rad*3));
                }
                m_energyPath[i].m_pos.val_p_(vx,vy);
                m_energyPath[i].m_lastpos.val_(m_energyPath[i].m_pos);
            }
            for(i = 0; i< m_totalBalls; i++)
            {
                m_energyBalls[i].m_pos.val_(m_energyPath[(i+1)*m_energyPathAverage-1].m_pos);
            }
        }
        for(i = 0; i< m_totalBalls; i++)
        {
            m_energyBalls[i].update(m_diffDirection?i*Math.PI*2/m_totalBalls:0);
        }
    }
    public function paint(c:uint):void
    {
        GGraphic.dp(m_bmpd, m_pos.x+m_drt.x, m_pos.y+m_drt.y, 0xFFFF6666);
        for(var i:int = 0; i< m_totalBalls; i++) m_energyBalls[i].paint(c);
    }
}
class GGraphic
{
    public function GGraphic() {}
    public static function dp(target:BitmapData, px:int, py:int, color:uint):void
    {
        efla(target, px-5, py-5, px+5, py+5, color);
        efla(target, px-5, py+5, px+5, py-5, color);
    }
    public static function efla(bmd:BitmapData, x:int, y:int, x2:int, y2:int, color:uint):void
    {
        var shortLen:int = y2 - y;
        var longLen:int = x2 - x;
        if (!longLen) if (!shortLen) return;
        var i:int, id:int, inc:int;
        var multDiff:Number;
        // TODO: check for this above, swap x/y/len and optimize loops to ++ and -- (operators twice as fast, still only 2 loops)
        if ((shortLen ^ (shortLen >> 31)) - (shortLen >> 31) > (longLen ^ (longLen >> 31)) - (longLen >> 31)) {
            if (shortLen < 0) {
                inc = -1;
                id = -shortLen % 4;
            } else {
                inc = 1;
                id = shortLen % 4;
            }
            multDiff = !shortLen ? longLen : longLen / shortLen;

            if (id) {
                bmd.setPixel32(x, y, color);
                i += inc;
                if (--id) {
                    bmd.setPixel32(x + i * multDiff, y + i, color);
                    i += inc;
                    if (--id) {
                        bmd.setPixel32(x + i * multDiff, y + i, color);
                        i += inc;
                    }
                }
            }
            while (i != shortLen) {
                bmd.setPixel32(x + i * multDiff, y + i, color);
                i += inc;
                bmd.setPixel32(x + i * multDiff, y + i, color);
                i += inc;
                bmd.setPixel32(x + i * multDiff, y + i, color);
                i += inc;
                bmd.setPixel32(x + i * multDiff, y + i, color);
                i += inc;
            }
        } else {
            if (longLen < 0) {
                inc = -1;
                id = -longLen % 4;
            } else {
                inc = 1;
                id = longLen % 4;
            }
            multDiff = !longLen ? shortLen : shortLen / longLen;

            if (id) {
                bmd.setPixel32(x, y, color);
                i += inc;
                if (--id) {
                    bmd.setPixel32(x + i, y + i * multDiff, color);
                    i += inc;
                    if (--id) {
                        bmd.setPixel32(x + i, y + i * multDiff, color);
                        i += inc;
                    }
                }
            }
            while (i != longLen) {
                bmd.setPixel32(x + i, y + i * multDiff, color);
                i += inc;
                bmd.setPixel32(x + i, y + i * multDiff, color);
                i += inc;
                bmd.setPixel32(x + i, y + i * multDiff, color);
                i += inc;
                bmd.setPixel32(x + i, y + i * multDiff, color);
                i += inc;
            }
        }
    }
}
class Dot
{
    public var x:Number = 0;
    public var y:Number = 0;
    public var tx:Number = 0;
    public var ty:Number = 0;
    public var vx:Number = 0;
    public var vy:Number = 0;
    public var angle:Number = 0;
    public var size:Number = 0;
    public var speed:Number = 0;
    public var m:Number = 0;
    public var rad:Number = 0;
    public function Dot(px:Number,py:Number) { x = px; y = py; tx = x; ty = y; }
    public function val_(p:Dot):Dot { x = p.x; y = p.y; return this; }
    public function val_p_(px:Number, py:Number):Dot { x = px; y = py; return this; }
    public function add_(px:Number, py:Number):Dot { x += px; y += py; return this; }
}
class EnergyPath
{
    public var m_pos:Dot;
    public var m_lastpos:Dot;
    public function EnergyPath(px:Number, py:Number) { m_pos = new Dot(px, py); m_lastpos = new Dot(px, py); }
}
class GB
{
    public static var STAGE_WIDTH:Number = 465;
    public static var STAGE_HEIGHT:Number = 465;
    public static var MAX_BALLS:int = 20;
    public static var MAX_PATH:int = 60;
    public static var MIN_RADIUS:int = 20;
    public static var SHIP_MOVESPEED:int = 3;
    public static var BULLET_SPEED:int = 10;
    public static var BULLET_REDUCER:int = 3;
    public static var BULLET_MAX_ROTATESPEED:int = 20;
    public static var MAX_ENERMYSHIP:int = 1000;
    public function GB() {}
}