/**
 * Copyright Seiya.Kai ( http://wonderfl.net/user/Seiya.Kai )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jZAr
 */

package
{
    import flash.display.Sprite;
    import flash.events.KeyboardEvent;
    import flash.text.TextField;
    
    public class Main02 extends Sprite
    {
        private var sd:SoundTest = new SoundTest();
        
        public function Main02()
        {
            stage.addEventListener(KeyboardEvent.KEY_DOWN,onKeyDown);
            stage.addEventListener(KeyboardEvent.KEY_UP,onKeyUp);
            
            var tf:TextField = new TextField();
            tf.text="キーボードで音を鳴らせます\nA=ド、S=レ、D=ミ、F=ファ、G=ソ、H=ラ、J=シ、K=ド";
            tf.width = 350;
            addChild(tf);
        }
        
        private function onKeyDown(e:KeyboardEvent):void
        {
            sd.Play(e.keyCode);
        }
        
        private function onKeyUp(e:KeyboardEvent):void
        {
            sd.Stop();
        }
        
    }
}


import flash.display.Sprite;
import flash.events.Event;
import flash.events.SampleDataEvent;
import flash.media.Sound;
import flash.media.SoundChannel;
import flash.utils.ByteArray;
import flash.ui.Keyboard;

class SoundTest extends Sprite
{    
    private var FREQUENCY:Number = 440;             // 周波数
    private static const SAMPLING:int = 8192;       // バッファ
    private static const SAMPLING_RATE:int = 44100; // サンプリングレート
    private static const PI:Number = Math.PI * 2;   // 1周期
    private static const VOLUME:Number = 0.8;       // ボリューム
    
    private var sound:Sound = new Sound();
    private var soundChannel:SoundChannel;
    public var isPlay:Number = 0; 
    
    public function SoundTest()
    {
        sound.addEventListener(SampleDataEvent.SAMPLE_DATA, onSampleData);
    }
    
    
    public function Play(code:uint):void
    {
        var keyCheck:int = 0;
        
        if(isPlay == 0)
        {
            switch(code)
            {
                case Keyboard.A: FREQUENCY=261.6255653; break;
                case Keyboard.S: FREQUENCY=293.6647679; break;
                case Keyboard.D: FREQUENCY=329.6275569; break;
                case Keyboard.F: FREQUENCY=349.2282314; break;
                case Keyboard.G: FREQUENCY=391.995436; break;
                case Keyboard.H: FREQUENCY=440; break;
                case Keyboard.J: FREQUENCY=493.8833013; break;
                case Keyboard.K: FREQUENCY=523.2511306; break;
                default: keyCheck = 1; break;
            }
            
            if(keyCheck != 1)
            {
                soundChannel = sound.play();
            }
            
            isPlay = 1;
        }
    }
    
    public function Stop():void
    {
        isPlay = 0;
        soundChannel.stop();
    }
    
    private function onSampleData(e:SampleDataEvent):void
    {
        var data:ByteArray = e.data;
        var pos:Number = e.position;
        var w:Number = (PI / (SAMPLING_RATE / FREQUENCY));
        var phase:Number = (pos * w) % PI;
        for(var i:int = 0 ; i<SAMPLING ; i++)
        {
            var d:Number = VOLUME * Math.sin(phase);
            phase = (phase + w) % PI; 
            
            data.writeFloat(d);
            data.writeFloat(d);
        }
    }
}