/**
 * Copyright tepe ( http://wonderfl.net/user/tepe )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jYZf
 */

package {
    import flash.display.Sprite;
    import flash.text.*;
    import flash.events.*;
    public class FlashTest extends Sprite {
        private var uc:UnionChat = new UnionChat();
        private var tf1:TextField = new TextField();
        private var tf2:TextField = new TextField();
        public function FlashTest() {
            // write as3 code here..
            addChild(tf1);
            addChild(tf2);
            tf1.text = "a";
            tf2.text = "b";
            tf2.x = 200;
            addEventListener(Event.ENTER_FRAME,onFrame);
        }
        private function onFrame(e:Event):void{
            tf1.text = uc.chat;
        }

    }
}

import flash.display.*;
import flash.events.*;
import flash.text.*;
import flash.ui.*;
import flash.utils.*;
  
import net.user1.reactor.Attribute;
import net.user1.reactor.IClient;
import net.user1.reactor.Reactor;
import net.user1.reactor.ReactorEvent;
import net.user1.reactor.Room;
import net.user1.reactor.RoomEvent;
import net.user1.reactor.SynchronizationState; 

class UnionChat extends Sprite {
    // Union objects
    protected var reactor:Reactor;
    protected var chatRoom:Room;
    // User interface objects
    
    private var chatStr:String = "";
    private var userName:String;
    protected var userlist:TextField;//ユーザーリスト
    protected var nameInput:TextField;//ユーザー名入力ボックス
    private var roomName:String = "chatRoom0001";
    public function get chat():String{
        return chatStr;
    }


    // Constructor    
    public function UnionChat(_roomName:String="") {
        if(_roomName.length!=0)roomName = _roomName;
        reactor = new Reactor();
        reactor.addEventListener(ReactorEvent.READY,ready);
        reactor.connect("tryunion.com", 80);//union接続
    }
    
    // Method invoked when the connection is ready
    protected function ready(e:ReactorEvent):void {
      chatStr +="Connected to Union\n";
      chatRoom = reactor.getRoomManager().createRoom(roomName);
      
      chatRoom.addMessageListener("CHAT_MESSAGE", chatMessageListener);
      chatRoom.addEventListener(RoomEvent.JOIN, joinRoomListener);
      chatRoom.addEventListener(RoomEvent.ADD_OCCUPANT, addClientListener);
      chatRoom.addEventListener(RoomEvent.REMOVE_OCCUPANT, removeClientListener);
      chatRoom.addEventListener(RoomEvent.UPDATE_CLIENT_ATTRIBUTE, updateClientAttributeListener);
      
      chatRoom.join();
    }
    
    
    //発言送信
    protected function postComment(comment:String):void {
        chatRoom.sendMessage("CHAT_MESSAGE", true, null, comment);
    }
    
    //名前変更
    // Keyboard listener for nameInput
    protected function nameKeyUpListener (e:KeyboardEvent):void {
      var self:IClient;
      if (e.keyCode == Keyboard.ENTER) {
        self = reactor.self();
        self.setAttribute("username", nameInput.text);
        //nameInput.text = "";
      }
    }
    
    //メッセージ受信
    // Method invoked when a chat message is received
    protected function chatMessageListener (fromClient:IClient, 
                                            messageText:String
                                            ):void {
        chatStr += getUserName(fromClient) + " : " + messageText + "\n";
    }
    
    //ユーザーリスト更新イベント
    // Method invoked when the current client joins the room
    protected function joinRoomListener (e:RoomEvent):void {
      updateUserList();
    }
    
    
    //入室
    // Method invoked when a client joins the room
    protected function addClientListener (e:RoomEvent):void {
      var d:Date = new Date();
      if (e.getClient().isSelf()) {
        chatStr += "You joined the chat. ["+ d.toLocaleTimeString() + "]\n";
        var self:IClient = reactor.self();
        nameInput.text = self.getAttribute("username");
      } else {
        if (chatRoom.getSyncState() != SynchronizationState.SYNCHRONIZING) {
   
          chatStr += getUserName(e.getClient())
                                      + " joined the chat. ["+ d.toLocaleTimeString() + "]\n";
        }
      }
      updateUserList();
    }
    
    //退室
    // Method invoked when a client leave the room
    protected function removeClientListener (e:RoomEvent):void {
      var d:Date = new Date();
      chatStr += getUserName(e.getClient())
                                  + " left the chat. ["+ d.toLocaleTimeString() + "]\n";
      updateUserList();
    }
    

    protected function updateClientAttributeListener (e:RoomEvent):void {
      var changedAttr:Attribute = e.getChangedAttr();
      if (changedAttr.name == "username") {
        if (changedAttr.oldValue == null) {
          chatStr += "Guest" + e.getClientID();
        } else {
          chatStr += changedAttr.oldValue;
        }
        chatStr += " 's name changed to "
                                    + getUserName(e.getClient())
                                    + ".\n";
        updateUserList();
      }
    }
    
    //ユーザーリスト更新
    protected function updateUserList ():void {
      userlist.text = "";
      for each (var client:IClient in chatRoom.getOccupants()) {
        userlist.appendText(getUserName(client) + "\n");
      }
    }
    
    //ユーザー名取得
    protected function getUserName (client:IClient):String {
      var username:String = client.getAttribute("username");
        if (username == null) {
          return "Guest" + client.getClientID();
        } else {
          return username;
        }
    }
  }