/**
 * Copyright uzucky ( http://wonderfl.net/user/uzucky )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jY9o
 */

// forked from clockmaker's [PV3D] Field of Blur
/**
* Papervision3Dで被写界深度
* 参照： http://clockmaker.jp/blog/2008/07/pv3d_gw_blur/
*/
package
{
	import flash.display.*;
	import flash.events.*;
	import flash.filters.*;
	
	import org.papervision3d.view.*;
	import org.papervision3d.materials.*;
	import org.papervision3d.objects.*;
	import org.papervision3d.objects.primitives.*
	
        [SWF(width = "465", height = "465", frameRate = "60", backgroundColor = "#000000")]
	
	public class Main extends BasicView 
	{	
		// const vars
		static private const OBJ_LENGTH   :int = 20;
		static private const CIRCLE_RANGE :int = 500;
		
		// 3d vars
		private var list :Array = []
		private var wrap :DisplayObject3D;

		/**
		 * Constructor
		 */
		public function Main()
		{
			//camera
			camera.x         = 0;
			camera.y         = 200;
			camera.z         = 1000;
			camera.rotationX = 5;
			
			// wrap
			wrap = new DisplayObject3D();
			scene.addChild(wrap);
			
			for (var i:int = 0; i < OBJ_LENGTH; i++)
			{
				var rot:Number = 360 * i / OBJ_LENGTH ;
				
				var m:ColorMaterial = new ColorMaterial(0x0066CC);
				m.doubleSided = true;
				
				var o:Plane = new Plane(m, 100, 100);
				o.x = CIRCLE_RANGE * Math.sin(rot * Math.PI / 180);
				o.y = 0;
				o.z = CIRCLE_RANGE * Math.cos(rot * Math.PI / 180);
				o.rotationY = rot;
				o.useOwnContainer = true; //ココ重要
				
                                // 配列に追加　＆　wrapの子供にする
				list.push(wrap.addChild(o));
			}
			
			addEventListener(Event.ENTER_FRAME, loop);
			startRendering(); 
		}
		
                // loop
		private function loop(event:Event):void
		{
			wrap.yaw(-1);
                        
                        // 被写界深度
			for (var i:int = 0; i < list.length; i++)
			{
				var o:DisplayObject3D = list[i] as DisplayObject3D;
				var blur:Number = Math.ceil((CIRCLE_RANGE - o.sceneZ) / 50); 
				o.filters = [new BlurFilter(blur, blur, 2)];
			}
		}
	}
}