/**
 * Copyright bongiovi015 ( http://wonderfl.net/user/bongiovi015 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jXg9
 */

package {

    import caurina.transitions.Tweener;
    
    import flash.display.GradientType;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Matrix;
    import flash.net.URLLoader;
    import flash.net.URLRequest;
    
    
    public class Pratice0810 extends Sprite {
        public static const NAMESPACE_KULER : String = "http://kuler.adobe.com/kuler/API/rss/";
        private static const APIKEY    : String = "4A297340291400B78BF1DFFE0E8E1678";
        public var kuler : Namespace = new Namespace(NAMESPACE_KULER);
        private var __loader : URLLoader;
        
        public var container : Sprite = new Sprite;
        public var colors : Array = [];
        public var W : int = 465;
        public var H : int = 465;
        
        
        public function Pratice0810() {
            __loader = new URLLoader();
            __loader.addEventListener(Event.COMPLETE, __onGetColor);
            stage.addEventListener(MouseEvent.CLICK, getColor);
            getColor();
            
            addChild(container);
        }
        
        public function getColor(e:Event=null) : void {    __loader.load(new URLRequest("http://kuler-api.adobe.com/rss/get.cfm?listType=rating&startIndex=0&itemsPerPage=20&key=" + APIKEY ));    }
        
        private function __onGetColor(e:Event) : void {
            var xml:XML = XML(__loader.data);
            colors = [];
            var list:XMLList = new XMLList(xml.channel.item);
            var index : int = int(Math.random() * list.length());
            var theme:XML = list[index];
            var swatchList:XMLList = new XMLList(theme.kuler::themeItem.kuler::themeSwatches.kuler::swatch);
            var i : int = 0;
            var sColor:String;
            var color:uint
            for(i=0; i<swatchList.length(); i++) {
                sColor = swatchList[i].kuler::swatchHexColor;
                color = parseInt("0x"+sColor);
                colors.push(color);
            }
            
            clear();
            colors = shuffle(colors);
            createCircles();
        }
        
        
        public function createCircles():void {
            var mtx:Matrix = new Matrix;
            mtx.createGradientBox(W, H);
            var tempColors:Array = colors.concat();
            
            graphics.beginGradientFill(GradientType.RADIAL, [tempColors.pop(), tempColors.pop()], [1, 1], [0, 255], mtx);
            graphics.drawRect(0, 0, W, H);
            graphics.endFill();
            
            
            var numCircles:int = Math.floor(random(20, 35));
            for(var i:int=0; i<numCircles; i++) {
                var c:Circle = new Circle(tempColors); 
                container.addChild(c);
                c.x = Math.random() * W;
                c.y = Math.random() * H;
                c.scaleX = c.scaleY = 0.001;
                Tweener.addTween(c, {time:random(0.5, 1.2), transition:"easeOutBack", scaleX:1, scaleY:1, delay:Math.random()*1});
            }
        }
        
        
        public function clear() : void {
            graphics.clear();
            while(container.numChildren > 0) container.removeChildAt(0);
        }
        
        
        
        public static function shuffle(ary:Array) : Array {
            var resultArray:Array    = ary.concat();
            
            for (var i:int = 0; i < resultArray.length; i++){
                var tmp:* = resultArray[i];
                var randomNum:Number    = Math.floor(Math.random() * resultArray.length);
                resultArray[i]    = resultArray[randomNum];
                resultArray[randomNum] = tmp;
            }
            
            return resultArray;
        }
        
        
        public static function random(min:Number, max:Number) : Number {    return min + Math.random() * ( max - min);    }
    }
}





import flash.display.Sprite;
import flash.events.Event;

class Circle extends Sprite {
    public static const MIN_R : int = 5;
    public static const MAX_R : int = 50;
    public static const MIN_WEIGHT : int = 2;
    public static const MAX_WEIGHT : int = 15;
    
    protected var _colors:Array;
    protected var _preIndex : int = -1;
    protected var _vr : Number;
    protected var _direction : Number;
    
    public function Circle(colors:Array) : void {
        _colors = colors;
        _vr = Pratice0810.random(1, 4);
        _direction = Math.random() > .5 ? 1 : -1;
        
        var scale:Number = Pratice0810.random(.5, 1.3);
        var numCircles:int = Math.floor(Pratice0810.random(5, 10));
        var i:int = 0;
        var index:int;
        var tx:Number, ty:Number;
        
        for(i=0; i<numCircles; i++) {
            do {
                index = Math.floor(Math.random() * _colors.length);
            }while( index == _preIndex);
            _preIndex = index;
            
            tx = Pratice0810.random(-5, 5);
            ty = Pratice0810.random(-5, 5);
            
            graphics.beginFill(_colors[index], i == 0 ? 1 : 0);
            graphics.lineStyle(Pratice0810.random(MIN_WEIGHT*scale, MAX_WEIGHT*scale), _colors[index]);
            graphics.drawCircle(tx, ty, Pratice0810.random(MIN_R*scale, MAX_R*scale));
            if(i==0) graphics.endFill();
        }
    }
    
}