/**
 * Copyright leocavalcante ( http://wonderfl.net/user/leocavalcante )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jWIM
 */

package 
{
    import flash.display.Sprite;
    import flash.events.Event;
    
    [SWF(width=180, height=180, frameRate=60)]
    
    public class Main extends Sprite 
    {
        private const LINES:Array = ["1", "2", "3", "4", "5"];
        private const COLUMNS:Array = ["A", "B", "C", "D", "E"];
        
        private var table:Table;
        
        public function Main():void 
        {
            addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(event:Event):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            
            table = new Table(LINES, COLUMNS);
            addChild(table);
        }
        
    }
    
}

import gs.TweenMax;
import flash.display.Shape;
import flash.display.Sprite
import flash.events.MouseEvent;
import flash.text.TextField;
import flash.text.TextFieldAutoSize;
import flash.text.TextFormat;

class Table extends Sprite
{
    private var currentLine:Tile;
    private var currentColumn:Tile;
    
    public function Table(lines:Array, columns:Array)
    {
        var tile:Tile;
        
        var firstTile:Tile = new Tile("");
        firstTile.stateDisabled();
        addChild(firstTile);
        
        for each (var line:String in lines)
        {
            tile = new Tile(line);
            tile.type = "line";
            tile.y = (lines.indexOf(line) + 1) * tile.height;
            tile.addEventListener(MouseEvent.CLICK, tileClick);
            tile.stateNormal();
            addChild(tile);
        }
        
        for each (var column:String in columns)
        {
            tile = new Tile(column);
            tile.type = "column";
            tile.x = (columns.indexOf(column) + 1) * tile.width;
            tile.addEventListener(MouseEvent.CLICK, tileClick);
            tile.stateNormal();
            addChild(tile);
        }
    }
    
    private function tileClick(event:MouseEvent):void 
    {
        if (event.currentTarget.type == "line")
        {
            if (currentLine != null) currentLine.stateNormal();
            currentLine = event.currentTarget as Tile;
            currentLine.stateActive();
        }
        else if (event.currentTarget.type == "column")
        {
            if (currentColumn != null) currentColumn.stateNormal();
            currentColumn = event.currentTarget as Tile;
            currentColumn.stateActive();
        }
        
        if (currentLine != null && currentColumn != null)
        {
            if (getChildByName(currentLine.data + currentColumn.data))
            {
                removeChild(getChildByName(currentLine.data + currentColumn.data));
            }
            else
            {
                var selectedTile:Tile = new Tile(currentLine.data + currentColumn.data);
                selectedTile.x = currentColumn.x;
                selectedTile.y = currentLine.y;            
                selectedTile.stateMarked();
                addChild(selectedTile);
            }            
            
            currentLine.stateNormal();
            currentColumn.stateNormal();
            
            currentLine = null;
            currentColumn = null;
        }
    }
}

class Tile extends Sprite
{
    public var type:String;
    public var data:String;
    
    private var background:Shape;
    private var textfield:TextField;
    
    public function Tile(data:String)
    {
        this.data = data;
        name = data;
        
        mouseChildren = false;
        
        background = new Shape();
        background.graphics.beginFill(0xffffff);
        background.graphics.drawRect(0, 0, 30, 30);
        background.graphics.endFill();
        addChild(background);
        
        textfield = new TextField();
        textfield.autoSize = TextFieldAutoSize.LEFT;
        textfield.defaultTextFormat = new TextFormat("Arial", 12, 0, true);
        textfield.text = data;
        addChild(textfield);
        
        //stateNormal();
    }
    
    public function stateDisabled():void
    {
        buttonMode = false;
        TweenMax.to(background, .25, {tint:0});
        removeEventListener(MouseEvent.ROLL_OVER, rollOver);
        removeEventListener(MouseEvent.ROLL_OUT, rollOut);
    }
    
    public function stateNormal():void
    {
        buttonMode = true;
        TweenMax.to(background, .25, {removeTint:true});
        TweenMax.to(textfield, .25, {removeTint:true});
        
        addEventListener(MouseEvent.ROLL_OVER, rollOver);
        removeEventListener(MouseEvent.ROLL_OUT, rollOut);
    }
    
    public function stateActive():void
    {
        buttonMode = false;
        TweenMax.to(background, .25, {tint:0});
        TweenMax.to(textfield, .25, {tint:0xffffff});
        
        removeEventListener(MouseEvent.ROLL_OVER, rollOver);
        removeEventListener(MouseEvent.ROLL_OUT, rollOut);
    }
    
    public function stateMarked():void
    {
        buttonMode = false;
        TweenMax.to(background, .25, {tint:0xff0000});
        TweenMax.to(textfield, .25, {tint:0xffffff});
        
        removeEventListener(MouseEvent.ROLL_OVER, rollOver);
        removeEventListener(MouseEvent.ROLL_OUT, rollOut);
    }
    
    public function stateMouseOver():void
    {
        buttonMode = true;
        TweenMax.to(background, .25, {tint:0xeeefff});
        TweenMax.to(textfield, .25, {tint:0x000000});
        
        removeEventListener(MouseEvent.ROLL_OVER, rollOver);
        addEventListener(MouseEvent.ROLL_OUT, rollOut);
    }
    
    private function rollOver(event:MouseEvent):void 
    {
        stateMouseOver();
    }
    
    private function rollOut(event:MouseEvent):void 
    {
        stateNormal();
    }
}