/**
 * Copyright tenasaku ( http://wonderfl.net/user/tenasaku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jWFJ
 */

/*
	三角形の三頂点 { C0, C1, C2 } を制御点として
	三辺上にひとつずつ取った点 { P0, P1, P2 } を
	curvtTo() で結び卵形線を描く
	P0, P1, P2 を動かして内部を白く塗ればオバケのできあがり
	目玉の位置は P0,P1,P2 の重心と P0 または P1 との中間点
	--------------------------------------------------
	現在は C0,C1,C2 を固定したうえ
	P0,P1,P2 の位置を時間のみの函数で決めているけど
	こいつらをインタラクティブに変化させると面白いかも
 */

package {

	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	import flash.utils.*;

	public class Main extends Sprite {

		private var eggCurve:Sprite;
		private var leftEye:EyeBall;
		private var rightEye:EyeBall;
		private var C0:Point;
		private var C1:Point;
		private var C2:Point;

		private function atEveryFrame(e:Event):void {
			var theta:Number = getTimer()*Math.PI/10000;
			var t0:Number = (1+0.6*Math.cos(theta*3))/2;
			var t1:Number = (1+0.6*Math.cos(theta*5))/2;
			var t2:Number = (1+0.8*Math.cos(theta*2))/2;
			var P0:Point = new Point(t0*C1.x+(1-t0)*C2.x,t0*C1.y+(1-t0)*C2.y);
			var P1:Point = new Point(t1*C2.x+(1-t1)*C0.x,t1*C2.y+(1-t1)*C0.y);
			var P2:Point = new Point(t2*C0.x+(1-t2)*C1.x,t2*C0.y+(1-t2)*C1.y);
			eggCurve.visible = false;
			eggCurve.graphics.clear();
			eggCurve.graphics.lineStyle(NaN);
			eggCurve.graphics.beginFill(0xffffff);
			eggCurve.graphics.moveTo(P0.x,P0.y);
			eggCurve.graphics.curveTo(C1.x,C1.y,P2.x,P2.y);
			eggCurve.graphics.curveTo(C0.x,C0.y,P1.x,P1.y);
			eggCurve.graphics.curveTo(C2.x,C2.y,P0.x,P0.y);
			eggCurve.graphics.endFill();
			var LX:Number = (P0.x*4+P1.x+P2.x)/6;
			var LY:Number = (P0.y*4+P1.y+P2.y)/6;
			var MX:Number = (P0.x+P1.x*4+P2.x)/6;
			var MY:Number = (P0.y+P1.y*4+P2.y)/6;
			leftEye.x = LX;
			leftEye.y = LY;
			rightEye.x = MX;
			rightEye.y = MY;
			eggCurve.visible = true;
		}

		private function initialize(e:Event):void {
			this.removeEventListener(Event.ADDED_TO_STAGE, initialize);
			this.graphics.beginFill(0x000066);
			this.graphics.drawRect(0,0,465,465);
			this.graphics.endFill();
			C0 = new Point(-232,   0);
			C1 = new Point( 232,   0);
			C2 = new Point(   0,-220*Math.sqrt(3));
			eggCurve = new Sprite;
			eggCurve.x = 232.5;
			eggCurve.y = 464;
			leftEye = new EyeBall;
			rightEye = new EyeBall;
			eggCurve.addChild(leftEye);
			eggCurve.addChild(rightEye);
			this.addChild(eggCurve);
			stage.addEventListener(Event.ENTER_FRAME, atEveryFrame);
		}

		// The Main constructor simply calles initialize() function.

		public function Main():void {
			if ( stage != null ) {
				initialize(null);
			} else {
				this.addEventListener(Event.ADDED_TO_STAGE, initialize);
			}
		}

	} // end of class Main
} // end of package

import flash.display.*;

class EyeBall extends Sprite {
	private const R_lid:Number = 16;
	private const R_iris:Number = 8;
	private const eyeColor:uint = 0x000000;
	private var iris:Sprite;
	public function redraw():void { // とりあえず瞳を動かさないで作ってみる
		iris.x = 0;
		iris.y = 0;
	}
	public function EyeBall():void {
		this.graphics.clear();
		this.graphics.lineStyle(2,0x000000);
		this.graphics.beginFill(0xffffff);
		this.graphics.drawCircle(0,0,R_lid);
		this.graphics.endFill();
		iris = new Sprite();
		iris.graphics.clear();
		iris.graphics.beginFill(eyeColor);
		iris.graphics.drawCircle(0,0,R_iris);
		iris.graphics.endFill();
		this.addChild(iris);
	}
}
