/**
 * Copyright nutsu ( http://wonderfl.net/user/nutsu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jV8D
 */

// forked from nutsu's FractalSample
// see http://gihyo.jp/design/feature/01/frocessing/0002
package  
{
    import frocessing.display.F5MovieClip2D;
    
    [SWF(width=465,height=465,backgroundColor=0xFFEECC)]
    public class FractalSample2 extends F5MovieClip2D
    {
        private var shape_size:Number;
        private var r1:Number;
        private var r2:Number;
        private var r3:Number;
        private var r4:Number;
        
        public function FractalSample2() 
        {
            //線と塗りの色指定
            stroke( 0, 0.25 );
            colorMode( RGB, 10 );
            
            //キャンバスを移動
            translate(465/2, 465/2 + 20);
            
            //シェイプの大きさ
            shape_size = 200;
            
            //シェイプのパラメータ
            r1 = shape_size*1.25;
            r2 = shape_size*0.5;
            r3 = shape_size*1.0;
            r4 = shape_size*0.75;
            
            //フラクタルの描画(再帰回数を指定)
            draw_shapes( 4 );
        }
        
        private function draw_shapes( n:int ):void
        {
            if ( n-- <= 0 ) return;
            
            var rn:int = 3;
            
            //キャンバスのサイズを半分に
            scale( 0.5 );
            for ( var i:int = 0; i < rn; i++ ) {
                
                pushMatrix();
                //Y方向に-r移動
                translate( 0, -shape_size );
                
                //シェイプの描画
                fill( 10 - n, 0, 0 );
                draw_shape();
                
                //再帰的に描画
                draw_shapes( n );
                popMatrix();
                
                //360/rn 度回転
                rotate( 2*Math.PI/rn );
            }
        }
        
        private function draw_shape():void
        {
            line( 0, 0,  r1,  r1 );
            line( 0, 0, -r2,  r2 );
            line( 0, 0, -r3, -r3 );
            line( 0, 0,  r4, -r4 );
            circle( 0, 0, 60 );
            circle(  r1,  r1, 30 );
            circle( -r2,  r2, 30 );
            circle( -r3, -r3, 30 );
            circle(  r4, -r4, 30 );
        }
    }
}