/**
 * Copyright hemingway ( http://wonderfl.net/user/hemingway )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jTRZ
 */

package {
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    public class Main extends Sprite {
        private var _players:Vector.<BasePlayer>;
        
        public function Main() {
            this._players = new Vector.<BasePlayer>();
            this._players.push(new LocalPlayer(new <int>[90, 90], 10, 100, 64, 0x000000)); //index 0 of _players is always LocalPlayer
            this._players.push(new EnemyPlayer(new <int>[200, 200], 10, 100, 64, 0xFF0000, new Vector.<int>));
            
            this.addEventListener(Event.ADDED_TO_STAGE, this.addedToStageHandler);
        }
        
        private function addedToStageHandler($event:Event):void {
            this.removeEventListener(Event.ADDED_TO_STAGE, this.addedToStageHandler);
            
            for (var $:int; $<this._players.length; $++) {
                this.addChild(this._players[$]);
            }
        }
    }
}

/***************
 * Base classes
 */

import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;

/***************
 * Player controls the champion
 */
internal class BasePlayer extends Sprite {
    public var champion:BaseChampion;
    public var color:uint;
    
    public function BasePlayer($champion:BaseChampion, $color:uint) {
        this.champion = $champion;
        this.color = $color;
    }
    
    public function initPlayer($color:uint):void {
        this.graphics.clear();
        this.graphics.lineStyle(1, $color);
        this.graphics.beginFill(0xFFFFFF, 0);
        this.graphics.drawCircle(0, 0, 8);
        this.graphics.lineStyle(1, $color, 0.2);
        this.graphics.drawCircle(0, 0, this.champion.range);
        this.graphics.lineStyle(0);
        this.graphics.endFill();
    }
}

internal class BaseChampion {
    public var spells:Vector.<BaseSpell>;
    public var health:int;
    public var speed:int;
    public var range:int;
    
    public function BaseChampion($spells:Vector.<BaseSpell>, $health:int, $speed:int, $range:int) {
        this.spells = $spells;
        this.health = $health;
        this.speed = $speed;
        this.range = $range;
    }
}

internal class BaseSpell {
    public var cooldown:int;
    public var radius:int;
    public var delay:int;
    public var range:int;
    public var color:uint;
    
    public function BaseSpell($cooldown:int, $radius:int, $delay:int, $range:int, $color:uint) {
        this.cooldown = $cooldown;
        this.radius = $radius;
        this.delay = $delay;
        this.range = $range;
        this.color = $color;
    }
}

internal class LocalPlayer extends BasePlayer {
    public var mouse:int;
    public var enemyNear:int;
    public var champion:Champion;
    
    public function LocalPlayer($pos:Vector.<int>, $speed:int, $health:int, $range:int, $color:uint) {
        super($champion, $color);
        this.enemyNear = 0;
        this.mouse = 0;
        
        this.addEventListener(Event.ADDED_TO_STAGE, this.addedToStageHandler);
    }
    
    private function addedToStageHandler($event:Event):void {
        this.removeEventListener(Event.ADDED_TO_STAGE, this.addedToStageHandler);
        
        this.x = this.position[0];
        this.y = this.position[1];      
        
        this.initPlayer(this.color, this.range);
        this.addEventListener(Event.ENTER_FRAME, this.updatePlayer);
        this.stage.addEventListener(MouseEvent.MOUSE_DOWN, this.mouseDownHandler);
        this.stage.addEventListener(MouseEvent.MOUSE_UP, this.mouseUpHandler);
    }

    private function mouseDownHandler($event:MouseEvent):void {
        this.mouse = 1;
    }

    private function mouseUpHandler($event:MouseEvent):void {
        this.mouse = 0;
    }
    
    private function updatePlayer($event:Event):void {
        var $calcX:int = ((this.stage.mouseX - this.x)/this.speed);
        var $calcY:int = ((this.stage.mouseY - this.y)/this.speed);
        
        if (this.mouse) {
            this.x = this.position[0] += $calcX;
            this.y = this.position[1] += $calcY;
        }
    }
}

internal class EnemyPlayer extends BasePlayer {
    public var waypoints:Vector.<int>;
    
    public function EnemyPlayer($pos:Vector.<int>, $speed:int, $health:int, $range:int, $color:uint, $waypoints:Vector.<int>) {
        super($pos, $speed, $health, $range, $color);
        this.waypoints = $waypoints;    
        
        this.addEventListener(Event.ADDED_TO_STAGE, this.addedToStageHandler);
    }
    
    private function addedToStageHandler($event:Event):void {
        this.removeEventListener(Event.ADDED_TO_STAGE, this.addedToStageHandler);
        
        this.x = this.position[0];
        this.y = this.position[1];
        
        this.initPlayer(this.color, this.range);
    }
}



internal class Spell_NoxiousBlast extends BaseSpell {
    
    public function Spell_NoxiousBlast() {
        super(100, 44, 100, 250, 0x00FF00);
        
    }
}

internal class Champion_Cassiopeia extends BaseChampion {
    public function Champion_Cassiopeia() {
        
    }
}