/**
 * Copyright Temjin ( http://wonderfl.net/user/Temjin )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jT5e
 */

// forked from k__'s dripping, breeding
package {
        //need to be refactored
	import flash.display.*;
	import flash.events.*;
	import flash.filters.*;
	import flash.geom.*;
	
	public class Main extends Sprite {
	
		private var space:Sprite;
		private var floor:BitmapData;
		private var brush:Sprite;
		private var bobbles:Array;
		private var cx:Number, cy:Number;
		private var msx:Number, msy:Number;
		private var fils:Array;
		
		public function Main() {
			addChild(new Bitmap(floor = new BitmapData(stage.stageWidth, stage.stageHeight)));
			addChild(space = new Sprite());
			brush = new Sprite();
			bobbles = [];
			stage.addEventListener(MouseEvent.MOUSE_MOVE, h_mouseMove);
			addEventListener(Event.ENTER_FRAME, h_enterFrame);
			msx = cx = stage.stageWidth / 2;
			msy = cy = stage.stageHeight / 2;
			space.filters = [new BlurFilter()];
			fils = [];
			fils.push(new BlurFilter(2,2));
			fils.push(new ColorMatrixFilter([1.004,0,0,0,0, 0,1.004,0,0,0, 0,0,1.004,0,0, 0,0,0,1,0]));
		}
		
		private function h_enterFrame(evt:Event):void {
			update();
		}
		
		private function h_mouseMove(evt:MouseEvent):void {
			for (var i:uint = 0; i < 3; i ++) {
				var b:Object = {};
				var r:Number = Math.random() * Math.PI * 2;
				var d:Number = Math.random() * 5;
				b.vx = Math.cos(r) * d + (mouseX - msx) / 10;
				b.vy = Math.sin(r) * d + (mouseY - msy) / 10;
				b.vz = Math.random() * 8;
				b.x = mouseX - cx + b.vx;
				b.y = mouseY - cy + b.vy;
				b.z = 0;
				b.col = Math.floor(Math.random() * 0xffffff);
				b.size = Math.random() * 10;
				bobbles.push(b);
			}
			
			msx = mouseX;
			msy = mouseY;
		}
		
		private function update():void {
			var temp:Array = bobbles.concat();
			temp.sortOn(z);
			bobbles = new Array();
			space.graphics.clear();
			space.graphics.clear();
			for (var i:uint = 0; i < temp.length; i ++) {
				temp[i].vz -= 0.5;
				temp[i].x += temp[i].vx;
				temp[i].y += temp[i].vy;
				temp[i].z += temp[i].vz;
				draw(space.graphics, temp[i], 0.6);
				if (temp[i].z > -20) {
					bobbles.push(temp[i]);
				} else {
					brush.graphics.clear();
					draw(brush.graphics, temp[i], 0.9);
					floor.draw(brush, null, null,BlendMode.DARKEN);
				}
			}
			
			for (i = 0; i < fils.length; i ++) {
				floor.applyFilter(floor, floor.rect, new Point(0,0), fils[i]);
			}
		}
		
		private function draw(g:Graphics, b:Object, a:Number):void {
			var scale:Number = (b.z + 200) / 200;
			g.beginFill(b.col,a);
			g.drawCircle(cx + b.x * scale, cy + b.y * scale, b.size * scale);
			g.endFill();
		}
		
	}
}