/**
 * Copyright paulstamp1 ( http://wonderfl.net/user/paulstamp1 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jSpt
 */

/**                                                          
     _____ _____ _____ __       _____ _____ _____ _____ _____ 
    |  _  |  _  |  |  |  |     |   __|_   _|  _  |     |  _  |
    |   __|     |  |  |  |__   |__   | | | |     | | | |   __|
    |__|  |__|__|_____|_____|  |_____| |_| |__|__|_|_|_|__|   
    @paulstamp
                                                       
    This example shows how a 'tag & term' system can be used
    to insert random/precise data stored in a dictionary.

*/
package {
    import flash.display.AVM1Movie;
    import flash.text.TextFormat;
    import flash.text.TextField;
    import flash.utils.Dictionary;
    import flash.display.Sprite;
    public class FlashTest extends Sprite
    {   
        public function FlashTest() 
        {
            //TextField
            var txt:TextField = new TextField();
            txt.width = 465;
            txt.height = 465;
            txt.defaultTextFormat = new TextFormat( "_sans", 20 );
            txt.wordWrap = true;
            txt.multiline = true;
            addChild( txt );
            
            //Data
            var data:Dictionary = new Dictionary();
            data["sexes"] = new Term( ["male", "female"], Term.RANDOM );
            data["sex"] = data["sexes"].term;
            data["male first name"] = new Term( ["Paul", "Dave", "Bill"], Term.RANDOM );
            data["female first name"] = new Term( ["Jane", "Sarah", "Katie"], Term.RANDOM );
            data["second name" ] = new Term( ["Stamp", "Warren", "Robinson"], Term.RANDOM );
            data["full name" ] = "<" + data["sex"] + " first name> <second name>";
            data["date"] = new Term( ["today", "yesterday"], Term.FIRST );
            data["weather"] = new Term( ["sunny", "wet", "cloudy"], Term.RANDOM );
            data["greeting"] = new Term( ["Hello", "Bonjour", "Welcome", "¡hola"], Term.RANDOM );
            data["startrek games"] = new Term( ["Anbo-jitsu", "Parrises Squares", "Tsunkatse", "Chula", "Dabo", "Kadis-kot", "Strategema"], Term.RANDOM );
            data["board games"] = new Term( ["Monopoly", "Scrabble"], Term.RANDOM);
            data["game"] = new Term( ["<startrek games>", "<board games>"], Term.RANDOM );
            data["statement"] = new Term( ["I see you are a <sex>."], Term.FIRST );
            data["question"] = new Term( ["How are you today?", "Do you like <weather> days?", "Do you fancy a game of <game>?"], Term.DIFFERANT_FROM_LAST_USED );
            
           //Message
            var message:String = "<greeting> <full name>, <statement> <question> <question>";

           //Insert data into the string 
            txt.text = insertData( message, "<", ">", data );
        }
        
        private function insertData( string:String, openTag:String, closeTag:String, data:Dictionary ):String
        {
           var subs:Array = string.split( openTag );
           var pos:int;
           var sub:String;           
           var reform:String = "";
           
           for( var i:uint; i < subs.length; i++ )
           {
               sub = subs[i];
               pos = sub.indexOf(closeTag);
               
               if( pos > -1 )
               {
                    var s:String = sub.substr( 0, pos );
                    var r:String;
                    
                    //check for term
                    if( data[s] is Term )
                        r = data[s].term;
                        
                    else
                        r = data[s];
                     
                    if( r != null )
                    {
                        //insert data into word
                        r = insertData( r, openTag, closeTag, data );
                        
                        sub = strReplace( sub, s+closeTag, r );
                        subs[i] = sub;
                    }
               }  
               reform += sub;              
           }
           return reform;
        }
        
        private function strReplace( str:String, search:String, replace:String ):String 
        {
             return str.split(search).join(replace);
        }
    }
}

class Term
{
    public static const RANDOM:String = "random";
    public static const FIRST:String = "first";
    public static const LAST:String = "last";
    public static const DIFFERANT_FROM_LAST_USED:String = "diffFromLast";
    
    private var _terms:Array;
    private var _type:String;
    private var _last:String;
    
    public function Term( terms:Array, type:String = "first" )
    {
        _type = type;
        _terms = terms;
    }
    
    public function get lastUsedTerm():String
    {
        return _last;
    }

    public function get type():String
    {
        return _type;
    }
    
    public function set type( value:String ):void
    {
        _type = value;
    }

    public function get term():String
    {
        switch( _type )
        {
            case RANDOM:
                return randomTerm;
                break;
            case FIRST:
                return first;
                break;
             case LAST:
                return last;
                break;
             case DIFFERANT_FROM_LAST_USED:
                 return differentTerm;
                break;
        }
        
        return first;
    }
    
    public function get first():String
    {
        return _last = _terms[0] || "";
    }

    public function get last():String
    {
        return _last = _terms.length > 0 ? _terms[_terms.length-1] : _terms[0] || ""; 
    }

    public function get differentTerm():String
    {
         var random:String = _last;
         var count:int = 0;
         
         while( random == _last )
         {
             random = randomTerm;
             
             //prevent perpetual loop of doom..
             count++;
             if( count > 10 )
                 return _last;
         }
         
         return _last = random;
    }

    public function get terms():Array
    {
        return _terms.concat();
    }
    
    public function get termsCount():uint
    {
        return _terms.length;
    }
    
    public function getTerm( position:uint ):String
    {
         return _terms[ position ] || "";
    }

    private function get randomTerm():String
    {
        return _last = _terms.length > 1 ? _terms[ Math.ceil(Math.random() * _terms.length-1)] || "" : _terms[0] || "";
    }
}
