/**
 * Copyright hourglasseye ( http://wonderfl.net/user/hourglasseye )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jRmQ
 */

package
{
	import flash.accessibility.Accessibility;
	import flash.geom.Point;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    
    public class ShyCircles extends Sprite
    {
    		private const SIGHT:Number = 200;
    		private const DIAMETER:Number = 30;
    		
    		private const RADIUS:Number = DIAMETER * 0.5;
    		private const SIZE:int = int( 465 / DIAMETER );
    		
    		private const NORMAL_MODE:int = 0;
    		private const SINE_MODE:int = 1;
    		private const COSINE_MODE:int = 2;
    		
    		private var mode:int;
    		
    		public function ShyCircles()
        {
        		addEventListener( Event.ADDED_TO_STAGE, function( e:Event ) : void {
        			mode = 0;
        			var circles:Array = [];
        			var cursor:Point = new Point();
        			var circleLocation:Point = new Point();
        			
        			for( var row:int = 0; row < SIZE; row++ )
        			{
        				for( var col:int = 0; col < SIZE; col++ )
        				{
        					var circle:Sprite = new Sprite();
        					circle.graphics.beginFill( 0x000000 );
        					circle.graphics.drawCircle( 0, 0, RADIUS );
        					circle.x = RADIUS + col * DIAMETER;
        					circle.y = RADIUS + row * DIAMETER;
        					circles.push( circle );
        					addChild( circle );
        				}
        			}
        			
        			stage.addEventListener( MouseEvent.CLICK, function( f:MouseEvent ) : void {
					mode = ++mode > 2 ? 0 : mode;
        			} );
        			
        			addEventListener( Event.ENTER_FRAME, function( f:Event ) : void {
        				var max:int = circles.length;
        				cursor.x = stage.mouseX;
        				cursor.y = stage.mouseY;
        				for( var i:int = 0; i < max; i++ )
        				{
        					var circle:Sprite = circles[i];
        					circleLocation.x = circle.x + RADIUS;
        					circleLocation.y = circle.y + RADIUS;
        					var scale:Number = Point.distance( circleLocation, cursor ) / SIGHT;
        					switch( mode )
        					{
        						case NORMAL_MODE:
		        					scale = scale > 1 ? 1 : scale;
        							break;
        						case SINE_MODE:
		        					scale = Math.sin( Math.PI * ( scale > 1 ? 1 : scale ) );
        							break;
        						case COSINE_MODE:
		        					scale = Math.cos( Math.PI * ( scale > 1 ? 1 : scale ) );
        							break;
        					}
        					circle.scaleX = scale;
        					circle.scaleY = scale;
        				}
        			} );
        		} );
        }
    }
}