/**
 * Copyright yama3 ( http://wonderfl.net/user/yama3 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jRRv
 */

package {
    import flash.display.Sprite;
    import flash.display.DisplayObject;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Vector3D;
    import com.bit101.components.Slider;
    import jp.progression.commands.tweens.DoTweener;
    
    public class FlashTest extends Sprite {
        private var _numPanels:int = 100;
        private var _panelWidth:int = 400;
        private var _pitch:Number = 80;
        private var _container:Sprite;
        private var _items:Vector.<Sprite>;
        private var slider:Slider;
        
        public function FlashTest() {
            root.transform.perspectiveProjection.fieldOfView = 65;
            graphics.beginFill(0xffffff);
            graphics.drawRect(0, 0, 465, 465);
            graphics.endFill();
            slider = new Slider("horizontal",this,10,360,onSlider);
            slider.width = 445;
            slider.height = 15;
            addPanels();            
        }
        
        private function addPanels():void {
            _container = new Sprite();
            _items = Vector.<Sprite>([]);
            var i:int = 0;
            while(i < _numPanels) {
                var panel:Panel = new Panel(_panelWidth, 300, Math.random() * 0xffffff, i + 1);
                panel.x = _pitch * i + _pitch * .5 + stage.stageWidth * .5 - 40;
                panel.y = stage.stageHeight * .5;
                panel.z = Math.abs(_container.x + panel.x - stage.stageWidth * .5) + 300;
                panel.addEventListener(MouseEvent.MOUSE_OVER, onOver);
                _container.y = -100;
                _container.addChild(panel);
                _items.push(panel);
                i++;                
            }
            addChild(_container);
            sortItems();
            slider.addEventListener(MouseEvent.MOUSE_UP, onUp);
        }
        
        private function onSlider(e:Event = null):void {
            _container.x = -(slider.value * ((_numPanels - 1) * _pitch) * .01);
            panelSlide();
        }
        
        private function onUp(e:MouseEvent):void {
            var val:Number = slider.value;
            var pos:Number = 100 / (_numPanels - 1);
            if(val % pos != 0) {
                slider.value = (val - val % pos);
                onSlider();
            };
        }
        
        private function panelSlide():void {
            var i:int = 0;
            while(i < _numPanels) {
                _items[i].z = Math.abs(_container.x + _items[i].x - stage.stageWidth * .5) + 300;
                i++;
            }
            sortItems();
        }
        
        private function sortItems():void {
            _items.sort(depthSort);
            for(var i:int = 0; i < _items.length; i++) {
                _container.addChildAt(_items[i] as Sprite, i);
            }
        }
        
        private function depthSort(objA:DisplayObject, objB:DisplayObject):int {
            return objB.z - objA.z;
        }
        
        private function onOver(e:MouseEvent):void {
            var sp:Sprite = e.currentTarget as Sprite;
            if(sp.z > 301) return;
            var com:DoTweener = new DoTweener(sp, {scaleX:2, scaleY:2, time:1, transition:"easeOutBounce"});
            com.execute();
            sp.addEventListener(MouseEvent.MOUSE_OUT, onOut);         
        }
        
        private function onOut(e:MouseEvent):void {
            var sp:Sprite = e.currentTarget as Sprite;
            sp.removeEventListener(MouseEvent.MOUSE_OUT, onOut);
            var com:DoTweener = new DoTweener(sp, {scaleX:1, scaleY:1, time:.5, transition:"easeOutBounce"});
            com.execute();
        }
    }
}

import flash.display.Sprite;
import flash.display.Graphics;
import flash.filters.DropShadowFilter;
import com.bit101.components.Label;

class Panel extends Sprite {
    public function Panel(w:int, h:int, col:int, n:int) {
        var g:Graphics = this.graphics;
        g.beginFill(col);
        g.drawRoundRect(-w * .5, -h * .5, w, h, 8, 8);
        g.endFill();
        g.beginFill(0xFFFFFF, .6);
        g.drawRect(-w * .5, h * .4, w, h * .1 -4);
        g.endFill();
        var label:Label = new Label(this, -35, h * .377|0, "Color:#" + col.toString(16) + " / Page:" + n.toString());
        label.scaleX = label.scaleY = 2;
        var dropShadow:DropShadowFilter = new DropShadowFilter(10, 80, 0, .5, 10, 10, 1, 2);
        this.filters = [dropShadow];
    }

}
