/**
 * Copyright kawamura ( http://wonderfl.net/user/kawamura )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jQW7
 */

package 
{
    import flash.display.Graphics;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.events.MouseEvent;
    import flash.geom.Rectangle;
    import flash.text.TextField;
    import flash.text.TextFormat;
    
    /**
     * ...
     * @author Jaiko
     */
    public class Main extends Sprite 
    {
        private var tf:TextField;
        private var handle:Sprite;
        private var target:Sprite;
        private var bar:Sprite;
        private var sprite:Sprite;
        
        public function Main():void 
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void 
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            layout();
        }
        private function layout():void
        {
            var g:Graphics
            tf = new TextField();
            var format:TextFormat = new TextFormat(null, 36);
            tf.defaultTextFormat = format;
            addChild(tf);
            
            g = this.graphics;
            g.lineStyle(2, 0);
            g.moveTo(0, stage.stageHeight * 0.5);
            g.lineTo(stage.stageWidth , stage.stageHeight * 0.5);
            
            target = new Sprite();
            addChild(target);
            g = target.graphics;
            g.beginFill(0xFF0000, 0.3);
            g.drawRect(0, 0, 100, 30);
            target.x = stage.stageWidth * 0.5 - 50;
            target.y = stage.stageHeight * 0.5 - 15;
            
            sprite = new Sprite();
            addChild(sprite);
            sprite.x = stage.stageWidth * 0.5 - 150;
            sprite.y = stage.stageHeight * 0.5 - 15;
            
            handle = new Sprite();
            sprite.addChild(handle);
            g = handle.graphics;
            g.beginFill(0x6600FF, 0.3);
            g.drawRect(0, 0, 80, 30);
            handle.addEventListener(MouseEvent.MOUSE_DOWN, handleMouseDownListener);
            
            bar = new Sprite();
            sprite.addChild(bar);
            g = bar.graphics;
            g.beginFill(0xFF0000 , 0.3);
            g.drawRect(0, 0, 30, 30);
            bar.x = handle.width - bar.width;
            bar.y = 0;
            bar.addEventListener(MouseEvent.MOUSE_DOWN, barMouseDownListener);
            
            
            addEventListener(Event.ENTER_FRAME, enterFrameListener);
        }
        
        private function barMouseDownListener(e:MouseEvent):void 
        {
            bar.startDrag(false, new Rectangle(30, 0, stage.stageWidth, 0));
            
            stage.addEventListener(MouseEvent.MOUSE_UP, barMouseUpListener);
        }
        
        private function barMouseUpListener(e:MouseEvent):void 
        {
            bar.stopDrag();
            stage.removeEventListener(MouseEvent.MOUSE_UP, barMouseUpListener);
        }
        
        private function handleMouseDownListener(e:MouseEvent):void 
        {
            sprite.startDrag(false, new Rectangle(0, stage.stageHeight * 0.5 - 15, stage.stageWidth, 0));
            //
            stage.addEventListener(MouseEvent.MOUSE_UP, mouseUpListener);
        }
        
        private function mouseUpListener(e:MouseEvent):void 
        {
            sprite.stopDrag();
            stage.removeEventListener(MouseEvent.MOUSE_UP, mouseUpListener);
        }
        
        private function enterFrameListener(e:Event):void 
        {
            var flag:Boolean;
            var g:Graphics;
            g = handle.graphics;
            g.clear();
            g.beginFill(0x6600FF, 0.3);
            g.drawRect(0, 0, bar.x +30 , 30);
            //
            flag = ((target.x < sprite.x + sprite.width) && (sprite.x < target.x + target.width)); 
            tf.text = String(flag);
        }
        
    }
    
}