/**
 * Copyright gam-22 ( http://wonderfl.net/user/gam-22 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jPyx
 */

// forked from nutsu's FractalSample
// see http://gihyo.jp/design/feature/01/frocessing/0002
package  
{
    import frocessing.display.F5MovieClip2D;
    
    [SWF(width=465,height=465,backgroundColor=0xFFFFFF)]
    public class FractalSample extends F5MovieClip2D
    {
        private var shape_size:Number;
        private var r1:Number;
        private var r2:Number;
        private var r3:Number;
        private var r4:Number;
        
        public function FractalSample() 
        {
            //線と塗りの色指定
            stroke( 0, 0.5 );
            noFill();
            
            //キャンバスを移動
            translate( 465/2, 465/2 + 30 );
            // 上下反転
            rotate( Math.PI );
            
            //シェイプの大きさ
            shape_size = 200;
            
            //三角形の座標パラメータ
            r1 = shape_size;
            r2 = r1/2;
            r3 = r2*Math.sqrt(3);
            
            r4 = Math.PI/3;
            
            //フラクタルの描画(再帰回数を指定)
            draw_shapes( 6 );
        }
        
        private function draw_shapes( n:int ):void
        {
            if ( n-- <= 0 ) return;
            
            var rn:int = 6;
            
            //キャンバスのサイズを半分に
            scale( 0.5 );
            
            line(0,0,0,shape_size);
            
            for ( var i:int = 0; i < rn; i++ ) {
                
                pushMatrix();
                
                
                
                scale( 0.8 );
                //移動
                translate( 0, shape_size/rn );
                rotate();
                
                //正三角形の描画
                line(0,0,0,shape_size);
                
                //再帰的に描画
                draw_shapes( n );
                popMatrix();
                
                //360/rn 度回転
                //rotate( 2*Math.PI/rn );
            }
        }
    }
}