/**
 * Copyright KinkumaDesign ( http://wonderfl.net/user/KinkumaDesign )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jPrF
 */

package 
{
	import caurina.transitions.Tweener;
	import flash.display.Graphics;
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.events.MouseEvent;
	import flash.filters.BlurFilter;
	import flash.text.TextField;
	import flash.text.TextFieldAutoSize;
	import flash.text.TextFormat;
	
	/**
	 * マウスカーソルをゆっくり近づけると、したの方でカーソルがぷるぷるします
	 * When you move the mouse cursor to the below Sprite slowly, the cursor will shake.
	 * 
	 * @author KinkumaDesign
	 */
	[SWF(width="450", height="450", frameRate="30", backgroundColor="0xffffff")]
	public class Main extends Sprite 
	{
		public var normal:Sprite;
		public var filterSp:Sprite;
		
		public var label1:TextField;
		public var label2:TextField;
		
		public function Main():void 
		{
			if (stage) init();
			else addEventListener(Event.ADDED_TO_STAGE, init);
		}
		
		private function init(e:Event = null):void 
		{
			removeEventListener(Event.ADDED_TO_STAGE, init);
			
			//こっちは普通の
			normal = getRectSprite();
			addChild(normal);
			normal.x = 220;
			normal.y = 120;
			
			//こっちはブラーフィルターかけてるんだけど、値が0だからわかんない
			filterSp = getRectSprite();
			addChild(filterSp);
			filterSp.x = 220;
			filterSp.y = 320;
			filterSp.filters = [new BlurFilter(0, 0, 1)];
			
			var tf:TextFormat = new TextFormat();
			tf.font = "_typewriter";
			label1 = new TextField();
			label1.text = "Normal ノーマル";
			label1.autoSize = TextFieldAutoSize.CENTER;
			addChild(label1);
			label1.x = 180;
			label1.y = 50;
			label1.setTextFormat(tf);
			
			label2 = new TextField();
			label2.text = "Filtered フィルターつき で ぷるぷるふるえる";
			label2.autoSize = TextFieldAutoSize.CENTER;
			addChild(label2);
			label2.x = 120;
			label2.y = 250;
			label2.setTextFormat(tf);
		}
		
		private function getRectSprite():Sprite
		{
			var sp:Sprite = new Sprite();
			var g:Graphics = sp.graphics;
			g.beginFill(0x11ACFF, 1);
			g.drawCircle(0, 0, 50);
			g.endFill();
			sp.addEventListener(MouseEvent.ROLL_OVER, spRollOverHD);
			sp.addEventListener(MouseEvent.ROLL_OUT, spRollOutHD);
			sp.buttonMode = true;
			sp.scaleX = sp.scaleY = 0.5;
			return sp;
		}
		
		private function spRollOutHD(e:MouseEvent):void 
		{
			var sp:Sprite = e.currentTarget as Sprite;
			Tweener.addTween(sp, { scaleX:0.5, scaleY:0.5, time:0.6, transition:"easeinoutquad" } );
		}
		
		private function spRollOverHD(e:MouseEvent):void 
		{
			var sp:Sprite = e.currentTarget as Sprite;
			Tweener.addTween(sp, { scaleX:1, scaleY:1, time:0.6, transition:"easeinoutquad" } );
		}
	}
	
}