/**
 * Copyright windy ( http://wonderfl.net/user/windy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jPaj
 */

// forked from windy's forked from: forked from: [Prototyping] Microphone Study #02 録音と再生
// forked from tepe's forked from: [Prototyping] Microphone Study #02 録音と再生
// forked from alumican_net's [Prototyping] Microphone Study #02 録音と再生
package
{
    import flash.display.Bitmap;
    import flash.display.BitmapData;
    import flash.display.BlendMode;
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    import flash.events.*;

    import flash.geom.Point;
    import flash.geom.Rectangle;
    import flash.media.Microphone;
    import flash.media.Sound;
    import flash.media.SoundChannel;
    import flash.utils.ByteArray;
    import flash.utils.getTimer;
    


    public class Main extends Sprite
    {

        private const ZEROS:Point = new Point();
        private var txt1:TextField = new TextField();
        private var txt2:TextField = new TextField();
        
        private var _mic:Microphone;//マイクキャプチャ

        private var _records:Vector.<Number>;

        private var _sound:Sound;
        private var _soundChannel:SoundChannel;//サウンド制御
        private var _position:int;
        private var pos3:int=0;

        private var _canvas:BitmapData;
        private var _slit:BitmapData;
        
        private var hz:int = 4410;
        private var text1:TextField = new TextField();
        public var wheel:Wheel = new Wheel();
        
        private var color:uint = 0x00ff0000;
        
        private var cnt:int =0;
        private var cnt2:int =0;
        
        public function Main():void
        {

            
            //マイクキャプチャの設定
            _mic = Microphone.getMicrophone();//マイクデバイス使用許可の要求
            //_mic.setLoopBack(true);//スピーカーへフィードする
            _mic.rate = 44;//キャプチャレート指定
            _mic.setSilenceLevel(0);//検出レベル
            _mic.setUseEchoSuppression(true);//エコー抑制機能
            txt1.text= _mic.name;
            txt1.type ="input";
            txt2.width =400;
            text1.y = 40;
            text1.width = 400;
            text1.text=String(hz);
            
            //txt1.type ="dynamic";
            
            _sound = new Sound();
            
            _canvas = new BitmapData(stage.stageWidth, stage.stageHeight, false, 0xffffff);
            _slit = new BitmapData(1, stage.stageHeight, false, 0xffffff);
            addChild( new Bitmap(_canvas) );
            addChild(txt1);
            txt2.y=20;
            addChild(txt2);
            addChild(text1);
            
            _records = new Vector.<Number>(14410);
            
            
            _startRecord();// 01
            _startSound();
                        
            //ダイヤル設定
            wheel.x = 220;    wheel.y = 320;//　表示位置
            wheel.scaleX = 2;
            addChild(wheel);
            wheel.max = 100;
            wheel.addEventListener(CompoEvent.CHANGE, change);
            
            
        }
        

        


import flash.display.Sprite;
import flash.display.Shape;
import flash.filters.DropShadowFilter;
import flash.geom.ColorTransform;
import flash.events.Event;
import flash.events.MouseEvent;


//ホイールインターフェース
class Wheel extends Sprite {
    private var base:Sprite;
    private var thumb:Sprite;
    private var point:Shape;
    private var hit:Shape;
    private var zeroPos:Shape;
    //カラー設定
    public var bColor:uint = 0xFFFFFF;//ホイールの色
    private var cColor:uint = 0x999999;//つまみの色
    private var sColor:uint = 0x000000;//影の色
    private var pColor:uint = 0x666666;//つまみの色（ロールオーバー時）
    private var offColor:uint = 0xCCCCCC;//つまみの色（操作不可）
    private var cColorTrans:ColorTransform;
    private var pColorTrans:ColorTransform;
    private var offColorTrans:ColorTransform;
    //プロパティ
    
    private var zero:Number = 0;
    private var angle:Number = 0;//つまみの角度
    private var shade:DropShadowFilter;//影
    private var initValue:Number = 0;//値
    public var value:Number = 0;
    public var turn:int = 0;//回転数
    private var _enabled:Boolean = true;
    public var size:uint = 30;//描画サイズ
    public var max:Number = 100;//最大値
    public var dec:Boolean = false;//小数点以下を求める場合はtrue

    //コンストラクタ
    public function Wheel() {
        shade = new DropShadowFilter(1, 90, sColor, 0.4, 4, 4, 2, 3, false, false);
        cColorTrans = new ColorTransform();
        cColorTrans.color = cColor;
        pColorTrans = new ColorTransform();
        pColorTrans.color = pColor;
        offColorTrans = new ColorTransform();
        offColorTrans.color = offColor;
        
        base = new Sprite();
        thumb = new Sprite();
        point = new Shape();
        hit = new Shape();
        
        addChild(base);
        base.addChild(thumb);
        thumb.addChild(point);//ホイールのつまみ部分
        thumb.addChild(hit);
        addChild(thumb);

        draw();
    }

    //描画
    private function draw():void {
        //位置関係
        base.x = thumb.x = 0;
        base.y = thumb.y = 0;
        createDonut(base, size+size/3, size-size/3);//ホイール描画
        base.filters = [shade];
        point.x = size;
        createCircle(point, size/6, bColor, 1);//つまみの描画
        hit.x = size;
        createCircle(hit, size/3, bColor, 0);//操作エリア
        reset();
        _up();
        enabled = true;
        thumb.mouseChildren = false;
    }
    
    //イベント：ロールオーバー
    private function rollOver(evt:MouseEvent):void {
        _over();
    }
    
    //イベント：ロールアウト
    private function rollOut(evt:MouseEvent):void {
        _up();
    }
    
    //イベント：マウスダウン
    private function press(evt:MouseEvent):void {
        _down();
        thumb.addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
        stage.addEventListener(MouseEvent.MOUSE_UP, releaseOutside, false, 0, true);
        stage.addEventListener(MouseEvent.MOUSE_MOVE, change, false, 0, true);
        stage.addEventListener(Event.MOUSE_LEAVE, leave, false, 0, true);
    }
    
    //イベント：マウスアップ
    private function release(evt:MouseEvent):void {
        _up();
        checkValue();
        var e:CompoEvent = new CompoEvent(CompoEvent.SELECT, value);
        dispatchEvent(e);
        thumb.removeEventListener(MouseEvent.MOUSE_UP, release);
        stage.removeEventListener(MouseEvent.MOUSE_UP, releaseOutside);
        stage.removeEventListener(MouseEvent.MOUSE_MOVE, change);
        stage.removeEventListener(Event.MOUSE_LEAVE, leave);
    }
    
    private function releaseOutside(evt:MouseEvent):void {
        _up();
        checkValue();
        var e:CompoEvent = new CompoEvent(CompoEvent.SELECT, value);
        dispatchEvent(e);
        thumb.removeEventListener(MouseEvent.MOUSE_UP, release);
        stage.removeEventListener(MouseEvent.MOUSE_UP, releaseOutside);
        stage.removeEventListener(MouseEvent.MOUSE_MOVE, change);
        stage.removeEventListener(Event.MOUSE_LEAVE, leave);
    }
    
    //操作完了
    private function leave(evt:Event):void {
        _up();
        checkValue();
        var e:CompoEvent = new CompoEvent(CompoEvent.SELECT, value);
        dispatchEvent(e);
        thumb.removeEventListener(MouseEvent.MOUSE_UP, release);
        stage.removeEventListener(MouseEvent.MOUSE_UP, releaseOutside);
        stage.removeEventListener(MouseEvent.MOUSE_MOVE, change);
        stage.removeEventListener(Event.MOUSE_LEAVE, leave);
    }
    
    
    private function _up():void {
        point.transform.colorTransform = cColorTrans;
    }
    private function _over():void {
        point.transform.colorTransform = pColorTrans;
    }
    private function _down():void {
        point.transform.colorTransform = pColorTrans;
    }
    private function _off():void {
        point.transform.colorTransform = offColorTrans;
    }
    
    //ダイヤル操作
    private function change(evt:MouseEvent):void {
        _down();
        thumb.rotation = Math.atan2(base.mouseY, base.mouseX)/Math.PI*180;
        evt.updateAfterEvent();
        checkValue();
        var e:CompoEvent = new CompoEvent(CompoEvent.CHANGE, value);
        dispatchEvent(e);
    }
    
    //ダイヤルの角度から値を決定
    private function checkValue():void {
        var prev:Number = value;
        value = (((thumb.rotation+450-angle)%360)/360)*max;
        //回転数
        if(prev < max/2){
            if(max - max/3 < value)turn--;
        }
        else{
            if(value < max/3)turn++;
        }

 
        if(dec == false)value = Math.round(value);//小数点以下の扱い
    }
    
    
    //操作受付の状態　true:可　false:不可
    public function get enabled():Boolean {
        return _enabled;
    }
    
    public function set enabled(param:Boolean):void {
        _enabled = param;
        if (!_enabled) _off();
        thumb.buttonMode = _enabled;
        thumb.mouseEnabled = _enabled;
        thumb.useHandCursor = _enabled;
        
        if (_enabled) {//操作可
            thumb.addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            thumb.addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            thumb.addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
        } else {//操作不可
            thumb.removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            thumb.removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            thumb.removeEventListener(MouseEvent.MOUSE_DOWN, press);
        }
    }
    
    //状態更新
    public function reset():void {
        value = initValue;
        thumb.rotation = value - 90 + zero;
    }
    
    //描画１
    private function createCircle(target:Shape, r:uint, color:uint, alpha:Number):void {
        target.graphics.beginFill(color, alpha);
        target.graphics.drawCircle(0, 0, r);
        target.graphics.endFill();
    }
    
    //描画２
    private function createDonut(target:Sprite, outer:uint, inner:uint):void {
        target.graphics.beginFill(bColor);
        target.graphics.drawCircle(0, 0, outer);//外縁
        target.graphics.drawCircle(0, 0, inner);//内縁
        target.graphics.endFill();
    }

}



//////////////////////////////////////////////////
//     Sliderクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.filters.DropShadowFilter;
import flash.filters.GlowFilter;
import flash.geom.Rectangle;
import flash.geom.Matrix;
import flash.display.GradientType;
import flash.display.SpreadMethod;
import flash.display.InterpolationMethod;
import flash.events.Event;
import flash.events.MouseEvent;

class Slider extends Sprite {
    private var hole:Shape;
    private var line:Sprite;
    private var thumb:Sprite;
    private var light:Shape;
    private var shade:Shape;
    private var base:Shape;
    
    private var _width:uint = 100;
    private static var bHeight:uint = 30;
    private static var bColor:uint = 0xFFFFFF;
    private static var bgColor:uint = 0x0099FF;
    private static var sColor:uint = 0x000000;
    private static var offColor:uint = 0x999999;
    
    private var min:Number = 0;//スライダー左端の値
    private var max:Number = 100;//スライダー右端の値
    private var initValue:Number = 0;//リセット時の初期値
    
    private var blueGlow:GlowFilter;
    private var shadeDrop:DropShadowFilter;
    private var _value:Number;
    private var _enabled:Boolean = true;

    public function Slider() {
    }

    public function init(option:Object):void {
        if (option.width != undefined) _width = option.width;
        if (option.min != undefined) min = option.min;
        if (option.max != undefined) max = option.max;
        if (option.init != undefined) initValue = option.init;
        draw();
    }
    
    //描画
    private function draw():void {
        shadeDrop = new DropShadowFilter(1, 90, sColor, 0.5, 4, 4, 2, 3, false, false);
        blueGlow = new GlowFilter(bgColor, 0.6, 5, 5, 2, 3, false, true);
        hole = new Shape();
        line = new Sprite();
        thumb = new Sprite();
        shade = new Shape();
        light = new Shape();
        base = new Shape();
        addChild(hole);
        addChild(line);
        addChild(thumb);
        thumb.addChild(shade);
        thumb.addChild(light);
        thumb.addChild(base);
        hole.y = bHeight;
        createGradientHole(hole, _width, 3);
        reset();
        thumb.y = bHeight;
        createThumb(shade, 8, 20, 12, sColor);
        shade.filters = [shadeDrop];
        createThumb(light, 8, 20, 12, bgColor);
        light.filters = [blueGlow];
        createThumb(base, 8, 20, 12, bColor);
        _up();
        enabled = true;
        thumb.mouseChildren = false;
    }
   
   //イベント設定 

    private function rollOver(evt:MouseEvent):void {
        _over();
    }
    private function rollOut(evt:MouseEvent):void {
        _up();
    }
    private function press(evt:MouseEvent):void {
        _down();
        var rect:Rectangle = new Rectangle(0, bHeight, _width, 0);
        thumb.startDrag(false, rect);
        thumb.addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
        stage.addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
        stage.addEventListener(Event.MOUSE_LEAVE, leave, false, 0, true);
        thumb.addEventListener(Event.ENTER_FRAME, change, false, 0, true);
    }
    private function release(evt:MouseEvent):void {
        _up();
        thumb.stopDrag();
        checkValue();
        var e:CompoEvent = new CompoEvent(CompoEvent.SELECT, _value);
        dispatchEvent(e);
        thumb.removeEventListener(MouseEvent.MOUSE_UP, release);
        stage.removeEventListener(MouseEvent.MOUSE_UP, release);
        stage.removeEventListener(Event.MOUSE_LEAVE, leave);
        thumb.removeEventListener(Event.ENTER_FRAME, change);
    }
    private function leave(evt:Event):void {
        _up();
        thumb.stopDrag();
        checkValue();
        var e:CompoEvent = new CompoEvent(CompoEvent.SELECT, _value);
        dispatchEvent(e);
        thumb.removeEventListener(MouseEvent.MOUSE_UP, release);
        stage.removeEventListener(MouseEvent.MOUSE_UP, release);
        stage.removeEventListener(Event.MOUSE_LEAVE, leave);
        thumb.removeEventListener(Event.ENTER_FRAME, change);
    }
    
    
    private function _up():void {
        light.visible = false;
    }
    private function _over():void {
        light.visible = true;
    }
    private function _down():void {
        light.visible = true;
    }
    private function _off():void {
        light.visible = false;
    }
    
    //
    private function change(evt:Event):void {
        _down();
        checkValue();
        var e:CompoEvent = new CompoEvent(CompoEvent.CHANGE, _value);
        dispatchEvent(e);
    }
    
    //スライダーの状態から値を取得
    private function checkValue():void {
        _value = min + Math.round(thumb.x/_width*(max-min));
    }
    
    //スライダーの状態更新
    public function update(v:Number):void {
        if(v<min)_value = min;
        else if(max<v)_value = max;
        else _value = v;
        thumb.x = _width*(_value-min)/(max-min);//スライダー位置の更新
    }
    
    //操作受付の設定 true:操作可能　false：操作不可
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        if (!_enabled) _off();
        thumb.buttonMode = _enabled;
        thumb.mouseEnabled = _enabled;
        thumb.useHandCursor = _enabled;
        if (_enabled) {
            thumb.addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            thumb.addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            thumb.addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            thumb.addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
        } else {
            thumb.removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            thumb.removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            thumb.removeEventListener(MouseEvent.MOUSE_DOWN, press);
            thumb.removeEventListener(MouseEvent.MOUSE_UP, release);
        }
    }
    
    
    public function reset():void {
        thumb.x = _width*(initValue-min)/(max-min);
        _value = initValue;
    }
    
    private function createThumb(target:Shape, w:uint, h:uint, y:uint, color:uint, alpha:Number = 1):void {
        target.graphics.beginFill(color, alpha);
        target.graphics.drawRoundRect(-w*0.5, -y, w, h, w);
        target.graphics.endFill();
    }
    
    private function createGradientHole(target:Shape, w:uint, c:Number):void {
        var colors:Array = [0x000000, 0x000000];
        var alphas:Array = [0.4, 0];
        var ratios:Array = [0, 255];
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox(w+c*2, c*2, 0.5*Math.PI, -c, -c);
        target.graphics.beginGradientFill(GradientType.LINEAR, colors, alphas, ratios, matrix, SpreadMethod.PAD, InterpolationMethod.RGB, 0);
        target.graphics.drawRoundRect(-c, -c, w+c*2, c*2, c*2);
        target.graphics.endFill();
    }

}


//////////////////////////////////////////////////
// IconBtnクラス
//////////////////////////////////////////////////

import flash.display.Sprite;
import flash.display.Shape;
import flash.filters.GlowFilter;
import flash.events.MouseEvent;
import flash.geom.ColorTransform;

class IconBtn extends Sprite {
    public var id:uint;
    private var shade:Shape;
    private var bottom:Shape;
    private var light:Shape;
    private var base:Shape;
    private var icon:Shape;
    private var _width:uint = 60;
    private static var _height:uint = 20;
    private static var corner:uint = 5;
    private var type:uint = 1;
    private static var bColor:uint = 0xFFFFFF;
    private static var sColor:uint = 0x000000;
    private static var upColor:uint = 0x666666;
    private static var overColor:uint = 0x333333;
    private static var offColor:uint = 0x999999;
    private static var upColorTrans:ColorTransform;
    private static var overColorTrans:ColorTransform;
    private static var offColorTrans:ColorTransform;
    private var cColor:uint = 0x0099FF;
    private var colorGlow:GlowFilter;
    private var shadeGlow:GlowFilter;
    private var _clicked:Boolean = false;
    private var _enabled:Boolean = true;

    public function IconBtn(Icon:Class) {
        icon = new Icon();
    }

    public function init(option:Object):void {
        if (option.id != undefined) id = option.id;
        if (option.width != undefined) _width = option.width;
        if (option.type != undefined) type = option.type;
        if (option.color != undefined) cColor = option.color;
        draw();
    }
    private function draw():void {
        switch (type) {
        case 1 :
            bColor = 0xFFFFFF;
            sColor = 0x000000;
            upColor = 0x666666;
            overColor = 0x333333;
            offColor = 0x999999;
            break;
        case 2 :
            bColor = 0x000000;
            sColor = 0xFFFFFF;
            upColor = 0x666666;
            overColor = 0x999999;
            offColor = 0x333333;
            break;
        }
        colorGlow = new GlowFilter(cColor, 0.6, 5, 5, 2, 3, false, true);
        shadeGlow = new GlowFilter(sColor, 0.3, 4, 4, 2, 3, false, true);
        upColorTrans = new ColorTransform();
        upColorTrans.color = upColor;
        overColorTrans = new ColorTransform();
        overColorTrans.color = overColor;
        offColorTrans = new ColorTransform();
        offColorTrans.color = offColor;
        shade = new Shape();
        bottom = new Shape();
        light = new Shape();
        base = new Shape();
        addChild(shade);
        addChild(bottom);
        addChild(light);
        addChild(base);
        addChild(icon);
        createBase(shade, _width, _height, corner, sColor);
        shade.filters = [shadeGlow];
        createBase(bottom, _width, _height, corner, sColor, 0.3);
        createBase(light, _width, _height, corner, cColor);
        light.filters = [colorGlow];
        createBase(base, _width, _height, corner, bColor);
        icon.y = -1;
        enabled = true;
        mouseChildren = false;
    }
    private function rollOver(evt:MouseEvent):void {
        _over();
    }
    private function rollOut(evt:MouseEvent):void {
        _up();
    }
    private function press(evt:MouseEvent):void {
        _down();
    }
    private function release(evt:MouseEvent):void {
        _up();
    }
    private function click(evt:MouseEvent):void {
    }
    private function _up():void {
        icon.y = -1;
        icon.transform.colorTransform = upColorTrans;
        base.y = -1;
        light.visible = false;
        light.y = -1;
    }
    private function _over():void {
        icon.y = -1;
        icon.transform.colorTransform = overColorTrans;
        base.y = -1;
        light.visible = true;
        light.y = -1;
    }
    private function _down():void {
        icon.y = 0;
        icon.transform.colorTransform = overColorTrans;
        base.y = 0;
        light.visible = true;
        light.y = 0;
    }
    private function _off():void {
        icon.y = 0;
        icon.transform.colorTransform = offColorTrans;
        base.y = 0;
        light.visible = false;
        light.y = 0;
    }
    public function get clicked():Boolean {
        return _clicked;
    }
    public function set clicked(param:Boolean):void {
        _clicked = param;
        if (_clicked) {
            _down();
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            removeEventListener(MouseEvent.MOUSE_DOWN, press);
            removeEventListener(MouseEvent.MOUSE_UP, release);
        } else {
            _up();
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
        }
    }
    public function get enabled():Boolean {
        return _enabled;
    }
    public function set enabled(param:Boolean):void {
        _enabled = param;
        buttonMode = _enabled;
        mouseEnabled = _enabled;
        useHandCursor = _enabled;
        if (_enabled) {
            _up();
            addEventListener(MouseEvent.MOUSE_OVER, rollOver, false, 0, true);
            addEventListener(MouseEvent.MOUSE_OUT, rollOut, false, 0, true);
            addEventListener(MouseEvent.MOUSE_DOWN, press, false, 0, true);
            addEventListener(MouseEvent.MOUSE_UP, release, false, 0, true);
            addEventListener(MouseEvent.CLICK, click, false, 0, true);
        } else {
            _off();
            removeEventListener(MouseEvent.MOUSE_OVER, rollOver);
            removeEventListener(MouseEvent.MOUSE_OUT, rollOut);
            removeEventListener(MouseEvent.MOUSE_DOWN, press);
            removeEventListener(MouseEvent.MOUSE_UP, release);
            removeEventListener(MouseEvent.CLICK, click);
        }
    }
    private function createBase(target:Shape, w:uint, h:uint, c:uint, color:uint, alpha:Number = 1):void {
        target.graphics.beginFill(color, alpha);
        target.graphics.drawRoundRect(-w*0.5, -h*0.5, w, h, c*2);
        target.graphics.endFill();
    }

}


//////////////////////////////////////////////////
// Iconクラス
//////////////////////////////////////////////////

import flash.display.Shape;
//import sketchbook.graphics.GraphicsHelper;

class PlayIcon extends Shape {
    private static var bColor:uint = 0x000000;

    public function PlayIcon() {
        draw();
    }

    private function draw():void {
        graphics.beginFill(bColor);
        graphics.moveTo(-4, -6);
        graphics.lineTo(-4, 6);
        graphics.lineTo(8, 0);
        graphics.endFill();
    }

}

class PauseIcon extends Shape {
    private static var bColor:uint = 0x000000;

    public function PauseIcon() {
        draw();
    }

    private function draw():void {
        graphics.beginFill(bColor);
        graphics.drawRect(-5, -5, 4, 10);
        graphics.endFill();
        graphics.beginFill(bColor);
        graphics.drawRect(3, -5, 4, 10);
        graphics.endFill();
    }

}

class StopIcon extends Shape {
    private static var bColor:uint = 0x000000;

    public function StopIcon() {
        draw();
    }

    private function draw():void {
        graphics.beginFill(bColor);
        graphics.drawRect(-5, -5, 10, 10);
        graphics.endFill();
    }

}


//////////////////////////////////////////////////
// CompoEventクラス
//////////////////////////////////////////////////

import flash.events.Event;

class CompoEvent extends Event {
    public static const SELECT:String = "select";
    public static const CHANGE:String = "change";
    public var value:*;

    public function CompoEvent(type:String, value:*) {
        super(type);
        this.value = value;
    }

    public override function clone():Event {
        return new CompoEvent(type, value);
    }

}