/**
 * Copyright actionscriptbible ( http://wonderfl.net/user/actionscriptbible )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jNtX
 */

package {
  import flash.display.*;
  import flash.events.*;
  import flash.geom.*;
  [SWF(backgroundColor="#000000",frameRate="60")]
  public class ch36ex9 extends Sprite {
    protected const MAXSPEED:Number = 8;
    protected var ball:Shape;
    protected var holder:Sprite;
    protected var bmp:BitmapData;
    protected var velocity:Point
    public function ch36ex9() {
      bmp = new BitmapData(stage.stageWidth, stage.stageHeight);
      var bitmap:Bitmap = new Bitmap(bmp);
      addChild(bitmap);
      holder = new Sprite();
      addChild(holder);
      ball = new Shape();
      ball.graphics.lineStyle(0, 0xff0000);
      ball.graphics.beginFill(0xffffff, 0.1);
      ball.graphics.drawCircle(0, 0, 30);
      holder.addChild(ball);
      stage.addEventListener(Event.ENTER_FRAME, onEnterFrame);
      stage.addEventListener(MouseEvent.CLICK, onMouseClick);
      velocity = new Point(1, 1);
    }
    protected function onEnterFrame(event:Event):void {
      ball.x += velocity.x;
      ball.y += velocity.y;
      ball.rotation += velocity.length / 5;
      if (ball.x >= bmp.width || ball.x <= 0) velocity.x *= -1;
      if (ball.y >= bmp.height || ball.y <= 0) velocity.y *= -1;
      bmp.colorTransform(bmp.rect, new ColorTransform(1, 1, 1, 0.9));
      bmp.draw(holder);
    }
    protected function onMouseClick(event:MouseEvent):void {
      ball.x = stage.mouseX;
      ball.y = stage.mouseY;
      velocity.x = Math.random() * MAXSPEED * 2 - MAXSPEED;
      velocity.y = Math.random() * MAXSPEED * 2 - MAXSPEED;
    }
  }
}