/**
 * Copyright bradsedito ( http://wonderfl.net/user/bradsedito )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jNUl
 */

// forked from Matt_Wakeling's Mathematic Daisy Patterns
package 
{
    // Import External Classes
    import flash.display.SpreadMethod;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
        
    
    // Reconfigure Stage Properties
    [SWF(width='465',height='465',backgroundColor='#000000',frameRate='30')]
    
    /**
    * Name           : Main 
    * Coded By       : Matt Wakeling
    * Date           : 29th April 2012
    * Description    : Main Class for the Application.
    *                  Mathematic Daisy Patterns.
    *
    * @author Matt Wakeling
    */
    public class Main extends Sprite 
    {
        // Main Constructor
        public function Main()
        {
            // Constructor Code
            super();
            InitialiseMain();
        }

        // InitialiseMain Method
        private function InitialiseMain():void
        {
            if (stage)
                this.InitialiseStage();
            else addEventListener(Event.ADDED_TO_STAGE, this.InitialiseStage);
        }
        
        // InitialiseStage Method
        private function InitialiseStage(e:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, this.InitialiseStage);
                                                                   
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align     = StageAlign.TOP_LEFT;

            // Black Screen for Wonderfl Capture
            this.graphics.beginFill(0x000000,1);
            this.graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
            this.graphics.endFill();
        
            var $360Split:uint = 1;
            
            for (var $column:Number = 0; $column < 2; $column++)
            {
                for (var $row:Number = 0; $row < 2; $row++)
                {
                    displayDaisy(($row * 200) + 150, ($column * 200) + 150, 0.55, $360Split);
                    $360Split++;
                }
            }
        }
        
        // displayShape Method
        private function displayDaisy($displayatx:int, $displayaty:int, $condense:Number, $split:Number) :void
        {
            var sprSprite:Sprite = new Sprite;
            
            sprSprite.graphics.clear();
            sprSprite.graphics.lineStyle(1, 0xFFFFFF);
                
            var $r:Number     = 0;
            var $rr:Number     = 0;
            
            var $a:Number     = 0;
            var $aa:Number     = 0;
            
            var $d:Number = 0;
            
            var $x:Number = 0;
            var $y:Number = 0;
                        
            $d = 360 / $split;
            for (var $s:Number = 1; $s <= 100; $s++)
            {
                $r = $condense * Math.sqrt($a)
            
                for (var $t:Number = 0; $t <= 6; $t++)
                {
                    $aa = 360 * $t / 6 + $a
                    $rr = 5;
                    $x = $rr * Math.cos($aa) + $r * Math.cos($a);
                    $y = $rr * Math.sin($aa) + $r * Math.sin($a);
                    if ($t == 0) sprSprite.graphics.moveTo($x, $y);
                    sprSprite.graphics.lineTo($x,$y);
                }
                
                $a = $a + $d;
                
            }
            
            sprSprite.x = $displayatx;
            sprSprite.y = $displayaty;
            
            addChild(sprSprite);
        }
    }
}