/**
 * Copyright telcanty ( http://wonderfl.net/user/telcanty )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jMn3
 */

package {
    import flash.display.Sprite;
    import flash.display.BlendMode;
    
    import gs.TweenLite;
    import gs.easing.*
    
    public class FlashTest extends Sprite {
        
        private var _balls:Array;
        private var _count:int = 50;
        
        public function FlashTest() 
        {
            _drawBackground();
            _createBalls();
            _updateBalls();
        }
        
        private function _updateBall(ball:Sprite):void
        {
            trace("Start Animation");
            var scale:Number = 8 * Math.random();
            new TweenLite(ball, 10,
                                                {
                                                    x:  stage.stageWidth * Math.random(),
                                                    y: stage.stageHeight * Math.random(),
                                                    tint: 0xFFFFFF * Math.random(),
                                                    scaleX: scale,
                                                    scaleY: scale,
                                                    ease:Elastic.easeOut,
                                                    onComplete: _updateBall,
                                                    onCompleteParams: [ball]
                                                }
                          );
        }
        
        private function _updateBalls():void
        {
            for(var i:int = 0; i < _balls.length; i++)
            {
                trace("Update Ball Number: "+i);           
                var ball:Sprite = _balls[ i ];
                _updateBall(ball);
            }
        }
        
        private function _createBalls():void
        {
                _balls = new Array();
                for(var i:int  = 0;  i  < _count ; i++)
                {
                    trace("Create Ball Number: "  + i );
                    
                    var ball:Sprite = _createBall();
                          ball.x   = stage.stageWidth * Math.random();
                          ball.y  = stage.stageHeight * Math.random();
                          addChild(ball);
                          
                     _balls[ i ] = ball;
                }  
        }
        
        private function _createBall():Sprite
        {
              var ball:Sprite = new Sprite();
                    ball.graphics.beginFill(0xFFFFFF * Math.random());
                    ball.graphics.drawCircle(0,0,10);
                    ball.graphics.endFill();
                    ball.blendMode = BlendMode.ADD;
              return ball;
        }
        
        private function _drawBackground():void
        {
            graphics.beginFill(0x222222);
            graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
            graphics.endFill();
            
        }
        
    }
    
}
