/**
 * Copyright ushisantoasobu ( http://wonderfl.net/user/ushisantoasobu )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jMCJ
 */

package {
    import flash.text.TextField;

    import flash.display.*;
    import flash.events.*;
    
    import flash.system.Security;
    
    import org.papervision3d.cameras.*;
    import org.papervision3d.materials.*;
    import org.papervision3d.materials.BitmapFileMaterial;
    import org.papervision3d.materials.utils.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.render.*;
    import org.papervision3d.scenes.*;
    import org.papervision3d.view.*;
    import org.papervision3d.view.layer.ViewportLayer;
    
    import caurina.transitions.Tweener; 
    
    public class FlashTest extends Sprite {
        
        public var scene:Scene3D;
        public var camera:Camera3D;
        public var viewport:Viewport3D;
        public var renderer:BasicRenderEngine;
        public var plane:Plane;
        public var cameraDistanse:int = 1500;
        public var tex:TextField;
        public var angle:Number;
        public var arr:Array;
        public var panelsuu:int = 6;
        public var panelangle:int;
        public var addedpanelangle:int;
        public var panelradius:int = 200;;
        
        public function FlashTest() {
            
            Security.allowDomain("assets.wonderfl.net");
            Security.loadPolicyFile("http://assets.wonderfl.net/crossdomain.xml");
            
            arr = new Array();
            
            scene = new Scene3D();
            
            camera = new Camera3D();
            camera.x = camera.y = 0;
            camera.z = -1500;
            camera.focus = 50;
            camera.zoom = 20;
            
            viewport = new Viewport3D(this.stage.stageWidth, this.stage.stageHeight);
            
            this.addChild(viewport);
            
            renderer = new BasicRenderEngine();
            
            for(var i:int = 0; i < panelsuu; i++){
                var url_base:String = "http://assets.wonderfl.net/images/related_images/";
                var url_unique:String;
                switch(i){
                    case 0:
                    url_unique = "7/73/7362/7362fe45e00bbd8b73cc67acad5ab2af451b52e2";
                    break;
                    case 1:
                    url_unique = "8/8a/8a66/8a66a59b06d675822b75b08ec8a8fcfa392b236a";
                    break; 
                    case 2:
                    url_unique = "e/e6/e6e6/e6e6a6096b7ccd7e4dfedb5e508fa10dd0b9a9fa";;
                    break; 
                    case 3:
                    url_unique = "d/d5/d5d7/d5d7101a782a3f9b48a1fa722f5b5547edfb7a79";;
                    break; 
                    case 4:
                    url_unique = "4/41/41ad/41ad48895eacaf9249f91dd8ed7f2bd0f76a1562";;
                    break; 
                    case 5:
                    url_unique = "d/d3/d308/d308eea2f48ce3922aace07079a2b1c443897a3b";
                    break;              
                }
                
                //var material:BitmapFileMaterial = new BitmapFileMaterial("http://moguramogura.site90.com/sbcr/img4.jpg");
                var material:BitmapFileMaterial = new BitmapFileMaterial(url_base + url_unique, true);
                //var material:ColorMaterial = new ColorMaterial(Math.random() * 0xFFFFFF, 0.8);
                material.interactive = true;                
                material.doubleSided = true;
                plane = new Plane(material, 100, 100, 10, 10);
                arr.push(plane);
                scene.addChild(arr[i]);
                
                var viewportlayer:ViewportLayer = viewport.getChildLayer(arr[i]);
                viewportlayer.buttonMode = true;
                
                viewportlayer.addEventListener(MouseEvent.MOUSE_OVER, panelOverHandler);
                viewportlayer.addEventListener(MouseEvent.ROLL_OUT, panelOutHandler);
            }
            
            stage.addEventListener(Event.ENTER_FRAME, drawPapervision3d);
            stage.addEventListener(MouseEvent.CLICK, cameraMove);
            
            /*
            tex = new TextField();
            tex.text = "start";
            this.addChild(tex);
            
            tex.text = String(int(camera.z)+", "+int(camera.y)+", "+int(camera.rotationX));          
            */
            
            addedpanelangle = 2;
        }
        
        public function panelOverHandler(e:MouseEvent):void{
            addedpanelangle = 1;
        }
        
        public function panelOutHandler(e:MouseEvent):void{
            addedpanelangle = 2;
        }
        
        public function drawPapervision3d(e:Event):void{
            
            panelangle += addedpanelangle;
            if(panelangle == 360){
                panelangle = 0;
            }
                        
            for(var i:int = 0; i < panelsuu; i++){
                arr[i].x = panelradius * Math.cos(panelangle * Math.PI / 180 + i / panelsuu * Math.PI * 2);
                arr[i].z = panelradius * Math.sin(panelangle * Math.PI / 180 + i / panelsuu * Math.PI * 2);
                arr[i].rotationY = panelangle * (-1) + 90 - i / panelsuu * 360;
            }
            
            renderer.renderScene(scene, camera, viewport);
            
        }
        
        public function cameraMove(e:MouseEvent):void{
            
            angle = 90 / 465 * mouseY * (-1) + 45;
            
            Tweener.addTween(camera, {z:(-1)*cameraDistanse * Math.cos(angle / 360 * Math.PI * 2), y: (-1)*cameraDistanse * Math.sin(angle / 360 * Math.PI * 2), rotationX: angle * (-1), time:1.2, transition:"easeOutExpo"});
            //Tweener.addTween(camera, {z:(-1) * cameraDistanse * Math.cos(angle / 360 * Math.PI * 2), rotationX: angle * 180 / Math.PI, time:4.0});
            //tex.text = String(int(camera.z)+", "+int(camera.y)+", "+int(camera.rotationX));
        }
        
    }
}