/**
 * Copyright Nicolas ( http://wonderfl.net/user/Nicolas )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jM0Q
 */

package {
    import flash.events.MouseEvent;
    import flash.display.Sprite;
    import com.bit101.components.*;
    public class FlashTest extends Sprite {
        public var ns1:NumericStepper;  
        public var ns2:NumericStepper;
        public var calcBtn:PushButton;
        public var text:Text;
        
        public function FlashTest() {
            ns1 = new NumericStepper(this, 20, 20);
            ns1.scaleX = ns1.scaleY = 1.6;
            ns2 = new NumericStepper(this, 20, 80);
            ns2.scaleX = ns2.scaleY = 1.6;
            
            ns1.value = 56;
            ns2.value = 40;
            
            calcBtn = new PushButton(this, 160, 50, "calcGCD", onClick);
            calcBtn.scaleX = calcBtn.scaleY = 1.2;
            
            text = new Text(this, 300, 40);
            text.scaleX = text.scaleY = 2;
            text.width = 80;
            text.height = 20;
            text.editable = false;
        }
        
        public function onClick(e:MouseEvent):void {
            text.text = String(calcGCD(ns1.value, ns2.value));
        }

        
        public function calcGCD(n1:int, n2:int):int {
            if(isNaN(n1) || isNaN(n2)) {
                return NaN;
            }

            var larger:int = n1 > n2 ? n1: n2;
            var smaller:int = n1 < n2 ? n1: n2;
            var remainder:int = larger % smaller;
            while(remainder > 0) {
                larger = smaller;
                smaller = remainder;
                remainder = larger % smaller;
            }
            
            return smaller;
        }

    }
}