/**
 * Copyright kawakita ( http://wonderfl.net/user/kawakita )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jLVp
 */

package {

    import flash.display.*;
    import flash.events.*;
    import flash.filters.*;
    import flash.geom.*;
    import flash.ui.*;
    import funnel.*;
    import funnel.gui.*;
    import funnel.ui.*;
    
    /**
     * 秋刀魚を焼き焼きするFlashです。
     * ステージをクリック連打で焼けます。
     * 実際のごはんとFlashでは団扇で扇ぐと焼けるというフィジカルコンピューティングをしました。
     */
    public class FlashTest extends Sprite {
        
        private var _p:Point;
        private var _rect:Rectangle;
        
        private var _bmp:Bitmap;
        private var _blank:BitmapData;
        private var _noise:BitmapData;
        
        private var _item:Item;
        private var _meter:Meter;
        
        private var _fio:Fio;
        private var _mage:Pin;
        
        public function FlashTest() {
            
            var sW:Number = stage.stageWidth;
            var sH:Number = stage.stageHeight;
            
            _p = new Point();
            _rect = new Rectangle( 0, 0, sW, sH );
            
            // ここに画像の配列を書き換えれば別のものが焼けます.
            _item = new Item(
               "http://flair4.jp/works/gohantoflash09/sanma_chan1.png",
               "http://flair4.jp/works/gohantoflash09/sanma_chan2.png",
               "http://flair4.jp/works/gohantoflash09/sanma_chan3.png",
               "http://flair4.jp/works/gohantoflash09/sanma_chan4.png",
               "http://flair4.jp/works/gohantoflash09/sanma_chan5.png"
            );
            
            _blank = new BitmapData( sW, sH, true, 0 );
            _noise = _blank.clone();
            _noise.perlinNoise( 100, 100, 2, 0, true, true );
            _bmp = addChild( new Bitmap( _blank.clone() ) ) as Bitmap;
            
            _meter = new Meter();
            _meter.x = ( sW - _meter.width ) / 2;
            _meter.y = sH - _meter.height - 10;
            addChild( _meter );
            
           // Create Funnel.
            /*
            _fio = new Fio([1]);
            _mage = _fio.ioModule(1).analogPin(3);
	    _mage.addFilter( new SetPoint([0.5, 0.05]) );
	    _mage.addEventListener( RISING_EDGE, _yaki );
	    _mage.addEventListener( FALLING_EDGE, _yaki );
            */

            addEventListener( Event.ENTER_FRAME, _onEnterFrame );
            stage.addEventListener( MouseEvent.CLICK, _yaki );
            
        }
        
        private function _yaki(e:Event ):void {
            _meter.value += 0.1;
        }
        
        private function _onEnterFrame(e:Event):void {
            _item.value += _meter.value * 0.005;
            _bmp.bitmapData = _blank.clone();
            _bmp.bitmapData.draw( _item );
            _bmp.bitmapData.applyFilter(
                _bmp.bitmapData, _rect, _p,
                new DisplacementMapFilter(
                    _noise, _p, BitmapDataChannel.RED, BitmapDataChannel.GREEN,
                    ( 3 + 12 * _meter.value ) * Math.random(), ( 3 + 12 * _meter.value ) * Math.random(), "ignore"
                )
            );
        }
        
    }
}


import flash.display.DisplayObject;
import flash.display.GradientType;
import flash.display.Bitmap;
import flash.display.BitmapData;
import flash.display.Loader;
import flash.display.Sprite;
import flash.events.Event;
import flash.geom.Matrix;
import flash.net.URLLoader;
import flash.net.URLRequest;
import flash.system.*;

internal class Item extends Sprite{
    
    private var _currentImage:DisplayObject;
    private var _urlList:Array;
    private var _loading:Boolean;
    private var _imageContainer:Sprite;
    private var _value:Number;
    private var vx:Number = 0;
    private var vy:Number = 0;
    
    public function Item( ...urls ):void {
        _urlList= urls;
        _loading = true;
        _value = 0;
        _imageContainer = addChild(new Sprite() ) as Sprite;
        var loader:Loader = new Loader();
        loader.contentLoaderInfo.addEventListener(Event.COMPLETE, function(e:Event):void{
            _loading = false;
            addChildAt( loader, 0 );
            next();
        });
        loader.load(
            new URLRequest(
                "http://flair4.jp/works/gohantoflash09/ami.png"
            ),
            new LoaderContext( true, new ApplicationDomain() )
        );
    }
    
    private function _onEnterFrame(e:Event):void {
        vx += ( 1 - _imageContainer.scaleX ) * 0.6;
        vy += ( 1 - _imageContainer.scaleY ) * 0.6;
        _imageContainer.scaleX += (vx *= 0.72);
        _imageContainer.scaleY += (vy *= 0.72);
    }
    
    public function get value():Number { return _value; }
    public function set value( val:Number ):void {
        if ( _loading ) return;
        _value = val;
        if ( 1.5 <= _value ) {
            next();
        }
    }
    
    public function next():Boolean {
        _value = 0;
        if ( _urlList.length == 0 ) {
            return false;
        }else {
            _loading = true;
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, function(e:Event):void{
                _loading = false;
                if( _currentImage != null ){
                    _imageContainer.removeChild(_currentImage);
                }
                _currentImage = loader;
                _imageContainer.addChild( _currentImage );
                loader.x = - loader.width >>1;
                loader.y = - loader.height >>1;
                _imageContainer.x = 465 >> 1;
                _imageContainer.y = 465 >> 1;
                _imageContainer.scaleX = 0.9;
                _imageContainer.scaleY = 0.9;
                _imageContainer.rotation = - 10 + Math.random() * 20;
                addEventListener(Event.ENTER_FRAME, _onEnterFrame );
            });
            loader.load( new URLRequest( _urlList.shift() ) );
            return true;
        }
    }
    
}


internal class Meter extends Sprite {
    
    private var _mask:Sprite;
    
    public function Meter():void {
        
        // -----------------------------------
        
        var _bg:Sprite = new Sprite();
        _bg.graphics.beginFill(0);
        _bg.graphics.drawRect( 0, 0, 445, 5 );
        _bg.graphics.endFill();
        addChild( _bg );
        
        // -----------------------------------
        
        var matrix:Matrix = new Matrix();
        matrix.createGradientBox( 445, 5 );
        var _color:Sprite = new Sprite();
        _color.graphics.beginGradientFill(
            GradientType.LINEAR, [ 0xffff00, 0xff0000 ] ,[ 0xff, 0xff ] ,[ 0, 0xff ]
            ,matrix
        )
        _color.graphics.drawRect( 0, 0, 445, 5 );
        _color.graphics.endFill();
        addChild( _color );
        
        // -----------------------------------
        
        _mask = new Sprite();
        _mask.graphics.beginFill( 0 );
        _mask.graphics.drawRect( 0, 0, 445, 5 );
        _mask.graphics.endFill();
        _mask.scaleX = 0;
        addChild( _mask );
        
        _color.mask = _mask;
        
        addEventListener(Event.ENTER_FRAME, function(e:Event):void{
            _mask.scaleX *= 0.98;
        });
        
    }
    
    public function get value():Number { return _mask.scaleX; }
    public function set value( val:Number ):void {
        _mask.scaleX = Math.max( 0, Math.min( 1, val ) );
    }
    
}