/**
 * Copyright Scmiz ( http://wonderfl.net/user/Scmiz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jLHl
 */

package {
	import flash.display.Graphics;
    import flash.display.Sprite;
	import flash.events.Event;
	import flash.geom.Point;
    public class FlashTest extends Sprite {
		private var _rad1:Number = 0;
		private var _rad2:Number = 0;
		
        public function FlashTest() {
			this.addEventListener(Event.ENTER_FRAME, proc);
        }
		
		private function proc(e:Event):void {
			_rad1 += Math.PI * 0.008;
			_rad2 += Math.PI * 2 * 0.005;
			if (_rad1 >= Math.PI) _rad1 -= Math.PI;
			if (_rad2 >= Math.PI * 2) _rad2 -= Math.PI * 2;
			
			var length:Number = 100;
			var offsX1:Number = Math.cos(_rad2) * length;
			var offsY1:Number = Math.sin(_rad2) * length;
			var offsX2:Number = Math.cos(_rad2 + (Math.PI * 2 / 3)) * length;
			var offsY2:Number = Math.sin(_rad2 + (Math.PI * 2 / 3)) * length;
			var offsX3:Number = Math.cos(_rad2 + (Math.PI * 2 * 2 / 3)) * length;
			var offsY3:Number = Math.sin(_rad2 + (Math.PI * 2 * 2 / 3)) * length;
			
			var g:Graphics = this.graphics;
			g.clear();
			g.beginFill(0x000000);
			g.drawRect(0, 0, 465, 465);
			g.endFill();
			draw(232.5 + offsX1, 232.5 + offsY1, Math.sin(_rad1) + 0.5, 0xff8080);
			draw(232.5 + offsX2, 232.5 + offsY2, Math.sin(_rad1) + 0.5, 0x80ff80);
			draw(232.5 + offsX3, 232.5 + offsY3, Math.sin(_rad1) + 0.5, 0x8040ff);
		}
		
		private function draw(centerX:Number, centerY:Number, scale:Number, color:uint):void {
			var g:Graphics = this.graphics;
			for (var index:uint = 0; index < 20; ++index) {
				var size:Number = 5 + ((index + 2) * (index + 2) * scale);
				var sizeHalf:Number = size * 0.5;
				var ellipse:Number = size * 0.25;
				g.lineStyle(4 * scale, color, 0.2 + (0.05 * index));
				g.drawCircle(centerX, centerY, sizeHalf);
			}
		}
    }
}