/**
 * Copyright yashikei ( http://wonderfl.net/user/yashikei )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jJP1
 */

package{
    import flash.display.Stage;
    import flash.display.AVM1Movie;
    import flash.utils.Timer;
    import flash.events.*;
    import org.papervision3d.materials.special.*;
    import org.papervision3d.typography.fonts.*;
    import org.papervision3d.typography.*;
    import org.papervision3d.view.*;
    import org.papervision3d.events.InteractiveScene3DEvent;
    
    import caurina.transitions.Tweener;

    [SWF(backgroundColor = 0x000000, width = 640, height = 400, frameRate = 30)]
    
    public class text3D extends BasicView{
        private var str1:String = "This is a song for you and me";
        private var str2:String = "and the holy night and the blue sky.";
        private var strList:Array = new Array(str1, str2);
        //private var str:String = "yashikei";
        private var words:Array = new Array();
        private var textFieldWidth:Number = 1500;
            
        public function text3D(){
            camera.x = 800 * Math.cos(45 * Math.PI / 180);            
            unitText(str1);
            
            startRendering();
        }
        
        private function unitText(str:String):void{
            for(var i:int=0 ; i<str.length ; i++){
                var material:Letter3DMaterial = new Letter3DMaterial(0xffffff);
                material.doubleSided = true;
                
                var c:String = str.slice(i, i+1);
                var font:HelveticaMedium = new HelveticaMedium();
                var word:Text3D = new Text3D(c, font, material);
                word.x = -textFieldWidth/2 + ((i+1) * textFieldWidth/str.length);
                word.z = 500;
                
                camera.z = -1500;
                words.push(word);
                scene.addChild(word);
            }
            var myTimer:Timer = new Timer(50, 40);
            myTimer.addEventListener(TimerEvent.TIMER, TimerHandler);
            myTimer.addEventListener(TimerEvent.TIMER_COMPLETE, TimerCompleteHandler);
            myTimer.start();

        }
                
        private var timerCount:int = 0;
        private var strCount:int = 0;
        private function TimerHandler(e:TimerEvent):void{
            for(var i:int=0 ; i<40 ; i++){
                Tweener.addTween( words[timerCount], { time:3 , z:-300 , transition:'easeOutQuint' });
            }
            if(timerCount>=40)timerCount = 0;
            else timerCount++;
            //strCount++;
        }
        
        private var TimerCompCount:int = 1;
        private function TimerCompleteHandler(e:TimerEvent):void{
            for(var i:int=0 ; i<40 ; i++){
                Tweener.addTween( words[i], { time:2 , y:500 , transition:'easeOutQuint' });
            }
            if(TimerCompCount < strList.length)
                unitText(strList[TimerCompCount]);
            TimerCompCount++;
        }
    }
}