/**
 * Copyright umhr ( http://wonderfl.net/user/umhr )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jJOt
 */

/*
 * Picasa Web Albumsの画像を表示してみる。
 * 
 * 
 * 参考
 * http://iffalse.com/log/2009/07/picasa_web_albums_da.html
 * */

package 
{
	import flash.display.Sprite;
	import flash.events.Event;
	import flash.display.Loader;
	import flash.display.LoaderInfo;
	import flash.net.URLRequest;
	import flash.net.URLLoader;
	import flash.filters.DropShadowFilter;
	import flash.system.Security;
	/**
	 * ...
	 * @author umhr
	 */
	public class Main extends Sprite 
	{
		private var load_array:Array = [];
		private var _count:int;
		public function Main():void 
		{
			Security.loadPolicyFile("http://photos.googleapis.com/data/crossdomain.xml");
			var myLoader:URLLoader = new URLLoader();
			myLoader.addEventListener (Event.COMPLETE,COMPLETE);
			myLoader.load(new URLRequest("http://photos.googleapis.com/data/feed/base/user/umhrhrs/albumid/5227607742764155601?alt=rss&kind=photo&hl=ja"));
		}
           
		private function COMPLETE(e:Event):void 
		{
            var ns:Namespace = new Namespace("http://search.yahoo.com/mrss/");
			var feed:XML = new XML(e.currentTarget.data);
			//trace(feed)
			
			var _length:int = feed.channel.item.ns::group.ns::content.length();
			for (var i:int = 0; i < _length; i++) {
				var imgURL:String = feed.channel.item.ns::group.ns::content[i].@url;
				//trace(imgURL)
				load_array[i] = new Loader();
				load_array[i].name = String(i);
				var info : LoaderInfo = load_array[i].contentLoaderInfo;
				info.addEventListener (Event.COMPLETE,imgCOMPLETE);
				load_array[i].load(new URLRequest(imgURL));
			}
		}
		private function imgCOMPLETE(e:Event):void {
			_count++;
			if(_count == load_array.length){
				for (var i:int = 0; i < _count; i++) {
					load_array[i].x = 25 + (i % 2) * 215;
					load_array[i].y = 25 + Math.floor(i / 2) * 215;
					load_array[i].filters = [new DropShadowFilter()];
					addChildAt(load_array[i], 0);
				}
			}
		}
	}
}