/**
 * Copyright simon4761 ( http://wonderfl.net/user/simon4761 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jJHc
 */

// forked from dizgid's forked from: forked from: Papervision3d入門 3.2.9
// forked from PaperStudent's forked from: Papervision3d入門 3.2.9
// forked from yawakisin's Papervision3d入門 3.2.9
// forked from yawakisin's Papervision3d入門 3.2.8
/*
    Flash3D コンテンツ制作のためのPapervision3Dのサンプルテスト    
    
    code 3.2.9

    ? cubeのテクスチャはみだれる？
*/

package 
{
    import flash.display.*;
    import flash.events.Event;
    import flash.net.URLRequest;
    import flash.system.LoaderContext;
    import org.papervision3d.lights.*;
    import org.papervision3d.materials.BitmapMaterial;
    import org.papervision3d.materials.shadematerials.*;
    import org.papervision3d.materials.shaders.*;
    import org.papervision3d.materials.utils.*;
    import org.papervision3d.objects.primitives.*;
    import org.papervision3d.view.*;
    
    [SWF(width = "800", height = "600", frameRate = "12", backgroundColor = "#404040")]
    public class ShaderSample extends BasicView {
        
        // コンストラクタ
        public function ShaderSample() 
        {
            // Loaderクラスを使用して画像ファイルを読み込む(外部のパスを指定)
            var loader:Loader = new Loader();
            loader.contentLoaderInfo.addEventListener(Event.COMPLETE, compHandler);
            loader.load(
                new URLRequest("http://assets.wonderfl.net/images/related_images/2/29/2957/295773efe549b4206f0ab5e4e776915fb02f95ff"),
                new LoaderContext(true));        
        }
        
        private function compHandler(e:Event):void 
        {
            // 画像ファイルを読み込んだ場合、loaderのcontentプロパティがビットマップ画像になっている
            var bmpData:BitmapData = Bitmap(Loader(e.target.loader).content).bitmapData;

            // ライトを作成
            var light:PointLight3D = new PointLight3D(true, false);
            scene.addChild(light);

            // ベースとなるマテリアルを作成
            var baseMaterial:BitmapMaterial = new BitmapMaterial(bmpData);
            
            // シェーダーを作成
            const lightColor:uint = 0xFFFFFF;
            const ambientColor:uint = 0x111111;
            const specularLevel:uint = 50;
            const color1:int = 0xFFFFFF;
            const color2:int = 0x111111;
            const steps:int = 4;
            
            // シェーダーを作成
            var shader:FlatShader = new FlatShader(light, lightColor, ambientColor, specularLevel);
//            var shader:GouraudShader= new GouraudShader(light, lightColor, ambientColor, specularLevel);
//            var shader:PhongShader = new PhongShader(light, lightColor, ambientColor, specularLevel);
//            var shader:CellShader = new CellShader(light, color1, color2, steps);

            // シェーダーとビットマップマテリアルでシェーデッドマテリアルを作成
            var material:ShadedMaterial = new ShadedMaterial(baseMaterial, shader, 0);

            // 球体と直方体を作成
            var sphere:Sphere = new Sphere(material, 250, 20, 20);
            var cube:Cube = new Cube(new MaterialsList( { all:material } ),
                                        300, 300, 300, 5, 5, 5);
            sphere.x = -250;
            cube.x = 250;
            cube.rotationX = -45;
            
            // 3D空間に球体を追加
            scene.addChild(sphere);
            scene.addChild(cube);
            
            // レンダリング
            startRendering();

            // フレームイベント
            addEventListener(Event.ENTER_FRAME, function():void
                {
                    // ライトの位置をマウスの座標と連動
                    light.x = 2 * (mouseX - stage.stageWidth / 2);
                    light.y = -2 * (mouseY - stage.stageHeight / 2);
                    light.z = -400;
                });
        }
    }
}
