/**
 * Copyright uwi ( http://wonderfl.net/user/uwi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jIms
 */

// forked from uwi's flash on 2009-7-23
package {
    import flash.display.Sprite;
    import flash.text.TextField;
    import flash.utils.getTimer;
    // @see http://projecteuler.net/index.php?section=problems&id=133
    public class Euler133 extends Sprite {
        private var _tf : TextField;
  
        public function Euler133() {
            _tf = new TextField();
            _tf.width = 465;
            _tf.height = 465;
            addChild(_tf);
            
            var s : int = getTimer();
            t(solve(100000));
            var g : int = getTimer();
            t((g - s) + " ms");
        }

        private function solve(N : int) : Number
        {
            var primes : Array = doEratosthenes(N);
            var sum : Number = 0;
            for each(var p : int in primes){
                if(p == 2 || p == 5)continue;
                for(var v : int = 1, c : int = 1;v != 0;v = (int(v * 10) + 1) % p, c++){
                    if(c > p / 2){c = p - 1; break; }
                }
                while((c & 1) == 0)c >>>= 1;
                while(c % 5 == 0)c /= 5;
                if(c != 1){
                    sum += p;
                }
            }
            return sum + 2 + 5;
        }

        private static function doEratosthenes(n : int) : Array
        {
            var ar : Vector.<uint> = new Vector.<uint>(n / 2 - 1);
            var i : int;
            for(i = 0;i < ar.length;i++)ar[i] = 1;
            
            var sq : int = (Math.sqrt(n) - 3) >> 1;
            for(var p : int = 0;p <= sq;p++){
                if(ar[p] == 1){
                    var m : int = (p << 1) + 3;
                    var m2 : int = m << 1;
                    for(var mm : int = m * m;mm <= n;mm += m2){
                        ar[(mm - 3) >> 1] = 0;
                    }
                }
            }
            var ret : Array = [2];
            for(i = 0;i < ar.length;i++){
                if(ar[i] == 1)ret.push((i << 1) + 3);
            }
            return ret;
        }
        
        private function t(o : *) : void
	{
            _tf.appendText("" + o + "\n");
	}
    }
}