/**
 * Copyright tenasaku ( http://wonderfl.net/user/tenasaku )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jHpX
 */

/* シンプルなラインアートだが、
 * キャンバスへの直線の描画処理を繰り返すよりも、
 * スプライトとして描画した直線を変形していくほうが、
 * はるかに高速に処理され、CPUへの負担も少ない
 * (しかし色の変化がつけられないのはどうしようもない)
 * それにしても, Graphics.lineTo() は
 * 内部でよほど重い処理をしているらしい...
 */
 
package {
   // TODO:
   // 単に位置と縮尺を変えるだけでなく, 
   // 新しい theLine[head] はレイヤー的に最前面に置きなおすべき
   // いまは緑色の線が常に最前面にあってちょっとオカシイ
   // あとで修正します (2010-03-20)
    import flash.display.Sprite;
    import flash.events.Event;
[SWF(width="465",height="465",frameRate="24")]
    public class FlashTest extends Sprite {
        private const nLines:int = 30;
        private var c:uint; // color
        private var head:int; // どの theLine[Number] が先頭か
        private var theLine:Array; // 直線の群れをスプライトの配列として保持
        private var d_fromX:Number;
        private var d_fromY:Number;
        private var d_toX:Number;
        private var d_toY:Number;
        public function FlashTest() {
            var i:int;
            this.graphics.beginFill(0x000000);
            this.graphics.drawRect(0,0,stage.stageWidth,stage.stageHeight);
            this.graphics.endFill();
            d_fromX = -Math.random()*12;
            d_fromY = -Math.random()*12;
            d_toX = -Math.random()*12;
            d_toY = -Math.random()*12;
            theLine = new Array(nLines);
            for ( i = 0 ; i < nLines ; ++i ) {
            		// 虹色はこうすればできる
            	    var t:Number = i/nLines*Math.PI*2;
            		var r:int = Math.floor(128+Math.sin(t)*127.99999);
            		var g:int = Math.floor(128+Math.sin(t+Math.PI/3*2)*127.99999);
            		var b:int = Math.floor(128+Math.sin(t+Math.PI/3*4)*127.99999);
                theLine[i] = new MyLine();
                theLine[i].cc = (r<<16)|(g<<8)|b;
                theLine[i].regenerate();
                this.addChild(theLine[i]);
            }
            stage.addEventListener(Event.ENTER_FRAME, atEveryFrame);
	    }
		
	    private function atEveryFrame(e:Event):void {
            var next_fromX:Number;
            var next_fromY:Number;
            var next_toX:Number;
            var next_toY:Number;
            var tail:int = (head+1)%nLines; // 列の末尾が次に先頭に回る
            next_fromX = theLine[head].fromX + d_fromX;
            if ( ( next_fromX < 0 )||( next_fromX >= 465 ) ) {
                d_fromX = -d_fromX;
                next_fromX += d_fromX*2; // 倍返し
            }
            next_fromY = theLine[head].fromY + d_fromY;
            if ( ( next_fromY < 0 )||( next_fromY >= 465 ) ) {
                d_fromY = -d_fromY;
                next_fromY += d_fromY*2; // 倍返し
            }
            next_toX = theLine[head].toX + d_toX;
            if ( ( next_toX < 0 )||( next_toX >= 465 ) ) {
                d_toX = -d_toX;
                next_toX += d_toX*2; // 倍返し
            }
            next_toY = theLine[head].toY + d_toY;
            if ( ( next_toY < 0 )||( next_toY >= 465 ) ) {
                d_toY = -d_toY;
                next_toY += d_toY*2; // 倍返し
            }
            theLine[tail].unDraw();
            theLine[tail].fromX = next_fromX;
            theLine[tail].fromY = next_fromY;
            theLine[tail].toX = next_toX;
            theLine[tail].toY = next_toY;
            theLine[tail].draw();
            head = tail;
        }           
    }
}

// 個々の直線はこのクラスのインスタンス
// 実は、直線というより画面サイズいっぱいの対角線を描いたスプライト
class MyLine extends flash.display.Sprite {
    private const _thickness:Number = 6;
    public var fromX:Number;
    public var fromY:Number;
    public var toX:Number;
    public var toY:Number;
    public var cc:uint;
// 線が短い(縮尺が小さい)と、太さもつられて細くなります
    public function draw():void {
        this.x = fromX;
        this.y = fromY;
        this.scaleX = (toX-fromX)/465;
        this.scaleY = (toY-fromY)/465;
        this.visible = true;
    }
    public function unDraw():void {
        this.visible = false;
    }
    public function regenerate():void {
		this.graphics.clear();
		this.graphics.lineStyle(_thickness,cc);
//		this.graphics.drawRect(0,0,465,465);    		
//		this.graphics.drawEllipse(0,0,465,465);    		
		this.graphics.moveTo(0,0);
		this.graphics.lineTo(465,465);
    }
	// コンストラクタでは初期値を設定
    	public function MyLine():void {
		fromX = 0;
        fromY = 0;
        toX = 465;
        toY = 465;
        cc = 0x000000;
		this.regenerate();
    }
}
