/**
 * Copyright Floz ( http://wonderfl.net/user/Floz )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jHp0
 */

// forked from nitoyon's キラキラPixel3D！ in Native Flash 10 3D API
// forked from sake's キラキラPixel3D！
/*
     お手軽キラキラPixel3D！ in Native Flash 10 3D API
     キラキラ方法はこちらを使わせてもらいましたー：http://wonderfl.net/code/71344f9a655053d9f793a32c68f00921c67f1977    
     
*/
package
{
    import flash.display.*;
    import flash.events.Event;
    import flash.geom.Matrix;
    import flash.geom.Utils3D;
    import flash.geom.Vector3D;
    import flash.geom.Matrix3D;

    [SWF(width="465", height="465", backgroundColor="0x000000", frameRate="40")]
    public class Papervision3D_sample95 extends Sprite
    {
        // パーティクルのサイズ
        private const N:int = 5000;
        // 画面サイズ
        private const SIZE:int = 465;

        // パーティクルを描画する BitmapData
        private var canvas:BitmapData;
        // canvas の Bitmap
        private var bmpCanvas:Bitmap;
        // 光らせるための BitmapData
        private var canvasGlow:BitmapData;

        // 1/4 で描画するための Matrix
        private var mtx:Matrix = new Matrix(0.25, 0, 0, 0.25);

        // パーティクルの座標データ
        private var points:Vector.<Number>;
        private var _vectors:Vector.<Vector3D>;
        // 変換用座標 (projectVectors に渡すが利用はしない) 
        private var uvts:Vector.<Number> = new Vector.<Number>();;
        // パーティクルの回転行列
        private var mtx3d:Matrix3D = new Matrix3D();;

        // コンストラクタ
        public function Papervision3D_sample95()
        {
            // パーティクルの座標を初期化する
            var v:Vector3D = new Vector3D();
            _vectors = new Vector.<Vector3D>;
            points = new Vector.<Number>(); 
            for(var i:int=0; i < N; i++)
            {
                var theta1:Number=360 * Math.random() * Math.PI / 180; 
                var theta2:Number=(180 * Math.random() - 90) * Math.PI / 180; 
                var radius:Number=230; 
                
                v = new Vector3D();
                v.x = radius * Math.cos(theta1) * Math.sin(theta2);
                v.y = radius * Math.cos(theta1) * Math.cos( theta2 );
                v.z = radius * Math.sin(theta1 );
                _vectors[ i ] = v;
                points.push(radius * Math.cos(theta1) * Math.sin(theta2));
                points.push(radius * Math.cos(theta1) * Math.cos( theta2 )); 
                points.push(radius * Math.sin(theta1 )); 
            }

            // 描画用のキャンバスを初期化する
            canvas = new BitmapData(SIZE, SIZE, false, 0x000000);
            bmpCanvas = addChild(new Bitmap(canvas)) as Bitmap;

            // 光らせるための BitmapData を初期化する
            canvasGlow = new BitmapData(SIZE / 4, SIZE / 4, false, 0x000000);
            var bmp:Bitmap = new Bitmap(canvasGlow, PixelSnapping.NEVER, true);
//            bmp.scaleX = bmp.scaleY = 4;
            bmp.smoothing = true;
            bmp.blendMode = BlendMode.ADD;
            addChild(bmp);
            
            // イベント開始
            addEventListener("enterFrame", onFrame);
        }

        private function onFrame(e:Event):void
        {
            // 座標を回転させる 
            var result:Vector.<Number> = new Vector.<Number>();
            Utils3D.projectVectors(mtx3d, points, result, uvts); 

            // キャンバスに点を描画していく
            canvas.lock();
            canvas.fillRect(canvas.rect, 0x000000);
            for(var i:int = 0; i < N; i++)
            {
                canvas.setPixel( Utils3D.projectVector( mtx3d, _vectors[ i ] ).x + SIZE / 2, Utils3D.projectVector( mtx3d, _vectors[ i ] ).y + SIZE /2, 0xffffff );
                //canvas.setPixel(result[i * 2] + SIZE / 2, result[i * 2 + 1] + SIZE / 2, 0xffffff);
            }
            canvas.unlock();

            // 光らせるためのキャンバスにコピーする
            canvasGlow.fillRect(canvasGlow.rect, 0x000000);
//          canvasGlow.draw(bmpCanvas, mtx);

            // 変換行列の角度を増やす 
            mtx3d.appendRotation(.5, Vector3D.Y_AXIS);
            mtx3d.appendRotation(.5, Vector3D.X_AXIS);
        }
    }
}