/**
 * Copyright jozefchutka ( http://wonderfl.net/user/jozefchutka )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jHfi
 */

package
{
    import flash.display.Sprite;
    import flash.display.StageAlign;
    import flash.display.StageScaleMode;
    import flash.geom.Point;
    import flash.system.Security;

    [SWF(width="465", height="465", frameRate="30", backgroundColor="#ffffff")]
    public class WonderflApp extends Sprite
    {
        
        public function WonderflApp():void
        {
            Security.loadPolicyFile("http://blog.yoz.sk/crossdomain.xml");
            
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            
            var position:Point;
            var cube:Cube;
            for(var i:uint = 0; i < 16; i++)
            {
                position = suggestPosition(i);
                
                cube = new Cube();
                cube.x = position.x;
                cube.y = position.y;
                addChild(cube);
            }
        }
        
        private function suggestPosition(i:uint):Point
        {
            var col:uint = i%4;
            var row:uint = uint(i/4);
            return new Point(col * (Cube.WIDTH - 1), row * (Cube.HEIGHT - 1));
        }
    }
}

import gs.TweenMax;

import flash.display.Bitmap;
import flash.display.Loader;
import flash.display.Shape;
import flash.display.Sprite;
import flash.events.Event;
import flash.events.MouseEvent;
import flash.geom.PerspectiveProjection;
import flash.geom.Point;
import flash.system.LoaderContext;
import flash.net.URLRequest;

class Cube extends Sprite
{
    public static const WIDTH:uint = 116;
    public static const HEIGHT:uint = 116;
    
    public static const W2:Number = WIDTH / 2;
    public static const H2:Number = HEIGHT / 2;
    
    private var scene:Sprite = new Sprite();
    private var page1:CubePage;
    private var page2:CubePage;
    private var page3:CubePage;
    private var page4:CubePage;
    
    private var targetRotation:int = 0;
    private var cubeMask:Shape = new Shape();
    
    public function Cube()
    {
        super();
        
        page1 = new CubePage("http://blog.yoz.sk/examples/cubes/page1.jpg");
        page1.x = 0;
        page1.z = -W2;
        page1.rotationY = 0;
        scene.addChild(page1);
        
        page2 = new CubePage("http://blog.yoz.sk/examples/cubes/page2.jpg");
        page2.x = W2;
        page2.z = 0;
        page2.rotationY = -90;
        scene.addChild(page2);
        
        page3 = new CubePage("http://blog.yoz.sk/examples/cubes/page3.jpg");
        page3.x = 0;
        page3.z = W2;
        page3.rotationY = -180;
        scene.addChild(page3);
        
        page4 = new CubePage("http://blog.yoz.sk/examples/cubes/page4.jpg");
        page4.x = -W2;
        page4.z = 0;
        page4.rotationY = 90;
        scene.addChild(page4);
        
        scene.x = W2;
        scene.y = H2;
        scene.z = W2;
        addChild(scene);
        
        cubeMask.graphics.beginFill(0x00ff00);
        cubeMask.graphics.drawRect(0, 0, WIDTH, HEIGHT);
        cubeMask.graphics.endFill();
        addChild(cubeMask);
        mask = cubeMask;
        
        zSort();
        
        addEventListener(Event.ADDED_TO_STAGE, onStage);
        addEventListener(MouseEvent.CLICK, onClick);
    }
    
    private function onStage(evnet:Event):void
    {
        removeEventListener(Event.ADDED_TO_STAGE, onStage);
        var projection:PerspectiveProjection = new PerspectiveProjection();
        projection.projectionCenter = new Point(W2, H2);
        scene.transform.perspectiveProjection = projection;
    }
    
    private function onClick(event:MouseEvent):void
    {
        targetRotation -= event.localX > 0 ? -90 : 90;
        TweenMax.to(scene, 1, {rotationY:targetRotation, onUpdate:zSort});
    }
    
    private function zSort():void
    {
        var rot:Number = scene.rotationY % 360;
        if(rot < 0)
            rot += 360;
        
        if(rot < 45 || rot >= 315)
        {
            scene.addChildAt(page3, 0);
            scene.addChildAt(page4, 1);
            scene.addChildAt(page2, 2);
            scene.addChildAt(page1, 3);
        }
        else if(rot < 135)
        {
            scene.addChildAt(page4, 0);
            scene.addChildAt(page1, 1);
            scene.addChildAt(page3, 2);
            scene.addChildAt(page2, 3);
        }
        else if(rot < 225)
        {
            scene.addChildAt(page1, 0);
            scene.addChildAt(page2, 1);
            scene.addChildAt(page4, 2);
            scene.addChildAt(page3, 3);
        }
        else if(rot < 315)
        {
            scene.addChildAt(page2, 0);
            scene.addChildAt(page3, 1);
            scene.addChildAt(page1, 2);
            scene.addChildAt(page4, 3);
        }
    }
}

class CubePage extends Loader
{
    public function CubePage(url:String)
    {
        super();
        
        var request:URLRequest = new URLRequest(url);
        load(request, new LoaderContext(true));
        
        contentLoaderInfo.addEventListener(Event.COMPLETE, onComplete);
    }
    
    private function onComplete(event: Event):void
    {
        Bitmap(content).smoothing = true;
        content.x = -Cube.W2;
        content.y = -Cube.H2;
    }
}