/**
 * Copyright mitien ( http://wonderfl.net/user/mitien )
 * GNU General Public License, v3 ( http://www.gnu.org/licenses/quick-guide-gplv3.html )
 * Downloaded from: http://wonderfl.net/c/jHex
 */

// forked from widged's Invader Generator, v0.2
// forked from widged's Invader Generator
/**
 * 
 * Adapted from Levitated.net
 * http://www.levitated.net/daily/levInvaderFractal.html
 * 
 * Changes: 
 * - Ported to Actionscript 3.
 * - Click on sprite to draw a new pattern
 * 
 * Orignal notice:
 * This program is free software; you can redistribute it and/or modify it under the 
 * terms of the GNU General Public License as published by the Free Software Foundation.
 * 
 * This program is provided "as is".  No claims are made either explicit or implied
 * reguarding worth, compatibility, or computational merit.  Please feel free to distribute, 
 * modify, tweak, integrate, indoctorinate, or obliterate within good taste and with reasonable 
 * respect to the original author.  
 * 
 * Copyright (C) 2003 Jared Tarbell
 * Albuquerque, New Mexico
 */

package
{
    import flash.display.Sprite;
    
    public class InvaderTest extends Sprite
    {
        public function InvaderTest()
        {
            super();
            var gridDim:int = 7;
            var rowId:int  = 0;
            for (var i:int = 0; i < (gridDim * gridDim); i++)
            {
                if(i % gridDim == 0) { rowId++;} 
                var settings:InvaderSettings = new InvaderSettings({pixelH: 5, pixelV: 5, pixelSize: 5, gap: 5});
                var invader:Invader = new Invader(settings);
                var w:int = (settings.pixelH * settings.pixelSize) + settings.gap;
                var h:int = (settings.pixelV * settings.pixelSize) + settings.gap;
                invader.x = (i % gridDim)* w;
                invader.y = rowId * h;
                addChild(invader);
                
            }
       }
    }
}
 
 import flash.display.Sprite;
 import flash.events.MouseEvent;
   
    class Invader extends Sprite
    {
        private var _sprite:Sprite;
        private var _settings:InvaderSettings;
        
        public function Invader(options:InvaderSettings = null)
        {
            super();
            addEventListener(MouseEvent.CLICK, onClick);
            _settings = options;
            generatePattern(_settings);
            build(_settings);
        }
        
        
        private function onClick(event:MouseEvent):void
        {
            this.removeChild(_sprite)
            generatePattern(_settings);
            build(_settings);
        }

        private function build(options:InvaderSettings):void 
        {
            var numlit:int = 0;
            _sprite = new Sprite();
            
            var adjust:int = options.pixelH % 2 == 0 ? 1 : 0;
            var cols:int = options.oneSidedCols;
            var rows:int = options.pixelV;
            var pattern:Array = options.pattern;
            for (var x:int=0;x<cols;x++) 
            {
                for (var y:int=0;y<rows;y++) 
                {
                    
                    var i:int=y*cols+x;
                    if (isOn(pattern,i)) 
                    {
                        numlit++;
                        var boxL:PixelBox = new PixelBox(cols+x, y, options);
                        _sprite.addChild(boxL);
                            // mirror last two columns
                        if(x>0 || adjust) 
                        {
                            var boxR:PixelBox = new PixelBox(cols-x - adjust, y, options);
                            _sprite.addChild(boxR);
                        }
                    }
                }
                addChild(_sprite);
            }
        }

        private function generatePattern(options:InvaderSettings):void 
        {
            var cols:int = options.oneSidedCols;
            var rows:int = options.pixelV;
            
            // We have to limit to 31 because the int class work with the data type representing 
            // a 32-bit signed integer. If a number of 32 of higher is specified, the pattern will be 
            // filled with zeros and nothing will be drawn on screen.
            var power:int = Math.min(rows*cols, 31);
            var seed:uint = Math.pow(2,power);
            var arr:Array = [];
            var iNumber:int = Math.round(Math.random() * seed) ;
            
            while (iNumber>0) 
            {
                arr.unshift(iNumber%2 ? 1 : 0); 
                iNumber = Math.floor(iNumber/2);
            }
            // left pad with zeros
            while (arr.length<rows*cols) {
                arr.unshift(0);
            }
            
            options.pattern = arr;
        }
        
        private function isOn(pattern:Array,i:int):Boolean {
            return pattern[i] == 1;
        }

    }


    class PixelBox extends Sprite
    {
        public function PixelBox(posX:int, posY:int, settings:InvaderSettings = null)
        {
            super();
            if(!settings) settings = new InvaderSettings();
            var size:int = settings.pixelSize;
            this.graphics.lineStyle(0,settings.borderColor);
            this.graphics.beginFill(settings.backgroundColor);
            this.graphics.drawRect(0,0,size, size);
            this.graphics.endFill();
            this.x = posX * size;
            this.y = posY * size;
        }
    } 
        
    class InvaderSettings
    {
        // public static const COLOR_BLUE
        public static const BLUE:uint = 0x008FCC;
        public static const RED:uint = 0xE69D00;
        public static const YELLOW:uint = 0xCC0012;
        public static const PINK:uint = 0xBF007F;
        public static const BROWN:uint = 0x805933;
        public static const GREEN:uint = 0x78B300;
        
        private var _options:Object;

        public function InvaderSettings(settings:Object = null)
        {
            var defaults:Object = {pixelH: 5, pixelV: 5, pixelSize: 10, gap: 2, borderColor: 0x000000, backgroundColor: 0x000000, colors: [BLUE, RED, YELLOW, PINK, BROWN, GREEN]};
            _options = overwriteDefaults(settings, defaults);
            var colors:Array = _options.colors as Array;
            if(!_options.backgroundColor && !_options.borderColor) 
            {
                _options.backgroundColor = _options.borderColor = colors[random(colors.length-1)];
            } 
            else if (!_options.borderColor) 
            {
                _options.borderColor = _options.backgroundColor;
            }
            
        }
          
        public function set rows(value:int):void             { _options.rows            = value; }
        public function set cols(value:int):void             { _options.cols            = value; }
        public function set pattern(value:Array):void        { _options.pattern         = value; }
        public function set pixelSize(value:int):void        { _options.pixelSize       = value; }
        public function set gap(value:int):void              { _options.gap             = value; }
        public function set backgroundColor(value:uint):void { _options.backgroundColor = value; }
        public function set borderColor(value:uint):void     { _options.borderColor     = value; }

        public function get pixelH():int                    { return _options.pixelH;            }
        public function get pixelV():int                    { return _options.pixelV;            }  
        public function get oneSidedCols():int            { return Math.ceil(pixelH / 2);      } // one side of the symmetry. A mirror image of the pattern on the left will be copied on the right
        public function get pattern():Array               { return _options.pattern;         }
        public function get pixelSize():int               { return _options.pixelSize;       }
        public function get gap():int                     { return _options.gap;             }
        public function get backgroundColor():uint        { return _options.backgroundColor; }
        public function get borderColor():uint            { return _options.borderColor;     }
        
        private function overwriteDefaults(settings:Object, defaults:Object):Object
        {
            if(!settings) return defaults;  
            for (var p:String in defaults)
            {
                if(!settings.hasOwnProperty(p)) { settings[p] = defaults[p]; }      
            }
            return settings;
        }

        private function random(max:int):int
        {
            return Math.round(Math.random() * max);
        }
        
        public function toString():String
        {
            var arr:Array = [pattern, gap, pixelSize, backgroundColor, borderColor];
            return "[InvaderSettings] "  + arr.join(", ");
        }
    

    }     