/**
 * Copyright hrtsgt ( http://wonderfl.net/user/hrtsgt )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jGg8
 */

package{
	import flash.display.*;
	import flash.events.*;
	import flash.geom.*;
	import flash.filters.*;
	[SWF(width=465, height=465, backgroundColor=0x0, frameRate=60)]
	//ステージクリックで背景表示
	
	public class SpiroDesignOut extends Sprite{
		private static const SW:Number = 465;
		private static const SH:Number = 465;
		private var p:Point = new Point( SW/2, SH/2);//基準点
		private var wrapper:Sprite;//円用のラッパースプライト
		private var circle:Circle;//大円
		private var circles:Array = [];//小円たち
		private var r0:Number = 90;//大円の半径
		private var r1:Number = 58;//小円の半径
		private var d:Number = 20;//ドットを打つ位置(r1外周からの距離)
		private var n:Number = 3;//動かす小円の数
		private var a:Number = 0;
		private var _canvas:BitmapData;
	
		public function SpiroDesignOut(){
			Wonderfl.capture_delay(50);
			wrapper = new Sprite();
			wrapper.visible = false;
			addChild( wrapper );
			circle = new Circle( p.x, p.y, r0, 0x333333);
			wrapper.addChild( circle );
			
			for(var i:uint=0; i<n; i++){
				var c:Circle = new Circle( 0, 0, r1, 0xFFFFFF, 0.4);
				var c_:Circle = new Circle( r1+d, 0, 5, 0x666666);
				c_.graphics.lineStyle( 1, 0xCCCCCC, 0.8);
				c_.graphics.moveTo( 0, 0);
				c_.graphics.lineTo( r1+d, 0);
				c.addChild( c_ );
				wrapper.addChild( c );
				circles.push( c );
			}
			_canvas = new BitmapData( SW, SH, true, 0x80000000);
			addChild( new Bitmap(_canvas) );
			this.addEventListener( Event.ENTER_FRAME, update);//
			stage.addEventListener( MouseEvent.CLICK, onClick);//
		}
		
		private function update( e:Event ):void{
			_canvas.lock();
			for(var i:uint=0; i<n; i++){
				var c:Circle = circles[i];
				var r:Number = (a + i/n*360)*Math.PI/180;
				c.x = Math.cos(r)*(r0 + r1) + p.x;
				c.y = Math.sin(r)*(r0 + r1) + p.y;
				c.rotation = (a - i/n*360)*(r0/r1 + 1);
				
				var dot:Circle = new Circle( c.x + Math.cos(c.rotation*Math.PI/180)*(r1 + d), c.y + Math.sin(c.rotation*Math.PI/180)*(r1 + d), 1, 0xFFFFFF, 0.5);
				dot.filters = [ new GlowFilter( 0xFFFFFF, 0.8, 8, 8, 5, 2, false, false) ];				
				_canvas.draw( dot );
			}
			_canvas.unlock();
			a --;
		}
		
		private function onClick( e:MouseEvent ):void{
			wrapper.visible = !wrapper.visible;
		}
	
	}
}

import flash.display.Sprite;

class Circle extends Sprite{
	public function Circle( _x:Number, _y:Number, _r:Number, _color:uint, _alpha:Number=1):void{
		this.graphics.beginFill( _color, _alpha );
		this.graphics.drawCircle( _x, _y, _r);
	}
}