/**
 * Copyright 3f5 ( http://wonderfl.net/user/3f5 )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jGey
 */

package {
    import flash.filters.BlurFilter;
    import flash.display.BitmapData;
    import flash.display.Bitmap;
    import flash.display.Sprite;
    public class FlashTest extends Sprite {
        public function FlashTest() {
            var bitmap:ExBitmapData = new ExBitmapData(465, 465);
            var displayObj:Bitmap = new Bitmap(bitmap);
            
            addChild(displayObj);
            
            bitmap.setStrokeColor(0xFF0000);
            bitmap.lineTo(465, 465);
            bitmap.moveTo(0, 465);
            bitmap.lineTo(465, 0);
            bitmap.moveTo(0, 465 / 2);
            bitmap.lineTo(465, 465 / 2);
            bitmap.moveTo(465 / 2, 0);
            bitmap.lineTo(465 / 2, 465);
            
            var space:int = 10;
            var radius:int = space;
            
            while (radius < (465 / 2)) {
                bitmap.drawCircle(465 / 2, 465 / 2, radius);
                radius += space;
            }
            
        }
    }
}
import flash.geom.Point;
import flash.utils.Proxy;
import flash.display.BitmapData;
import flash.display.Sprite;

class ExBitmapData extends BitmapData {
    private var strokeColor:uint = 0x000000;
    private const position:Point = new Point(0, 0);
    
    public function ExBitmapData(width:int, height:int, transparent:Boolean = true, fillColor:uint = 0xFFFFFFFF):void {
        super(width, height, transparent, fillColor);
    }


    public function setStrokeColor(color:uint):void {
        strokeColor = color;
    }
    
    public function moveTo(x:int, y:int):void {
        position.x = x;
        position.y = y;
    }
    
    public function setPoint(x:int, y:int):void {
        setPixel(x, y, strokeColor);
    }

    public function lineTo(x:int, y:int):void {
        lock();

        var i:uint;

        var dX:int = (position.x > x) ? position.x - x : x - position.x;
        var dY:int = (position.y > y) ? position.y - y : y - position.y;

        var sX:int = (position.x > x) ? 1 : -1;
        var sY:int = (position.y > y) ? 1 : -1;
        
        var pX:int = x;
        var pY:int = y;
        
        var E:int;

        if (dX > dY) {
            E = - dX;
            for (i = 0; i <= dX; i++) {
                setPoint(x, y);
                
                x += sX;
                E += 2 * dY;
                if (E >= 0) {
                    y += sY;
                    E -= 2 * dX;
                }
            }
        } else {
            E = - dY;
            for (i = 0 ; i <= dY; i++) {
                setPoint(x, y);
                y += sY;
                E += 2 * dX;
                if (E >= 0) {
                    x += sX;
                    E -= 2 * dY;
                }
            }
        }
        
        moveTo(pX, pY);
        
        unlock();
    }
    
    public function drawCircle(x:int, y:int, radius:int):void {
        lock();
        
        var cx:uint, cy:int, d:int, dH:int, dD:int;

        d   = 1 - radius;
        dH  = 3;
        dD  = 5 - 2 * radius;
        cy  = radius;

       for (cx = 0; cx <= cy; cx++) {
            if (d < 0) {
                d += dH;
                dH += 2;
                dD += 2;
            }
            else {
                d += dD;
                dH += 2;
                dD += 4;
                --cy;
            }

            setPoint(cy + x, cx + y);
            setPoint(cx + x, cy + y);
            setPoint(-cx + x, cy + y);
            setPoint(-cy + x, cx + y);
            setPoint(-cy + x, -cx + y);
            setPoint(-cx + x, -cy + y);
            setPoint(cx + x, -cy + y);
            setPoint(cy + x, -cx + y);
        }
        
        unlock();
    }
}