/**
 * Copyright iooi ( http://wonderfl.net/user/iooi )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jGT4
 */

package  
{
    import flash.display.DisplayObject;
    import flash.display.Sprite;
    import flash.events.Event;
    import flash.geom.Matrix3D;
    import flash.geom.Vector3D;
    import org.papervision3d.cameras.SpringCamera3D;
    import org.papervision3d.core.math.Number3D;
    import org.papervision3d.events.InteractiveScene3DEvent;
    import org.papervision3d.materials.ColorMaterial;
    import org.papervision3d.materials.special.CompositeMaterial;
    import org.papervision3d.materials.utils.MaterialsList;
    import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.Cube;
    import org.papervision3d.objects.primitives.Plane;
    import org.papervision3d.objects.primitives.Sphere;
    import org.papervision3d.view.BasicView;
    
    /**
     * ...
     * @author iooi
     */
    [SWF (backgroundColor="#ffffff")]
    public class TwoArm extends BasicView 
    {
        private var Arm1:Arm
        private var Arm2:Arm
        private var obj_Ca:DisplayObject3D;
        private var _scene:Plane
        private var obj_mouse:Sphere;
        public function TwoArm(viewportWidth:Number = 640, viewportHeight:Number = 480, scaleToStage:Boolean = true, interactive:Boolean = true, cameraType:String = "Spring") 
        {
            super(viewportWidth, viewportHeight, scaleToStage, interactive, cameraType);
            
            //添加arm1
            var _ma2:WireframeMaterial = new WireframeMaterial(0x000000, 1, 1);
            _ma2.doubleSided = true
            var _mal:MaterialsList = new MaterialsList();
            _mal.addMaterial(_ma2, "all")
            Arm1 = new Arm(_mal, 100, 500, 100, 1, 1, 1);
            Arm1.z = -800
            Arm2 = new Arm(_mal, 100, 500, 100, 1, 1, 1);
            //Arm1.x = 300;
            scene.addChild(Arm1);
            scene.addChild(Arm2);
            Arm2.x = Arm1.joint1.x
            Arm2.y = Arm1.joint1.y
            Arm2.z = Arm1.joint1.z
            //Arm2.x = 
            Arm1.useOwnContainer = true;
            Arm2.useOwnContainer = true;
            
            //添加摄像机
            obj_Ca = new DisplayObject3D()
            SpringCamera3D(camera).positionOffset = new Number3D(0, 0, -2000);
            SpringCamera3D(camera).lookOffset = new Number3D(0, 0, 0);
            SpringCamera3D(camera).target = obj_Ca
            obj_Ca.rotationX = -75
            scene.addChild(obj_Ca);
            
            
            //添加球体
            var _ma:ColorMaterial = new ColorMaterial(0x529845, 1, true);
            var _maCL:CompositeMaterial = new CompositeMaterial();
            _maCL.addMaterial(_ma2);
            _maCL.addMaterial(_ma)
            _maCL.doubleSided = true;
            _maCL.interactive = true;
            _scene = new Plane(_maCL, 5000, 5000, 10,10);
            _scene.z = 0;
            _scene.addEventListener(InteractiveScene3DEvent.OBJECT_MOVE, Move)
            _scene.addEventListener(InteractiveScene3DEvent.OBJECT_CLICK, Click)
            scene.addChild(_scene);
            
            //
            obj_mouse = new Sphere(_ma2, 20,1,1);
            scene.addChild(obj_mouse);
            obj_mouse.useOwnContainer = true;
            
            startRendering();
        }
        
        private var Vector3D_arm1Rotion:Vector3D = new Vector3D()
        private function Move(e:InteractiveScene3DEvent):void
        {
            obj_mouse.x = e.renderHitData.x
            obj_mouse.y = e.renderHitData.y
            obj_mouse.z = e.renderHitData.z
        }
        
        private function Click(e:InteractiveScene3DEvent):void
        {
            
        }
        
        private var Arm1At:DisplayObject3D = new DisplayObject3D()
        private var enid:Boolean = true;
        override protected function onRenderTick(event:Event = null):void 
        {
            Arm2.lookAt(obj_mouse);
            super.onRenderTick(event);
            scene.addChild(Arm1At)
            Arm1At.x = obj_mouse.x - (Arm2.joint1.sceneX - Arm2.joint0.sceneX)
            Arm1At.y = obj_mouse.y - (Arm2.joint1.sceneY - Arm2.joint0.sceneY)
            Arm1At.z = obj_mouse.z - (Arm2.joint1.sceneZ - Arm2.joint0.sceneZ)
            
            Arm1.lookAt(Arm1At);
            super.onRenderTick(event);
            Arm2.x = Arm1.joint1.sceneX
            Arm2.y = Arm1.joint1.sceneY
            Arm2.z = Arm1.joint1.sceneZ
                    
            super.onRenderTick(event);
            
            
        }
        
        private function Rxyz(x1:Number,y1:Number,z1:Number):Vector3D
        {
            var sp:Sprite = new Sprite()
            sp.transform.matrix3D = new Matrix3D();
            sp.transform.matrix3D.pointAt(new Vector3D(x1, -y1, z1))
            return new Vector3D(sp.rotationX, sp.rotationY, sp.rotationZ);
        }
        
    }

}

import org.papervision3d.materials.WireframeMaterial;
    import org.papervision3d.objects.DisplayObject3D;
    import org.papervision3d.objects.primitives.Sphere;
    import org.papervision3d.Papervision3D;
    import org.papervision3d.core.geom.*;
    import org.papervision3d.core.geom.renderables.Triangle3D;
    import org.papervision3d.core.geom.renderables.Vertex3D;
    import org.papervision3d.core.log.PaperLogger;
    import org.papervision3d.core.math.Number3D;
    import org.papervision3d.core.math.NumberUV;
    import org.papervision3d.core.proto.*;
    import org.papervision3d.materials.utils.MaterialsList;    

class Arm extends TriangleMesh3D
    {
        /**
        * Number of segments per axis. Defaults to 1.
        */
        public var segments :Number3D;
    
        /**
        * No faces selected.
        */
        static public var NONE   :int = 0x00;
    
        /**
        * Front face selection
        */
        static public var FRONT  :int = 0x01;
    
        /**
        * Back face selection
        */
        static public var BACK   :int = 0x02;
    
        /**
        * Right face selection
        */
        static public var RIGHT  :int = 0x04;
    
        /**
        * Left face selection
        */
        static public var LEFT   :int = 0x08;
    
        /**
        * Top face selection
        */
        static public var TOP    :int = 0x10;
    
        /**
        * Bottom face selection
        */
        static public var BOTTOM :int = 0x20;
    
        /**
        * All faces selected.
        */
        static public var ALL    :int = FRONT + BACK + RIGHT + LEFT + TOP + BOTTOM;
        
        private var insideFaces  :int;
        private var excludeFaces :int;
    
        // ___________________________________________________________________________________________________
        //                                                                                               N E W
        // NN  NN EEEEEE WW    WW
        // NNN NN EE     WW WW WW
        // NNNNNN EEEE   WWWWWWWW
        // NN NNN EE     WWW  WWW
        // NN  NN EEEEEE WW    WW
    
        /**
        * Create a new Cube object.
        * <p/>
        * @param    materials    A MaterialObject3D object that contains the material properties of the object.
        * 
        * Supported materials are: front, back, right, left, top, bottom & all, for example: 
        * 
        *    var materials:MaterialsList = new MaterialsList(
        *    {
        *        all:    new MovieAssetMaterial( "Front", true ), // This is the default material
        *        front:  new MovieAssetMaterial( "Front", true ),
        *        back:   new MovieAssetMaterial( "Back", true ),
        *        right:  new MovieAssetMaterial( "Right", true ),
        *        left:   new MovieAssetMaterial( "Left", true ),
        *        top:    new MovieAssetMaterial( "Top", true ),
        *        bottom: new MovieAssetMaterial( "Bottom", true )
        *    } );
        * 
        * <p/>
        * @param    width            [optional] - Desired width.
        * <p/>
        * @param    depth            [optional] - Desired depth.
        * <p/>
        * @param    height            [optional] - Desired height.
        * <p/>
        * @param    segmentsS        [optional] - Number of segments sagitally (plane perpendicular to width). Defaults to 1.
        * <p/>
        * @param    segmentsT        [optional] - Number of segments transversally (plane perpendicular to depth). Defaults to segmentsS.
        * <p/>
        * @param    segmentsH        [optional] - Number of segments horizontally (plane perpendicular to height). Defaults to segmentsS.
        * <p/>
        * @param    insideFaces        [optional] - Faces that are visible from the inside. Defaults to Cube.NONE.
        *
        * You can add or sustract faces to your selection. For examples: Cube.FRONT+Cube.BACK or Cube.ALL-Cube.Top.
        * 
        * <p/>
        * @param    excludeFaces    [optional] - Faces that will not be created. Defaults to Cube.NONE.
        * 
        * You can add or sustract faces to your selection. For examples: Cube.FRONT+Cube.BACK or Cube.ALL-Cube.Top.
        * 
        * <p/>
        */
        public var joint0:Sphere;
        public var joint1:Sphere;
        public function Arm( materials:MaterialsList, width:Number=500, depth:Number=500, height:Number=500, segmentsS:int=1, segmentsT:int=1, segmentsH:int=1, insideFaces:int=0, excludeFaces:int=0 )
        {
            super( materials.getMaterialByName( "all" ), new Array(), new Array(), null );
            
            add:
            {
            var jointR:int = Math.min(width, depth, height)
            var _ma2:WireframeMaterial = new WireframeMaterial(0x000000, 1, 1);
            joint0 = new Sphere(_ma2,jointR/2,1,1)
            this.addChild(joint0);
            joint1 = new Sphere(_ma2,jointR/2,1,1)
            joint1.z = depth + jointR;
            //joint1.useOwnContainer = true;
            //joint1.alpha = 0;
            this.addChild(joint1)
            
            //var jointR:int = Math.min(width, depth, height)
            //joint0 = new DisplayObject3D()
            //this.addChild(joint0);
            //joint1 = new DisplayObject3D()
            //joint1.z = depth + jointR;
            //this.addChild(joint1)
            }
            
            this.materials = materials;
            
            this.insideFaces  = insideFaces;
            this.excludeFaces = excludeFaces;
    
            segments = new Number3D( segmentsS, segmentsT, segmentsH );
    
            buildCube( width, height, depth );
        }
    
        protected function buildCube( width:Number, height:Number, depth:Number ):void
        {
            var width2  :Number = width  /2;
            var height2 :Number = height /2;
            var depth2  :Number = depth  /2;
            
            if( ! (excludeFaces & FRONT) )
                buildPlane( "front", "x", "y", width, height, depth2, ! Boolean( insideFaces & FRONT ) );
    
            if( ! (excludeFaces & BACK) )
                buildPlane( "back", "x", "y", width, height, -depth2, Boolean( insideFaces & BACK ) );
    
            if( ! (excludeFaces & RIGHT) )
                buildPlane( "right", "z", "y", depth, height, width2, Boolean( insideFaces & RIGHT ) );
    
            if( ! (excludeFaces & LEFT) )
                buildPlane( "left", "z", "y", depth, height, -width2, ! Boolean( insideFaces & LEFT ) );
    
            if( ! (excludeFaces & TOP) )
                buildPlane( "top", "x", "z", width, depth, height2, Boolean( insideFaces & TOP ) );
    
            if( ! (excludeFaces & BOTTOM) )
                buildPlane( "bottom", "x", "z", width, depth, -height2, ! Boolean( insideFaces & BOTTOM ) );

            mergeVertices();
            
            for each(var t:Triangle3D in this.geometry.faces){
                t.renderCommand.create = createRenderTriangle;
            }
            
            this.geometry.ready = true;
            
            if(Papervision3D.useRIGHTHANDED)
                this.geometry.flipFaces();
        }
    
        protected function buildPlane( mat:String, u:String, v:String, width:Number, height:Number, depth:Number, reverse:Boolean=false ):void
        {
            var matInstance:MaterialObject3D;
            if( ! (matInstance= materials.getMaterialByName( mat )))
            {
                if(!(matInstance=materials.getMaterialByName( "all" ))){
                    PaperLogger.warning( "Required material not found in given materials list. Supported materials are: front, back, right, left, top, bottom & all." );
                    return;
                }
                
            }
            
            matInstance.registerObject(this); // needed for the shaders.
            // Find w depth axis
            var w :String;
            if( (u=="x" && v=="y") || (u=="y" && v=="x") ) w = "z";
            else if( (u=="x" && v=="z") || (u=="z" && v=="x") ) w = "y";
            else if( (u=="z" && v=="y") || (u=="y" && v=="z") ) w = "x";
    
            // Mirror
            var rev :Number = reverse? -1 : 1;
    
            // Build plane
            var gridU    :Number = this.segments[ u ];
            var gridV    :Number = this.segments[ v ];
            var gridU1   :Number = gridU + 1;
            var gridV1   :Number = gridV + 1;
    
            var vertices   :Array = this.geometry.vertices;
            var faces      :Array = this.geometry.faces;
            var planeVerts :Array = new Array();
    
            var textureU :Number = width /2;
            var textureV :Number = height /2;
    
            var incU     :Number = width / gridU;
            var incV     :Number = height / gridV;
    
            // Vertices
            for( var iu:int = 0; iu < gridU1; iu++ )
            {
                for( var iv:int = 0; iv < gridV1; iv++ )
                {
                    var vertex:Vertex3D = new Vertex3D();
                    
                    switch (mat)
                    {
                        case "front":
                        vertex[ u ] = (iu * incU - textureU) * rev;
                        vertex[ v ] = iv * incV - textureV;
                        vertex[ w ] = depth * 2 + 50;
                        break;
                        case "back":
                        vertex[ u ] = (iu * incU - textureU) * rev;
                        vertex[ v ] = iv * incV - textureV;
                        vertex[ w ] = depth * 0 + 50;
                        break;
                        case "right":
                        vertex[ u ] = (iu * incU + 50) * rev;
                        vertex[ v ] = iv * incV - textureV;
                        vertex[ w ] = depth;
                        break;
                        case "left":
                        vertex[ u ] = (iu * incU - textureU*2 - 50) * rev;
                        vertex[ v ] = iv * incV - textureV;
                        vertex[ w ] = depth;
                        break;
                        case "top":
                        vertex[ u ] = (iu * incU - textureU) * rev;
                        vertex[ v ] = iv * incV + 50;
                        vertex[ w ] = depth;
                        break;
                        case "bottom":
                        vertex[ u ] = (iu * incU - textureU) * rev;
                        vertex[ v ] = iv * incV + 50;
                        vertex[ w ] = depth;
                        break;
                    }
                    
                    
                    vertices.push( vertex );
                    planeVerts.push( vertex );
                }
            }
    
            // Faces
            var uvA :NumberUV;
            var uvC :NumberUV;
            var uvB :NumberUV;
    
            for(  iu = 0; iu < gridU; iu++ )
            {
                for(  iv= 0; iv < gridV; iv++ )
                {
                    // Triangle A
                    var a:Vertex3D = planeVerts[ iu     * gridV1 + iv     ];
                    var c:Vertex3D = planeVerts[ iu     * gridV1 + (iv+1) ];
                    var b:Vertex3D = planeVerts[ (iu+1) * gridV1 + iv     ];
    
                    uvA =  new NumberUV( iu     / gridU, iv     / gridV );
                    uvC =  new NumberUV( iu     / gridU, (iv+1) / gridV );
                    uvB =  new NumberUV( (iu+1) / gridU, iv     / gridV );
    
                    faces.push(new Triangle3D(this, [ a, b, c ], matInstance, [ uvA, uvB, uvC ] ) );
    
                    // Triangle B
                    a = planeVerts[ (iu+1) * gridV1 + (iv+1) ];
                    c = planeVerts[ (iu+1) * gridV1 + iv     ];
                    b = planeVerts[ iu     * gridV1 + (iv+1) ];
    
                    uvA =  new NumberUV( (iu+1) / gridU, (iv+1) / gridV );
                    uvC =  new NumberUV( (iu+1) / gridU, iv     / gridV );
                    uvB =  new NumberUV( iu     / gridU, (iv+1) / gridV );
    
                    faces.push(new Triangle3D(this, [ c, a, b ], matInstance, [ uvC, uvA, uvB ] ) );
                }
            }
        }
        
        public function destroy():void
        {
            var mat:MaterialObject3D;
            for each(mat in materials){
                mat.unregisterObject(this);
            }
        }
        
        
    }