/**
 * Copyright heroboy ( http://wonderfl.net/user/heroboy )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jFog
 */

// forked from buddylee101's Happy New Year
package  
{
    import flash.display.*;
    import flash.events.*;
    import flash.filters.BlurFilter;
    import flash.system.LoaderContext;
    import flash.geom.*;
    import flash.net.URLRequest;
    import caurina.transitions.Tweener;
    import caurina.transitions.properties.ColorShortcuts;
    
    /**
     * ...
     * @author buddylee101
     */
    [SWF(backgroundColor = "#292929", frameRate = "60", width = "465", height = "465")]
    public class FlashTest extends MovieClip
    {
        private const IMAGE_PATH:String = "http://assets.wonderfl.net/images/related_images/5/57/572d/572dfb2b542de9e8644c4629daef4be18f40a043";
        
        private const POINT_MARGIN:Number = 3;
        private const MAX_SPEED:Number = 0.08;
        
        //描画するところ
        private var _canvas:BitmapData;
        //_canvasのBitmap
        private var _cBm:Bitmap;
        
        //キラキラ用
        private var _glow:BitmapData;
        //_glowのBitmap
        private var _gBm:Bitmap;
        private var _glowMtx:Matrix;
        private var _color:uint = 0;
        
        //完成図
        private var _text:Bitmap;
        
        //開始のポイントたち
        private var _sPoints:Vector.<Particle> = new Vector.<Particle>();
        //終了のポイントたち
        private var _ePoints:Vector.<Particle> = new Vector.<Particle>();
        //退避用のポイントたち
        private var _tPoints:Vector.<Particle> = new Vector.<Particle>();
        
        private var _wRate:Number;
        private var _hRate:Number;
        
        public function FlashTest() 
        {
            _init();
            Wonderfl.capture_delay(3);
        }
        
        private function _init():void
        {
            ColorShortcuts.init();
            
            _canvas = new BitmapData(465, 465, true, 0x0);
            _cBm = new Bitmap(_canvas);
            _cBm.smoothing = true;
            _cBm.alpha = 0;
            addChild(_cBm);
            
            _glow = new BitmapData(_canvas.width / 10, _canvas.height / 10, false, 0x0);
            _gBm = new Bitmap(_glow, PixelSnapping.NEVER, true);
            _gBm.scaleX = _gBm.scaleY = 10;
            _gBm.blendMode = BlendMode.ADD;
            _gBm.alpha = 0;
            addChild(_gBm);
            _glowMtx = new Matrix(0.10, 0, 0, 0.10);
            
            _loadImage();
        }
        
        
        private function _loadImage():void
        {
            var _loader:Loader = new Loader();
            _loader.contentLoaderInfo.addEventListener(Event.COMPLETE, _onComplete, false, 0, true);
            _loader.load(new URLRequest(IMAGE_PATH), new LoaderContext(true));
        }
        
        
        private function _onComplete(e:Event):void 
        {
            var _loader:Loader = e.target.loader as Loader;
            var _bmd:BitmapData = Bitmap(_loader.content).bitmapData;
            for (var i:int = 0; i < _bmd.width; i += POINT_MARGIN) {
                for (var j:int = 0; j < _bmd.height; j += POINT_MARGIN) {
                    _pushPixel(_bmd, i, j);
                }
            }
            _setPixelImage();
            
            //完成図配置
            var _textBmd:BitmapData = _bmd.clone();
            _text = new Bitmap(_textBmd);
            _text.smoothing = true;
            _text.x = 5;
            _text.y = 150;
            _text.alpha = 0;
            addChildAt(_text, 0);
            trace(_text.width, _text.height);
            
            //addEventListener(Event.ENTER_FRAME, _update, false, 0, true);
            //addEventListener(Event.ENTER_FRAME, _checkLength, false, 0, true);
            
            stage.addEventListener(MouseEvent.CLICK, _restart, false, 0, true);
        }
        
        private function _restart(e:MouseEvent):void 
        {
            Tweener.removeAllTweens();
            // 初期化
            _sPoints = new Vector.<Particle>();
            removeEventListener(Event.ENTER_FRAME, _update);
            removeEventListener(Event.ENTER_FRAME, _checkLength);
            _cBm.alpha = 1;
            _gBm.alpha = 1;
            _text.alpha = 0;
            _canvas.fillRect(_canvas.rect, 0x0);
            _glow.fillRect(_canvas.rect, 0x0);
            
            // 開始位置をランダムで配置し、それを開始のポイントたちに格納
            _setPixelImage();
            // 移動スタート
            addEventListener(Event.ENTER_FRAME, _update, false, 0, true);
            //addEventListener(Event.ENTER_FRAME, _checkLength, false, 0, true);
        }
        
        private function _pushPixel(bmd:BitmapData, x:Number, y:Number):void
        {
            var _p:Particle = new Particle();
            _p._x = x + 5;
            _p._y = y + 150;
            _p._c = bmd.getPixel32(x, y);
            if (_p._c != 0x0) {
                _ePoints.push(_p);
            }
        }
        
        private function _setPixelImage():void
        {
            var _l:int = _ePoints.length;
            for (var i:int = 0; i < _l; i++)
            {
                var _p:Particle = new Particle();
                _p._x = Math.random() * 465;
                _p._y = Math.random() * 465;
                
                // スタート位置の描画
                _canvas.setPixel32(_p._x, _p._y, _ePoints[i]._c);
                _sPoints.push(_p);
            }
        }
        
        private function _update(e:Event):void
        {
            _canvas.lock();
            _glow.fillRect(_canvas.rect, 0x0);
            _canvas.applyFilter(_canvas, _canvas.rect, new Point(), new BlurFilter(5, 5));
            //_canvas.fillRect(_canvas.rect,0x0);
            _tPoints = new Vector.<Particle>();
            _tPoints = _ePoints.slice(0);
            
            var _i:int = _tPoints.length;
            while (_i--) {
                var _s:Particle = _sPoints[_i];
                var _e:Particle = _ePoints[_i];
                _s._speed += _s._speedChange;
                if (_s._speed >= MAX_SPEED) {
                    _s._speed = MAX_SPEED;
                }
                _s._x += (_e._x - _s._x) * _s._speed * (Math.random() * 2);
                _s._y += (_e._y - _s._y) * _s._speed * (Math.random() * 2);
                if (Math.abs(_e._x - _s._x) < 1 && Math.abs(_e._y - _s._y) < 1)
                {
                    _s._x = _e._x;
                    _s._y = _e._y;
                    _tPoints.splice(_i, 1);
                }
                _canvas.setPixel32(_s._x, _s._y, _e._c);
            }
            _canvas.unlock();
            
            _glow.draw(_canvas, _glowMtx);
            
            if (_tPoints.length <= 0) {
                removeEventListener(Event.ENTER_FRAME, _update);
            }
        }
        
        private function _checkLength(e:Event):void
        {
            if (_tPoints.length <= 500) {
                removeEventListener(Event.ENTER_FRAME, _checkLength);
                Tweener.addTween(_text, { alpha:1, time:2.0, transition:"Linear" } );
                Tweener.addTween(_cBm, { alpha:0, time:2.0, transition:"Linear" } );
                Tweener.addTween(_gBm, { alpha:0, time:2.0, transition:"Linear" } );
            }
        }
        
    }

}

class Particle
{
    public var _x:Number;
    public var _y:Number;
    public var _speed:Number = 0;
    public var _speedChange:Number = Math.random() * 0.001 + 0.0001;
    public var _c:uint;
    
    public function Particle() { }
}