/**
 * Copyright narutohyper ( http://wonderfl.net/user/narutohyper )
 * MIT License ( http://www.opensource.org/licenses/mit-license.php )
 * Downloaded from: http://wonderfl.net/c/jFkN
 */

package
{
    import alternativ7.engine3d.materials.TextureMaterial;
    import alternativ7.engine3d.primitives.Plane;
    import flash.display.BitmapData;
    import flash.display.Sprite;
    import flash.events.Event;
    import alternativ7.engine3d.containers.ConflictContainer
    import alternativ7.engine3d.core.View
    import alternativ7.engine3d.core.Camera3D
    import alternativ7.engine3d.controllers.SimpleObjectController
    import alternativ7.engine3d.primitives.Box
    import alternativ7.engine3d.materials.FillMaterial
    import alternativ7.engine3d.loaders.MaterialLoader;
    import alternativ7.engine3d.core.Vertex;
    import flash.display.StageAlign;
    import flash.display.StageQuality;
    import flash.display.StageScaleMode;
    
    /**
     * TokyoTeraco11 その7
     * オブジェクト（メッシュ）の形を変えてみよう
     *
     * @author narutohyper
     */
    [SWF(backgroundColor="#000000", frameRate="60")]
    public class Main extends Sprite
    {
        
        public function Main():void
        {
            if (stage) init();
            else addEventListener(Event.ADDED_TO_STAGE, init);
        }
        
        private function init(e:Event = null):void
        {
            removeEventListener(Event.ADDED_TO_STAGE, init);
            // entry point
            
            stage.scaleMode = StageScaleMode.NO_SCALE;
            stage.align = StageAlign.TOP_LEFT;
            stage.quality = StageQuality.BEST;
            
            //ルートオブジェクト（Root Object）
            var container:ConflictContainer = new ConflictContainer();

            //ビューを作る
            var view:View = new View(stage.stageWidth, stage.stageHeight);
            addChild(view);

            //カメラを作る
            var camera:Camera3D = new Camera3D();

            //カメラとビューを関連付ける
            camera.view = view;

            //カメラを撮影する3D空間に配置する
            container.addChild(camera);

            //カメラの位置を調整
            camera.x = 0;
            camera.y = -500;
            camera.z = 0;

            //カメラをコントローラ
            var cameraController:SimpleObjectController = new SimpleObjectController(stage, camera, 10);
            cameraController.mouseSensitivity = 0
            cameraController.unbindAll()
            cameraController.lookAtXYZ(0, 0, 0)
            
            //オブジェクト
            var segment:uint = 36
            var plane:Plane = new Plane(360, 360, segment, 1, true);
            //マテリアル
            var material:FillMaterial = new FillMaterial(0x666666, 1, 0, 1);
            
            plane.setMaterialToAllFaces(material);
            container.addChild(plane)
            plane.rotationX=Math.PI/180*20;
            //Mesh.verticesを確認
            for (var item:Object in plane.vertices)
            {
                trace(item, plane.vertices[item])
            }
            
            7
            
            //オブジェクトコントローラを追加
            var objectController:SimpleObjectController = new SimpleObjectController(stage, plane, 10);
            objectController.mouseSensitivity = 1
            objectController.unbindAll()
            
            
            addEventListener(Event.ENTER_FRAME, onEnterFrame)

            
            
            var RADIAN:Number = Math.PI/180
            
            function onEnterFrame(e:Event):void
            {
                
                //カメラコントローラの操作をコントロールオブジェクトに反映
                cameraController.update();
                
                //オブジェクトコントローラの操作をコントロールオブジェクトに反映
                objectController.update();
                
                //レンダリング
                camera.render();
            }
                    
            
        }
        

        
    }
    
}